/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.util.HttpUtil;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.yundt.module.customer.api.user.IWeixinService;
import com.dtyunxi.yundt.module.customer.api.user.dto.response.WxUserInfoDto;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class IWeixinServiceImpl
implements IWeixinService {
    private static final Logger logger = LoggerFactory.getLogger(IWeixinServiceImpl.class);
    @Resource
    private ICacheService cacheService;
    private static final String ACCESS_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token";
    private static final String TICKET_URL = "https://api.weixin.qq.com/cgi-bin/ticket/getticket";
    private static final String CODE_URL = "https://open.weixin.qq.com/connect/oauth2/authorize";
    private static final String AUTH_ACCESS_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/access_token";
    private static final String USERINFO_URL = "https://api.weixin.qq.com/sns/userinfo";
    private static final int EFFECT_TIME_SEC = 7150;
    @Value(value="${appid:}")
    private String appid;
    @Value(value="${appsecret:}")
    private String secret;
    @Value(value="${mini.appid:}")
    private String miniAppid;
    @Value(value="${mini.appsecret:}")
    private String miniAppsecret;
    @Value(value="${systemCodeUri:}")
    private String systemCodeUri;
    @Autowired(required=false)
    private RestTemplateBuilder builder;
    private RestTemplate template;
    @Autowired
    private IObjectStorageService ossService;
    @Autowired
    private OssRegistryVo ossRegistryVo;
    private static final String WXACODE = "/wxa/getwxacode?access_token={accessToken}";

    @PostConstruct
    public void init() {
        this.template = null != this.builder ? this.builder.setConnectTimeout(Duration.ofMillis(1000L)).setReadTimeout(Duration.ofMillis(1000L)).rootUri("https://api.weixin.qq.com/").build() : null;
    }

    public HashMap<String, String> jsSdkSign(String url) {
        HashMap<String, String> jssdk = new HashMap<String, String>();
        try {
            String nonce_str = this.createNonceStr();
            String timestamp = String.valueOf(System.currentTimeMillis());
            String jsapi_ticket = this.getJsApiTicket();
            String string1 = "jsapi_ticket=" + jsapi_ticket + "&noncestr=" + nonce_str + "&timestamp=" + timestamp + "&url=" + url;
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(string1.getBytes("UTF-8"));
            String signature = this.byteToHex(crypt.digest());
            jssdk.put("appId", this.appid);
            jssdk.put("timestamp", timestamp);
            jssdk.put("nonceStr", nonce_str);
            jssdk.put("signature", signature);
        }
        catch (UnsupportedEncodingException e) {
            throw new BizException("\u83b7\u53d6\u5fae\u4fe1\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        catch (BizException e) {
            throw new BizException("\u83b7\u53d6\u5fae\u4fe1\u914d\u7f6e\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new BizException("\u83b7\u53d6\u5fae\u4fe1\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        return jssdk;
    }

    private String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    private String createNonceStr() {
        return UUID.randomUUID().toString();
    }

    public String getAccessToken(boolean isMini) {
        String tokenKey = "access_token" + (isMini ? "_mini" : "");
        String accessToken = (String)this.cacheService.getCache(tokenKey, String.class);
        String tAppId = this.appid;
        String tAppSecret = this.secret;
        if (isMini) {
            tAppId = this.miniAppid;
            tAppSecret = this.miniAppsecret;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)accessToken)) {
            String param = "grant_type=client_credential&appid=" + tAppId + "&secret=" + tAppSecret;
            String jstoken = HttpUtil.sendGet((String)ACCESS_TOKEN_URL, (String)param);
            accessToken = JSONObject.parseObject((String)jstoken).getString("access_token");
            if (null == accessToken) {
                throw new BizException(jstoken);
            }
            this.cacheService.setCache(tokenKey, (Object)accessToken, 7150);
        }
        logger.info("=============access_token={}", (Object)accessToken);
        return accessToken;
    }

    public String getJsApiTicket() {
        String jsapiTicket = (String)this.cacheService.getCache("jsapi_ticket", String.class);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)jsapiTicket)) {
            String accessToken = this.getAccessToken(false);
            String ticketParam = "access_token=" + accessToken + "&type=jsapi";
            String jsticket = HttpUtil.sendGet((String)TICKET_URL, (String)ticketParam);
            jsapiTicket = JSONObject.parseObject((String)jsticket).getString("ticket");
            if (null == jsapiTicket) {
                throw new BizException(jsticket);
            }
            this.cacheService.setCache("jsapi_ticket", (Object)jsapiTicket, 7150);
        }
        logger.info("=============jsapi_ticket={}", (Object)jsapiTicket);
        return jsapiTicket;
    }

    public String getCodeUri(String redirectUri) {
        String state = UUID.randomUUID().toString();
        this.cacheService.add(state, (Object)redirectUri);
        String middleRedirectUri = URLEncoder.encode(this.systemCodeUri);
        String param = "appid=" + this.appid + "&redirect_uri=" + middleRedirectUri + "&response_type=code&scope=snsapi_base&state=" + state + "#wechat_redirect";
        String uri = "https://open.weixin.qq.com/connect/oauth2/authorize?" + param;
        return uri;
    }

    public String getOpenId(String code) {
        String param = "appid=" + this.appid + "&secret=" + this.secret + "&code=" + code + "&grant_type=authorization_code";
        String accessTokenStr = HttpUtil.sendGet((String)AUTH_ACCESS_TOKEN_URL, (String)param);
        logger.info("code={},\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)code, (Object)accessTokenStr);
        String openId = JSONObject.parseObject((String)accessTokenStr).getString("openid");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)openId)) {
            throw new BizException("invalid code");
        }
        return openId;
    }

    public WxUserInfoDto getUserInfo(String accessToken, String openId) {
        String param = "access_token=" + accessToken + "&openid=" + openId + "&lang=zh_CN";
        String userInfo = HttpUtil.sendGet((String)USERINFO_URL, (String)param);
        WxUserInfoDto userInfoDto = (WxUserInfoDto)ObjectHelper.Json2Bean((String)userInfo, WxUserInfoDto.class);
        logger.info("\u5fae\u4fe1\u7528\u6237\u4fe1\u606f={}", (Object)userInfo);
        return userInfoDto;
    }

    public String getWxaCode(String path, int width) {
        String key;
        String truePath;
        if (width < 280) {
            width = 280;
        }
        if (width > 1280) {
            width = 1280;
        }
        if (StringUtils.isEmpty((Object)(truePath = (String)this.cacheService.getCache(key = MD5Util.getMd5ByString((String)(path + width)), String.class)))) {
            String accessToken = this.getAccessToken(true);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("accessToken", accessToken);
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("path", path);
            body.put("width", width + "");
            byte[] images = (byte[])this.template.postForObject(WXACODE, body, byte[].class, params);
            String fileName = UUID.randomUUID().toString() + ".png";
            this.ossService.put(this.ossRegistryVo.getBucketName(), fileName, images);
            truePath = this.ossRegistryVo.getEndpoint() + "/" + fileName;
            this.cacheService.setCache(key, (Object)truePath, 604800);
        }
        return truePath;
    }
}

