/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.util;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerUtil {
    private static int maxPerMSECSize = 99999;
    @Autowired
    ICacheService cacheService;
    private static CustomerUtil customerUtil;
    private static final String ACCOUNT_NO = "ACCOUNTNO";
    private static final Integer STR_FORMAT_10;
    private static final Integer STR_FORMAT_100;
    private static final Integer STR_FORMAT_1000;
    private static final Integer STR_FORMAT_10000;

    @PostConstruct
    public void init() {
        customerUtil = this;
        CustomerUtil.customerUtil.cacheService = this.cacheService;
    }

    public static String generateTradeNo(String prefix) {
        long nowLong = Long.parseLong(new SimpleDateFormat("yyyyMMdd").format(new Date()));
        String timeStr = String.valueOf(nowLong);
        Long result = CustomerUtil.customerUtil.cacheService.incr(ACCOUNT_NO);
        Long mod = result % (long)maxPerMSECSize;
        String resultNo = "" + mod;
        if (mod < (long)STR_FORMAT_10.intValue()) {
            resultNo = "0000" + mod;
        } else if (mod >= (long)STR_FORMAT_10.intValue() && mod < (long)STR_FORMAT_100.intValue()) {
            resultNo = "000" + mod;
        } else if (mod >= (long)STR_FORMAT_100.intValue() && mod < (long)STR_FORMAT_1000.intValue()) {
            resultNo = "00" + mod;
        } else if (mod >= (long)STR_FORMAT_1000.intValue() && mod < (long)STR_FORMAT_10000.intValue()) {
            resultNo = "0" + mod;
        }
        return prefix + timeStr + resultNo;
    }

    static {
        STR_FORMAT_10 = 10;
        STR_FORMAT_100 = 100;
        STR_FORMAT_1000 = 1000;
        STR_FORMAT_10000 = 10000;
    }
}

