/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerAreaListExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeRegionQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleExpandRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserOrgizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserOrgExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.EmployeeExpandReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.SellerEmployeeImportDto;
import com.dtyunxi.yundt.module.customer.api.user.IEmployeeExpand2Service;
import com.dtyunxi.yundt.module.customer.api.user.ISellerEmployeeExtService;
import com.dtyunxi.yundt.module.customer.biz.util.CommonUtil;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.CustomerExtReqDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SellerEmployeeExtServiceImpl
implements ISellerEmployeeExtService {
    private static final Logger logger = LoggerFactory.getLogger(SellerEmployeeExtServiceImpl.class);
    @Resource
    private IAccessQueryApi accessQueryApi;
    @Resource
    private IEmployeeRegionQueryApi employeeRegionQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;
    @Resource
    private IEmployeeExpand2Service employeeExpand2Service;
    @Resource
    private IUserOrgExpandQueryApi userOrgExpandQueryApi;
    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;

    public RestResponse<List<SellerEmployeeImportDto>> doSellerEmployeeImport(List<SellerEmployeeImportDto> importDataList) {
        logger.info("\u5546\u5bb6\u4eba\u5458\u5bfc\u5165\u6570\u636e\u5927\u5c0f:{}", (Object)JSON.toJSONString((Object)importDataList.size()));
        List<SellerEmployeeImportDto> successList = importDataList.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        List accountList = successList.stream().map(SellerEmployeeImportDto::getAccount).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        Map userOrgMap = this.employeeExpand2Service.getAccoutMap(accountList);
        importDataList = this.verifyData(importDataList, userOrgMap);
        List roleNameList = importDataList.stream().map(SellerEmployeeImportDto::getRoleName).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        Map roleMap = this.employeeExpand2Service.getRoleMap(roleNameList, null);
        logger.info("roleMap:{}", (Object)JSON.toJSONString((Object)importDataList.size()));
        HashMap<String, List<CustomerAreaRespDto>> customerAreasMap = new HashMap();
        List governAreaList = successList.stream().filter(data -> StringUtils.isNotEmpty((CharSequence)data.getGovernArea())).map(SellerEmployeeImportDto::getGovernArea).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(governAreaList)) {
            List customerAreaList;
            CustomerAreaListExtReqDto areaListReqDto = new CustomerAreaListExtReqDto();
            areaListReqDto.setNameList(governAreaList);
            RestResponse areaRest = this.employeeRegionQueryApi.queryCustomerAreaByNames(areaListReqDto);
            if (null != areaRest && CollectionUtils.isNotEmpty((Collection)((Collection)areaRest.getData())) && CollectionUtils.isNotEmpty((Collection)(customerAreaList = (List)areaRest.getData()))) {
                customerAreasMap = customerAreaList.stream().collect(Collectors.groupingBy(CustomerAreaRespDto::getName));
            }
        }
        List customerCodeList = successList.stream().map(SellerEmployeeImportDto::getGovernCustomer).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        List blackCustomerCodelist = successList.stream().map(SellerEmployeeImportDto::getBlacklist).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        ArrayList customerOrgIdList = Lists.newArrayList(customerCodeList);
        customerOrgIdList.addAll(blackCustomerCodelist);
        CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
        Long orgId = ((SellerEmployeeImportDto)successList.get(0)).getOrgId();
        customerExtReqDto.setMerchantIdList((List)Lists.newArrayList((Object[])new Long[]{orgId}));
        customerExtReqDto.setCodes((List)customerOrgIdList);
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.employeeCustomerQueryApi.queryCustomerByDto(customerExtReqDto));
        Map<String, Object> customerMap = new HashMap<String, CustomerRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
            customerMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        }
        importDataList = this.verifyOrgData(importDataList, roleMap, customerAreasMap, customerMap, userOrgMap);
        successList = importDataList.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        logger.info("\u6821\u9a8c\u6570\u636e\u540e\u6210\u529f\u96c6\u5408\u5927\u5c0f:{}", (Object)successList.size());
        successList = this.mergeOrgData(successList);
        if (CollectionUtils.isNotEmpty(successList)) {
            List userIdList = successList.stream().map(SellerEmployeeImportDto::getUserId).distinct().collect(Collectors.toList());
            List list = successList.stream().map(SellerEmployeeImportDto::getOrgId).distinct().collect(Collectors.toList());
        }
        for (SellerEmployeeImportDto data2 : successList) {
            EmployeeExpandReqDto employeeExtReqDto = new EmployeeExpandReqDto();
            employeeExtReqDto.setOrganizationId(data2.getOrgId());
            employeeExtReqDto.setOrgId(data2.getOrgId());
            employeeExtReqDto.setOrganizationStatus(YesOrNoEnum.NO.getStatus());
            employeeExtReqDto.setName(data2.getUserName());
            employeeExtReqDto.setPosition(data2.getPosition());
            employeeExtReqDto.setSex(data2.getSex());
            employeeExtReqDto.setStation(data2.getDepartment());
            employeeExtReqDto.setPersonType("\u5185\u90e8".equals(data2.getEmployeeType()) ? "Internal" : "External");
            employeeExtReqDto.setPhoneNum(data2.getPhoneNumber());
            employeeExtReqDto.setEmployeeRoleDtoList(data2.getRoleList());
            employeeExtReqDto.setUserId(data2.getUserId());
            employeeExtReqDto.setType(Integer.valueOf(0));
            employeeExtReqDto.setStatus(Integer.valueOf(1));
            employeeExtReqDto.setStartTime(new Date());
            employeeExtReqDto.setCustomerInfoList(data2.getCustomerInfoList());
            employeeExtReqDto.setCustomerBlackList(data2.getCustomerBlackList());
            employeeExtReqDto.setRegionInfoList(data2.getAreaList());
            try {
                logger.info("\u5bfc\u5165\u5546\u5bb6\u4eba\u5458\u65b0\u589e:{}", (Object)JSON.toJSONString((Object)employeeExtReqDto));
                this.employeeExpand2Service.addEmployee(data2.getInstanceId(), employeeExtReqDto);
            }
            catch (Exception e) {
                logger.info("\u5bfc\u5165\u5546\u5bb6\u4eba\u5458\u6839\u636e\u4eba\u5458\u5931\u8d25:" + e.getMessage());
                this.setErrorsMsg(importDataList, data2.getAccount(), "\u6267\u884c\u5931\u8d25\uff01" + e.getMessage());
            }
        }
        logger.info("\u5546\u5bb6\u4eba\u5458\u5bfc\u5165\u7ed3\u675f");
        return new RestResponse(importDataList);
    }

    public Map<String, List<UserOrgizationRespDto>> getAccoutMap(List<String> accountList) {
        if (CollectionUtils.isEmpty(accountList)) {
            return new HashMap<String, List<UserOrgizationRespDto>>();
        }
        Map<String, List<UserOrgizationRespDto>> userOrgMap = new HashMap<String, List<UserOrgizationRespDto>>(accountList.size() * 4 / 3 + 2);
        List userOrgInfoList = (List)RestResponseHelper.extractData((RestResponse)this.userOrgExpandQueryApi.queryUserOrgByUserName(accountList));
        if (CollectionUtils.isEmpty((Collection)userOrgInfoList)) {
            return userOrgMap;
        }
        userOrgMap = userOrgInfoList.stream().collect(Collectors.groupingBy(UserOrgizationRespDto::getUserName));
        return userOrgMap;
    }

    private List<SellerEmployeeImportDto> verifyData(List<SellerEmployeeImportDto> importDataList, Map<String, List<UserOrgizationRespDto>> userOrgMap) {
        for (SellerEmployeeImportDto vo : importDataList) {
            if (StringUtils.isBlank((CharSequence)vo.getAccount())) {
                vo.setErrorReason("\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (userOrgMap.isEmpty() || !userOrgMap.containsKey(vo.getAccount())) {
                vo.setErrorReason("\u767b\u5f55\u8d26\u53f7\u9519\u8bef");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)vo.getUserName())) {
                vo.setErrorReason("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)vo.getPosition())) {
                vo.setErrorReason("\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)vo.getEmployeeType())) {
                vo.setErrorReason("\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)vo.getPhoneNumber())) {
                vo.setErrorReason("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (!"\u5185\u90e8".equals(vo.getEmployeeType()) && !"\u5916\u90e8".equals(vo.getEmployeeType())) {
                vo.setErrorReason("\u4eba\u5458\u7c7b\u578b\u53ea\u80fd\u4e3a'\u5185\u90e8'\u6216'\u5916\u90e8'");
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)vo.getPhoneNumber()) || CommonUtil.checkPhoneNum(vo.getPhoneNumber())) continue;
            vo.setErrorReason("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e;");
        }
        return importDataList;
    }

    private void checkNameAndPhoneNum(EmployeeExtQueryReqDto employeeDto) {
        List employeeExtRespDtos = (List)this.employeeExpandQueryApi.queryEmployeeByPhoneNumOrg(employeeDto).getData();
        AssertUtil.isTrue((CollectionUtils.isNotEmpty((Collection)employeeExtRespDtos) && !Objects.isNull(((EmployeeExtRespDto)employeeExtRespDtos.get(0)).getId()) ? 1 : 0) != 0, (String)("\u624b\u673a\u53f7\u4e3a:" + employeeDto.getPhoneNum() + ",\u6216\u8005\u59d3\u540d:" + employeeDto.getName() + "\u5df2\u7ecf\u5b58\u5728"));
    }

    public List<SellerEmployeeImportDto> setErrorsMsg(List<SellerEmployeeImportDto> list, String account, String errorMsg) {
        list.forEach(vo -> {
            if (StringUtils.isBlank((CharSequence)vo.getErrorReason()) && vo.getAccount().equals(account)) {
                vo.setErrorReason(errorMsg);
            }
        });
        return list;
    }

    private List<SellerEmployeeImportDto> verifyOrgData(List<SellerEmployeeImportDto> list, Map<String, List<RoleExpandRespDto>> roleMap, Map<String, List<CustomerAreaRespDto>> areasMap, Map<String, CustomerRespDto> customerMap, Map<String, List<UserOrgizationRespDto>> userOrgMap) {
        for (SellerEmployeeImportDto dto : list) {
            CustomerRespDto customerRespDto;
            if (StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())) continue;
            Long orgId = dto.getOrgId();
            if (userOrgMap.isEmpty() || !userOrgMap.containsKey(dto.getAccount())) {
                dto.setErrorReason("\u767b\u5f55\u8d26\u53f7\u9519\u8bef;");
                continue;
            }
            List<UserOrgizationRespDto> userOrgizationVos = userOrgMap.get(dto.getAccount());
            List userOrgList = userOrgizationVos.stream().filter(e -> orgId.compareTo(e.getOrgId()) == 0).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(userOrgList)) {
                dto.setErrorReason("\u767b\u5f55\u8d26\u53f7\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                continue;
            }
            dto.setUserId(((UserOrgizationRespDto)userOrgList.get(0)).getUserId());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getRoleName()})) {
                if (roleMap.isEmpty() || !roleMap.containsKey(dto.getRoleName())) {
                    dto.setErrorReason("\u89d2\u8272\u9519\u8bef");
                    continue;
                }
                List<RoleExpandRespDto> roleExpandEos = roleMap.get(dto.getRoleName());
                List orgRoleList = roleExpandEos.stream().filter(e -> Objects.nonNull(e.getBelongOrgId()) && e.getBelongOrgId().compareTo(dto.getOrgId()) == 0 || e.getRoleType() == 1).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(orgRoleList)) {
                    dto.setErrorReason("\u89d2\u8272\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                    continue;
                }
                EmployeeRoleReqDto employeeRoleReqDto = new EmployeeRoleReqDto();
                employeeRoleReqDto.setRoleId(((RoleExpandRespDto)orgRoleList.get(0)).getId());
                employeeRoleReqDto.setRoleCode(((RoleExpandRespDto)orgRoleList.get(0)).getCode());
                dto.setRole(employeeRoleReqDto);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getGovernArea()})) {
                List<CustomerAreaRespDto> customerAreaRespDtos = areasMap.get(dto.getGovernArea());
                if (areasMap.isEmpty() || !areasMap.containsKey(dto.getGovernArea())) {
                    dto.setErrorReason("\u7ba1\u7406\u533a\u57df\u9519\u8bef");
                    continue;
                }
                List orgAreaList = customerAreaRespDtos.stream().filter(e -> Objects.equals(e.getOrgInfoId(), dto.getOrgId())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(orgAreaList)) {
                    dto.setErrorReason("\u7ba1\u7406\u533a\u57df\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                    continue;
                }
                EmployeeRegionReqDto employeeRegionReqDto = new EmployeeRegionReqDto();
                employeeRegionReqDto.setRegionCode(((CustomerAreaRespDto)orgAreaList.get(0)).getCode());
                employeeRegionReqDto.setStartTime(new Date());
                dto.setArea(employeeRegionReqDto);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getGovernCustomer()})) {
                customerRespDto = customerMap.get(dto.getGovernCustomer());
                if (Objects.isNull(customerRespDto)) {
                    dto.setErrorReason("\u7ba1\u7406\u5ba2\u6237\uff08\u7ec4\u7ec7ID\uff09\u9519\u8bef;");
                    continue;
                }
                EmployeeCustomerReqDto employeeCustomerReqDto = new EmployeeCustomerReqDto();
                employeeCustomerReqDto.setCustomerId(customerRespDto.getId());
                employeeCustomerReqDto.setStartTime(new Date());
                dto.setCustomerDto(employeeCustomerReqDto);
            }
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getBlacklist()})) continue;
            customerRespDto = customerMap.get(dto.getBlacklist());
            if (Objects.isNull(customerRespDto)) {
                dto.setErrorReason("\u7ba1\u7406\u9ed1\u540d\u5355\uff08\u7ec4\u7ec7ID\uff09\u9519\u8bef;");
                continue;
            }
            EmployeeCustomerBlacklistReqDto customerBlacklistReqDto = new EmployeeCustomerBlacklistReqDto();
            customerBlacklistReqDto.setCustomerId(customerRespDto.getId());
            customerBlacklistReqDto.setStartTime(new Date());
            dto.setCustomerBlackDto(customerBlacklistReqDto);
        }
        return list;
    }

    private List<SellerEmployeeImportDto> mergeOrgData(List<SellerEmployeeImportDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        Map<String, List<SellerEmployeeImportDto>> employeeGroupMap = list.stream().collect(Collectors.groupingBy(dto -> dto.getOrgId() + "_" + dto.getAccount()));
        ArrayList resultVoList = Lists.newArrayList();
        for (String account : employeeGroupMap.keySet()) {
            List customerBlackList;
            List customerInfoList;
            List areaList;
            List<SellerEmployeeImportDto> employeeExcelVos = employeeGroupMap.get(account);
            SellerEmployeeImportDto vo = new SellerEmployeeImportDto();
            CubeBeanUtils.copyProperties((Object)vo, (Object)employeeExcelVos.get(0), (String[])new String[0]);
            List roleList = employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getRole())).map(SellerEmployeeImportDto::getRole).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EmployeeRoleReqDto>(Comparator.comparing(EmployeeRoleReqDto::getRoleId))), ArrayList::new));
            if (CollectionUtils.isNotEmpty((Collection)roleList)) {
                vo.setRoleList(roleList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(areaList = (List)employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getArea())).map(SellerEmployeeImportDto::getArea).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EmployeeRegionReqDto>(Comparator.comparing(EmployeeRegionReqDto::getRegionCode))), ArrayList::new))))) {
                vo.setAreaList(areaList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(customerInfoList = (List)employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getCustomerDto())).map(SellerEmployeeImportDto::getCustomerDto).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EmployeeCustomerReqDto>(Comparator.comparing(EmployeeCustomerReqDto::getCustomerId))), ArrayList::new))))) {
                vo.setCustomerInfoList(customerInfoList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(customerBlackList = (List)employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getCustomerBlackDto())).map(SellerEmployeeImportDto::getCustomerBlackDto).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EmployeeCustomerBlacklistReqDto>(Comparator.comparing(EmployeeCustomerBlacklistReqDto::getCustomerId))), ArrayList::new))))) {
                vo.setCustomerBlackList(customerBlackList);
            }
            resultVoList.add(vo);
        }
        return resultVoList;
    }
}

