package com.dtyunxi.yundt.module.customer.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ImportEventReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.SupplierInfoExcelReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.supplier.ISupplierApi;
import com.dtyunxi.yundt.cube.center.customer.api.supplier.dto.request.SupplierReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.supplier.dto.response.SupplierImportDataValidateRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.supplier.query.ISupplierQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import com.dtyunxi.yundt.module.customer.biz.service.ISupplierImportLogService;
import com.dtyunxi.yundt.module.customer.biz.util.BeanHelper;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

import static com.dtyunxi.yundt.module.customer.biz.util.CommonUtil.validateMobilePhone;


@Service
public class SupplierImportLogServiceImpl implements ISupplierImportLogService {

    @Autowired
    private IAreaQueryApi areaQueryApi;

    @Autowired
    private ISupplierApi iSupplierApi;

    @Autowired
    private ISupplierQueryApi iSupplierQueryApi;

    private Logger logger = LoggerFactory.getLogger(SupplierImportLogServiceImpl.class);

    @Override
    public SupplierImportDataValidateRespDto importDataVerify(ImportEventReqDto importEventReqDto) {
        List<SupplierInfoExcelReqDto> supplierInfoExcelReqList = importEventReqDto.getSupplierInfoExcelReqList();
        //校验通不过的数据集合
        List<SupplierInfoExcelReqDto> errorCustomerList = Lists.newArrayList();
        List<String> allCode = iSupplierQueryApi.findAllCode(importEventReqDto.getInstanceId(), importEventReqDto.getTenantId()).getData();
        Set<String> codeSet = new HashSet<>(allCode == null ? new ArrayList<>() : allCode);
        for (SupplierInfoExcelReqDto customerInfoExcelReqDto : supplierInfoExcelReqList) {
            try {
                boolean add = codeSet.add(customerInfoExcelReqDto.getCode());
                if (!add) {
                    customerInfoExcelReqDto.setReason("供应商编码重复,请检查");
                    errorCustomerList.add(customerInfoExcelReqDto);
                    continue;
                }
                //必填参数校验
                if (StringUtils.isBlank(customerInfoExcelReqDto.getName())
                        || StringUtils.isBlank(customerInfoExcelReqDto.getCode())) {
                    customerInfoExcelReqDto.setReason("必填字段为空,请检查");
                    errorCustomerList.add(customerInfoExcelReqDto);
                    continue;
                }
                //todo:sumo 长度校验


                //校验行政地区-所属省名
                if (StringUtils.isNotBlank(customerInfoExcelReqDto.getProvince()) && !isExit(customerInfoExcelReqDto.getProvince(), 0)) {
                    //由于所属省名
                    customerInfoExcelReqDto.setReason("[所属省名]错误,请检查");
                    errorCustomerList.add(customerInfoExcelReqDto);
                    continue;
                }
                //校验行政地区-所属市名
                if (StringUtils.isNotBlank(customerInfoExcelReqDto.getCity()) && !isExit(customerInfoExcelReqDto.getCity(), 1)) {
                    //由于所属市名
                    customerInfoExcelReqDto.setReason("[所属市名]错误,请检查");
                    errorCustomerList.add(customerInfoExcelReqDto);
                    continue;
                }
                //校验行政地区-所属区名
                if (StringUtils.isNotBlank(customerInfoExcelReqDto.getCounty()) && !isExit(customerInfoExcelReqDto.getCounty(), 2)) {
                    //由于所属区名
                    customerInfoExcelReqDto.setReason("[所属区名]错误,请检查");
                    errorCustomerList.add(customerInfoExcelReqDto);
                    continue;
                }


                //校验手机
                boolean mobileIsExit =StringUtils.isNoneBlank(customerInfoExcelReqDto.getContactMobile()) &&  !validateMobilePhone(customerInfoExcelReqDto.getContactMobile());
                if (mobileIsExit) {
                    //由于手机
                    customerInfoExcelReqDto.setReason("[手机]格式错误,请检查");
                    errorCustomerList.add(customerInfoExcelReqDto);
                    continue;
                }


                BeanHelper.beanAttributeValueTrim(customerInfoExcelReqDto);
                //初始化CustomerDetailReqDto
                SupplierReqDto supplierReqDto = initSupplierDetailReqDto(customerInfoExcelReqDto);
                supplierReqDto.setInstanceId(importEventReqDto.getInstanceId());
                supplierReqDto.setTenantId(importEventReqDto.getTenantId());
                logger.info("客户批量导入进行中 ---> 开始保存excel数据{}", supplierReqDto.toString());
                RestResponseHelper.checkOrThrow(iSupplierApi.add(supplierReqDto));
            } catch (Exception e) {
                e.printStackTrace();
                customerInfoExcelReqDto.setReason(e.getMessage());
                errorCustomerList.add(customerInfoExcelReqDto);

            }

        }

        SupplierImportDataValidateRespDto resultDto = new SupplierImportDataValidateRespDto();
        resultDto.setErrorSupplierInfoExcelList(errorCustomerList);
        supplierInfoExcelReqList.removeAll(errorCustomerList);//剔除所有不合格的数据
        resultDto.setOkSupplierinfoexcelreqdtos(supplierInfoExcelReqList);
        return resultDto;
    }

    @Override
    public void importSupplier(ImportEventReqDto importEventReqDto, Predicate<SupplierImportDataValidateRespDto> dataValidateResultHandler) {
        //设置租户id
        ServiceContext.getContext().setAttachment("yes.req.tenantId", String.valueOf(importEventReqDto.getTenantId()));
        ServiceContext.getContext().setAttachment("yes.req.instanceId", String.valueOf(importEventReqDto.getInstanceId()));
        logger.info("客户批量导入进行中 ---> 开始校验excel数据");
        SupplierImportDataValidateRespDto supplierImportDataValidateRespDto = this.importDataVerify(importEventReqDto);

        //导入数据校验的结果处理，可以上传OSS，也可以交由第三方处理，返回结果true,则继续该会员导入
        if (!dataValidateResultHandler.test(supplierImportDataValidateRespDto)) {
            return;
        }
        logger.info("客户批量导入 ---> 结束客户导入业务");
    }

    /**
     * 初始化供应商新增对象
     *
     * @author sumo on 2020/10/16 0016
     */
    private SupplierReqDto initSupplierDetailReqDto(SupplierInfoExcelReqDto infoExcelReqDto) {
        SupplierReqDto supplierReqDto = new SupplierReqDto();
        BeanUtils.copyProperties(infoExcelReqDto, supplierReqDto);
        supplierReqDto.setProvinceCode(getAreaCode(infoExcelReqDto.getProvince(), 0));//编码
        supplierReqDto.setCityCode(getAreaCode(infoExcelReqDto.getCity(), 1));//编码
        supplierReqDto.setCountyCode(getAreaCode(infoExcelReqDto.getCounty(), 2));//编码

        supplierReqDto.setProvince(infoExcelReqDto.getProvince());
        supplierReqDto.setCity(infoExcelReqDto.getCity());
        supplierReqDto.setCounty(infoExcelReqDto.getCounty());
        return supplierReqDto;
    }

    private String getAreaCode(String name, Integer levelId) {
        AreaQueryReqDto queryReqDto = new AreaQueryReqDto();
        queryReqDto.setLevelId(levelId);
        queryReqDto.setName(name);
        List<AreaDto> areaDtos = areaQueryApi.queryByPage(queryReqDto).getData().getList();
        return !CollectionUtils.isEmpty(areaDtos) ? areaDtos.get(0).getCode() : null;
    }

    private boolean isExit(String name, Integer levelId) {
        AreaQueryReqDto queryReqDto = new AreaQueryReqDto();
        queryReqDto.setLevelId(levelId);
        queryReqDto.setName(name);
        List<AreaDto> areaDtos = areaQueryApi.queryByPage(queryReqDto).getData().getList();
        return !CollectionUtils.isEmpty(areaDtos);
    }
}