package com.dtyunxi.yundt.module.customer.biz.impl.user;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ExampleQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.OrgSellerCustomerQueryReqDto;
import com.dtyunxi.tcbj.api.dto.response.OrgSellerCustomerRespDto;
import com.dtyunxi.tcbj.api.query.IOrgSellerCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.IEmployeeCustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.entity.NacosPropertiesOrgEntity;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeNumCountRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeRegionRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerQueryV3Api;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeRegionQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.user.api.IEmployeeExpandApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.entity.ImportBaseResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleExpandReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeImportReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleExpandRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserOrgizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.user.api.query.*;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.cube.center.user.api.util.RestUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.EmployeeExpandQueryReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.EmployeeExpandReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.EmployeeExpandRespDto;
import com.dtyunxi.yundt.module.customer.api.user.ICustomerEmployeeExpandService;
import com.dtyunxi.yundt.module.customer.api.user.IEmployeeExpand2Service;
import com.dtyunxi.yundt.module.customer.api.vo.EmployeeExcelVo;
import com.dtyunxi.yundt.module.customer.biz.util.CommonUtil;
import com.dtyunxi.yundt.module.customer.biz.util.EasyPoiExportUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.CustomerAreaExtReqDto;
import com.yx.tcbj.center.customer.api.dto.request.CustomerExtReqDto;
import com.yx.tcbj.center.shop.api.dto.request.SellerExtQueryReqDto;
import com.yx.tcbj.center.shop.api.query.ISellerExpandQueryApi;
import liquibase.pro.packaged.D;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @date 2022-02-14 14:49
 * @since 1.0.0
 */
@Service
public class EmployeeExpand2ServiceImpl implements IEmployeeExpand2Service {

    private static final Logger logger = LoggerFactory.getLogger(EmployeeExpand2ServiceImpl.class);

    @Resource
    private IEmployeeExpandApi employeeExpandApi;
    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;

    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;
    @Resource
    private IEmployeeCustomerApi employeeCustomerApi;
    @Resource
    private IEmployeeRegionQueryApi employeeRegionQueryApi;
    @Resource
    private IOrgSellerCustomerQueryApi orgSellerCustomerQueryApi;
    @Resource
    private NacosPropertiesOrgEntity nacosPropertiesOrgEntity;
    @Resource
    private ICustomerQueryV3Api customerQueryV3Api;
    @Resource
    private ISellerExpandQueryApi sellerExpandQueryApi;
    @Resource
    private HttpServletRequest request;
    @Resource
    private IContext context;
    @Resource
    private IUserOrgExpandQueryApi userOrgExpandQueryApi;
    @Resource
    private IRoleQueryApi roleQueryApi;
    @Resource
    private IOrgInfoExtQueryApi orgInfoExtQueryApi;
    @Resource
    private IUserExtQueryApi userExtQueryApi;




    /**
     * 获取客户信息
     * @return
     */
    @Override
    public Map<String,CustomerRespDto> getOrgCustomerMap(List<String> customerCodeList){
        if(CollectionUtils.isEmpty(customerCodeList)){
            return new HashMap<>();
        }
        RestResponse<List<CustomerRespDto>> customerRest = employeeCustomerQueryApi.queryCustomerListByCodes(customerCodeList);
        if(customerRest ==null || CollectionUtils.isEmpty(customerRest.getData())){
            return new HashMap<>();
        }
        List<CustomerRespDto> customerList = customerRest.getData();
        Map<String, CustomerRespDto> customerMap = customerList.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        return customerMap;
    }

    /**
     * 获取请求头的组织ID
     *
     * @return 组织ID
     */
    public String headerOrgId() {
        String organizationId = request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("获取请求头组织ID：{}", organizationId);
        return organizationId;
    }
    /**
     * 根据实例ID查询TenantId
     *
     * @return
     */
    public Long tenantId() {
        Long tenantId = context.tenantId();
        logger.info("tenantId >>> {}", tenantId);
        if (tenantId == null) {
            tenantId = 1L;
        }
        return tenantId;
    }


    /**
     * 新增人员信息
     *
     * @param instanceId  实例ID
     * @param employeeDto 请求dto
     * @return 人员主键ID
     */
    @Override
    @Transactional(rollbackFor = {Exception.class})
    public  RestResponse<Long> addEmployee(Long instanceId, EmployeeExpandReqDto employeeDto) {
        logger.info("新增人员信息，入参：{}", JSONObject.toJSONString(employeeDto));

//        电话必填（名字+电话，如果在当前租户有重复，不允许新增，原营销云有效验）
        AssertUtil.assertNotBlank(employeeDto.getPhoneNum(), "手机号不能为空");
        AssertUtil.assertNotBlank(employeeDto.getName(), "姓名不能为空");
        // 优先获取校验请求头[组织id]
        String orgId = this.headerOrgId();
        logger.info("请求头组织ID：{}", orgId);
        if(Objects.nonNull(employeeDto.getOrganizationId())){
            // 其次获取请求参数
            orgId = employeeDto.getOrganizationId().toString();
            logger.info("请求参数组织ID：{}", orgId);
        }
        // 再次获取nacos配置的组织ID（用于开发、测试）
        if (StringUtils.isBlank(orgId)){
            orgId = nacosPropertiesOrgEntity.orgId();
            logger.info("nacos配置的组织ID：{}", orgId);
        }
        AssertUtil.assertNotBlank(orgId, "请求头缺失组织ID[yes-req-cus-b2b-organizationId]");
        AssertUtil.assertNotNull(instanceId, "实例ID[instanceId]不能为空");
//        AssertUtil.assertNotNull(employeeDto.getUserId(), "登录账号[userId]不能为空");

        Long tenantId = this.tenantId();
        employeeDto.setOrganizationId(Long.parseLong(this.headerOrgId()));
//        电话必填（名字+电话，如果在当前租户有重复，不允许新增，原营销云有效验）
        checkNameAndPhoneNum(employeeDto);
        //如果是组织人员信息
        if(YesOrNoEnum.isYes(employeeDto.getOrganizationStatus())){
            AssertUtil.assertNotNull(employeeDto.getOrgId(), "所选组织[orgId]不能为空");
            AssertUtil.assertNotNull(employeeDto.getOrganizationCode(), "所选组织代码[organizationCode]不能为空");
            employeeDto.setOrganizationId(employeeDto.getOrganizationId());
        }

        Integer type = Objects.isNull(employeeDto.getType()) ? 0 : employeeDto.getType();
        //如果是客户人员
        if(type == 1 && StringUtils.isNotEmpty(employeeDto.getCustomerCode())){
            //根据客户编码查询当前组织ID
            Map<String, CustomerRespDto> orgCustomerMap = this.getOrgCustomerMap(Collections.singletonList(employeeDto.getCustomerCode()));
            if(orgCustomerMap.isEmpty() || !orgCustomerMap.containsKey(employeeDto.getCustomerCode())){
                throw new BizException("客户编号["+employeeDto.getCustomerCode()+"]对应客户信息不存在");
            }
            CustomerRespDto customerRespDto = orgCustomerMap.get(employeeDto.getCustomerCode());
            //人员所属组织ID为客户对应组织ID
            employeeDto.setOrganizationId(customerRespDto.getMerchantId());
//            employeeDto.setCustomerCode(null);
        }
        employeeDto.setInstanceId(instanceId);
        employeeDto.setTenantId(tenantId);
        employeeDto.setType(type);

        Long employeeId = RestResponseHelper.extractData(employeeExpandApi.addEmployee(instanceId, employeeDto));
        employeeDto.setId(employeeId);
        //绑定人员区域、人员客户、人员黑名单
        this.bindEmployeeCustomer(employeeDto);
        return new RestResponse<>(employeeId);
    }

// 检查员工姓名和电话号码
    private void checkNameAndPhoneNum(EmployeeExpandReqDto employeeDto) {
        EmployeeExtQueryReqDto extQueryReqDto = new EmployeeExpandQueryReqDto();
        extQueryReqDto.setName(employeeDto.getName());
        extQueryReqDto.setPhoneNum(employeeDto.getPhoneNum());
        extQueryReqDto.setOrganizationId(employeeDto.getOrganizationId());
        List<EmployeeExtRespDto> employeeExtRespDtos = employeeExpandQueryApi.queryEmployeeByPhoneNumOrg(extQueryReqDto).getData();
        AssertUtil.isFalse(CollectionUtils.isNotEmpty(employeeExtRespDtos) && !Objects.isNull(employeeExtRespDtos.get(0).getId()) , "手机号为:"+employeeDto.getPhoneNum()+",或者姓名:"+employeeDto.getName()+"已经存在");
    }


    /**
     * 修改人员信息
     *
     * @param instanceId  实例ID
     * @param employeeDto 请求dto
     */
    @Override
    @Transactional(rollbackFor = {Exception.class})
    public  RestResponse<Void> modifyEmployee(Long instanceId, EmployeeExpandReqDto employeeDto) {
        logger.info("修改人员信息，入参：{}", JSONObject.toJSONString(employeeDto));

        AssertUtil.assertNotNull(employeeDto.getId(), "人员ID不能为空");
        AssertUtil.assertNotNull(instanceId, "实例ID[instanceId]不能为空");
//        AssertUtil.assertNotNull(employeeDto.getUserId(), "登录账号[userId]不能为空");

        Long tenantId = this.tenantId();

        // 校验请求头[组织id]
        String orgId = this.headerOrgId();
        logger.info("请求头组织ID：{}", orgId);
        if(Objects.nonNull(employeeDto.getOrganizationId())){
            // 其次获取请求参数
            orgId = employeeDto.getOrganizationId().toString();
            logger.info("请求参数组织ID：{}", orgId);
        }
        // 再次获取nacos配置的组织ID（用于开发、测试）
        if (StringUtils.isBlank(orgId)){
            orgId = nacosPropertiesOrgEntity.orgId();
            logger.info("nacos配置的组织ID：{}", orgId);
        }
        AssertUtil.assertNotBlank(orgId, "请求头缺失组织ID[yes-req-cus-b2b-organizationId]");

        //如果是组织人员信息
        if(YesOrNoEnum.isYes(employeeDto.getOrganizationStatus())){
            AssertUtil.assertNotNull(employeeDto.getOrgId(), "所选组织[orgId]不能为空");
            AssertUtil.assertNotNull(employeeDto.getOrganizationCode(), "所选组织代码[organizationCode]不能为空");
        }

        Integer type = Objects.isNull(employeeDto.getType()) ? 0 : employeeDto.getType();
        //如果是客户人员
        if(type == 1 && StringUtils.isNotEmpty(employeeDto.getCustomerCode())){
            //根据客户编码查询当前组织ID
            Map<String, CustomerRespDto> orgCustomerMap = this.getOrgCustomerMap(Collections.singletonList(employeeDto.getCustomerCode()));
            if(orgCustomerMap.isEmpty() || !orgCustomerMap.containsKey(employeeDto.getCustomerCode())){
                throw new BizException("客户编号["+employeeDto.getCustomerCode()+"]对应客户信息不存在");
            }
            CustomerRespDto customerRespDto = orgCustomerMap.get(employeeDto.getCustomerCode());
            //人员所属组织ID为客户对应组织ID
            //employeeDto.setOrganizationId(customerRespDto.getOrgInfoId());
            orgId = customerRespDto.getMerchantId().toString();
            employeeDto.setCustomerCode(null);

        }
        employeeDto.setOrganizationId(Long.parseLong(orgId));
        employeeDto.setInstanceId(instanceId);
        employeeDto.setTenantId(tenantId);

        RestResponseHelper.extractData(employeeExpandApi.modifyEmployee(instanceId,employeeDto));
        //绑定人员区域、人员客户、人员黑名单
        this.bindEmployeeCustomer(employeeDto);
        return RestResponse.VOID;
    }

    /**
     * 分页查询人员信息
     *
     * @param reqDto 请求dto
     * @return 分页数据
     */
    @Override
    public  RestResponse<PageInfo<EmployeeExpandRespDto>> queryByPage(EmployeeExpandQueryReqDto reqDto) {
        logger.info("请求参数组织ID：{}", reqDto.getOrganizationId());

        String organizationId = null;
        // 优先请求参数
        if (Objects.isNull(reqDto.getOrganizationId())){
            // 其次请求头的参数
            organizationId = this.headerOrgId();
            logger.info("请求头组织ID：{}", organizationId);
        }else{
            organizationId = String.valueOf(reqDto.getOrganizationId());
        }
        // 再次获取nacos配置的组织ID（用于开发、测试）
//        if (StringUtils.isBlank(organizationId)){
//            organizationId = nacosPropertiesOrgEntity.orgId();
//            logger.info("nacos配置的组织ID：{}", organizationId);
//        }
        AssertUtil.assertNotBlank(organizationId, "请求头缺失组织ID[yes-req-cus-b2b-organizationId]");
        AssertUtil.assertNotNull(reqDto.getInstanceId(), "实例ID[instanceId]不能为空");
        Long orgId = StringUtils.isBlank(organizationId) ? null : Long.parseLong(organizationId);
        reqDto.setOrganizationId(orgId);
        Long tenantId = this.tenantId();

        PageInfo<EmployeeExpandRespDto> dtoPageInfo = new PageInfo<>();


        List<Long> employeeIds = new ArrayList<>();
        //客户人员查询，通过当前组织id查询组织下对应的客户组织信息
        if(Objects.nonNull(reqDto.getType()) && reqDto.getType() == 1){
            List<CustomerRespDto> customerRespDtos = getCustomerRespDtos(reqDto);
            if(CollectionUtils.isEmpty(customerRespDtos)){
                return new RestResponse<>(dtoPageInfo);
            }
            List<Long> orgIdList = customerRespDtos.stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
            reqDto.setOrganizationIdList(orgIdList);
            reqDto.setOrganizationId(null);
        }else {
            List<CustomerRespDto> customerRespDtos = Optional.ofNullable(getCustomerRespDtos(reqDto)).orElse(new ArrayList<>());
            List<Long> orgIdList = customerRespDtos.stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
            orgIdList.add(reqDto.getOrganizationId());
            reqDto.setOrganizationIdList(orgIdList);
            reqDto.setOrganizationId(null);
        }

        // 客户名称、客户编号（大B客户人员列表查询参数）
        List<EmployeeCustomerRespDto> empCustDtos = null;
        if (StringUtils.isNotBlank(reqDto.getCustomerName()) || StringUtils.isNotBlank(reqDto.getCustomerCode())) {
            CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
            customerExtReqDto.setCode(reqDto.getCustomerCode());
            customerExtReqDto.setName(reqDto.getCustomerName());
//            customerExtReqDto.setInstanceId(reqDto.getInstanceId());
            customerExtReqDto.setMerchantId(reqDto.getOrganizationId());
            //customerExtReqDto.setTenantId(tenantId);
            // 审核状态（WAIT_AUDIT：待审核、AUDIT_REJECT：审核不通过、AUDIT_PASS：审核通过、INVALID：作废、DRAFT：草稿）
            // customerExtReqDto.setAuditStatus("AUDIT_PASS");
            logger.info("开始查询客户信息(根据客户名称、客户编号查询)，入参：{}", JSON.toJSONString(customerExtReqDto));
            empCustDtos = RestUtil.checkResponse(employeeCustomerQueryApi.queryEmployee(customerExtReqDto));
            logger.info("结束查询客户信息(根据客户名称、客户编号查询)，出参：{}", JSON.toJSONString(empCustDtos));
            if (CollectionUtils.isEmpty(empCustDtos)) {
                return new RestResponse<>(dtoPageInfo);
            } else {
                List<Long> _ids = empCustDtos.stream().map(EmployeeCustomerRespDto::getEmployeeId).collect(Collectors.toList());
                employeeIds.addAll(_ids);
            }
        }

        // 客户区域（大B客户管理查询）
        if (CollectionUtils.isNotEmpty(reqDto.getCustomerAreaList())) {
            List<String> areaCodes = reqDto.getCustomerAreaList().stream()
                    .filter(Objects::nonNull)
                    .filter(o -> Objects.nonNull(o.getAreaCode()))
                    .map(CustomerAreaExtReqDto::getAreaCode)
                    .distinct()
                    .collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(areaCodes)) {
                EmployeeRegionQueryReqDto regionQueryReqDto = new EmployeeRegionQueryReqDto();
                regionQueryReqDto.setInstanceId(reqDto.getInstanceId());
                regionQueryReqDto.setMerchantId(reqDto.getOrganizationId());
                regionQueryReqDto.setRegionCodes(areaCodes);
                logger.info("开始客户区域（大B客户管理查询），入参：{}", JSON.toJSONString(regionQueryReqDto));
                List<EmployeeRegionRespDto> dtoList = RestUtil.checkResponse(employeeRegionQueryApi.queryEmployeeRegionByCodes(regionQueryReqDto));
                logger.info("结束客户区域（大B客户管理查询），出参：{}", JSON.toJSONString(dtoList));
                if (CollectionUtils.isEmpty(dtoList)) {
                    return new RestResponse<>(dtoPageInfo);
                } else {
                    List<Long> _ids = dtoList.stream().map(EmployeeRegionRespDto::getEmployeeId).collect(Collectors.toList());
                    employeeIds.addAll(_ids);
                }
            }
        }

        // 综合设置角色、客户名称、客户编号、客户区域查询参数（根据人员ID查询）
        if (CollectionUtils.isNotEmpty(employeeIds)) {
            reqDto.setIds(employeeIds);
        }

        PageInfo<EmployeeExtRespDto> employeePage = RestResponseHelper.extractData(employeeExpandQueryApi.queryByPage(reqDto));
        CubeBeanUtils.copyProperties(dtoPageInfo, employeePage, "list", "navigatepageNums");
        List<EmployeeExtRespDto> employeePageList = employeePage.getList();
        List<EmployeeExpandRespDto> dtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection(dtoList,employeePageList,EmployeeExpandRespDto.class);
        if(Objects.nonNull(reqDto.getType()) && reqDto.getType() == 1){
            // 填充客户名称
            this.fillCustomInfo(dtoList,orgId);
        }else{
            // 填充管理区域数和管理客户数
            this.fillCustomerAndRegionNum(dtoList, Long.valueOf(organizationId), reqDto.getInstanceId(), tenantId);
        }
        dtoPageInfo.setList(dtoList);
        return new RestResponse<>(dtoPageInfo);
    }

    @Nullable
    private List<CustomerRespDto> getCustomerRespDtos(EmployeeExpandQueryReqDto reqDto) {
        //客户人员查询
        CustomerSearchExtReqDto customerExtQuery = new CustomerSearchExtReqDto();
        customerExtQuery.setMerchantId(reqDto.getOrganizationId());
        //客户详情根据客户编码查询客户人员信息
        if(StringUtils.isNotEmpty(reqDto.getEmpCustomerCode())){
            customerExtQuery.setCode(reqDto.getEmpCustomerCode());
        }
        //客户人员客户名称模糊查询
        customerExtQuery.setCustomerNameLike(reqDto.getCustomerNameLike());
        customerExtQuery.setCustomerCodeLike(reqDto.getCustomerCodeLike());
        logger.info("开始查询客户信息(根据客户名称模糊查询)，入参:{}",JSON.toJSONString(customerExtQuery));
        List<CustomerRespDto> customerRespDtos = RestResponseHelper.extractData(customerQueryV3Api.queryCustomerByExtDtoList(customerExtQuery));
        return customerRespDtos;
    }

    @Override
    public  RestResponse<EmployeeExpandRespDto> queryById(EmployeeExtReqDto reqDto) {
        AssertUtil.assertNotNull(reqDto.getId(), "人员主键ID不能为空");
        String organizationId = this.headerOrgId();
        logger.info("请求头组织ID：{}", organizationId);
        // 获取nacos配置的组织ID（用于开发、测试）
        if (StringUtils.isBlank(organizationId)){
            organizationId = nacosPropertiesOrgEntity.orgId();
            logger.info("nacos配置的组织ID：{}", organizationId);
        }
        AssertUtil.assertNotBlank(organizationId, "请求头缺失组织ID[yes-req-cus-b2b-organizationId]");

        List<EmployeeExpandRespDto> respDtos = new ArrayList<>(1);

        EmployeeExtRespDto employeeExtRespDto = RestResponseHelper.extractData(employeeExpandQueryApi.queryById(reqDto));
        if(Objects.nonNull(employeeExtRespDto) && Objects.nonNull(employeeExtRespDto.getId())){
            EmployeeExpandRespDto expandRespDto = new EmployeeExpandRespDto();
            CubeBeanUtils.copyProperties(expandRespDto,employeeExtRespDto);
            respDtos.add(expandRespDto);
        }
        if (CollectionUtils.isNotEmpty(respDtos)) {
            // 填充客户名称
            this.fillCustomInfo(respDtos,Long.valueOf(organizationId));
            //填充组织信息
            this.fillOrganizationInfo(respDtos);
            return new RestResponse<>(respDtos.get(0));
        }
        return new RestResponse<>();
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public RestResponse<Void> updateStatus(Long instanceId, EmployeeExtReqDto reqDto) {
        AssertUtil.assertNotEmpty(reqDto.getIds(), "人员主键ID[属性名：ids]不能为空");
        AssertUtil.assertNotNull(reqDto.getStatus(), "状态[属性名：status]不能为空");
        String organizationId = this.headerOrgId();
        logger.info("请求头组织ID：{}", organizationId);
        if (StringUtils.isBlank(organizationId)){
            organizationId = nacosPropertiesOrgEntity.orgId();
            logger.info("nacos配置的组织ID：{}", organizationId);
        }
        AssertUtil.assertNotBlank(organizationId, "请求头缺失组织ID[yes-req-cus-b2b-organizationId]");
        reqDto.setOrganizationId(Long.valueOf(organizationId));
        RestResponseHelper.extractData(employeeExpandApi.upateStatus(instanceId,reqDto));
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public RestResponse<Void> setSuperAdmin(Long instanceId, EmployeeExtReqDto reqDto) {
        AssertUtil.assertNotNull(reqDto.getId(), "人员主键ID[属性名：id]不能为空");
        AssertUtil.assertNotNull(reqDto.getSuperAdmin(), "是否超级管理员[0-否，1-是]不能为空");
        AssertUtil.assertNotEmpty(reqDto.getEmployeeRoleDtoList(), "角色信息[属性名：employeeRoleDtoList]不能为空");
        /* 校验是否为超级管理员角色 */
//        RoleAccessDto roleAccessDto = roleService.queryById(reqDto.getEmployeeRoleDtoList().get(0).getRoleId());
//        AssertUtil.assertNotNull(roleAccessDto,"找不到对应的角色");
//        AssertUtil.isFalse(roleAccessDto.getCode().equals("admin_code"),"请求角色不是超级管理员角色");

        String organizationId = this.headerOrgId();
        logger.info("请求头组织ID：{}", organizationId);
        if (StringUtils.isBlank(organizationId)){
            organizationId = nacosPropertiesOrgEntity.orgId();
            logger.info("nacos配置的组织ID：{}", organizationId);
        }
        AssertUtil.assertNotBlank(organizationId, "请求头缺失组织ID[yes-req-cus-b2b-organizationId]");
        reqDto.setOrganizationId(Long.valueOf(organizationId));
        RestResponseHelper.extractData(employeeExpandApi.setSuperAdmin(instanceId,reqDto));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<ImportBaseResponse> importExcelEmployee(EmployeeImportReqDto importReqDto) {
        String fileUrl = importReqDto.getFileUrl();
        AssertUtil.assertNotBlank(fileUrl, "导入的文件路径为空");
        Long instanceId = importReqDto.getInstanceId();
        String orgIdStr = this.headerOrgId();
//        orgIdStr = "1288861123298304011";
        logger.info("请求头组织ID：{}", orgIdStr);
        // 再次获取nacos配置的组织ID（用于开发、测试）
        if (StringUtils.isBlank(orgIdStr)){
            orgIdStr = nacosPropertiesOrgEntity.orgId();
            logger.info("nacos配置的组织ID：{}", orgIdStr);
        }
        AssertUtil.assertNotBlank(orgIdStr, "请求头缺失组织ID[yes-req-cus-b2b-organizationId]");
        Long orgId = Long.valueOf(orgIdStr);
        /* 设置默认结果 */
        ImportBaseResponse response = new ImportBaseResponse();
        /* 处理文件，读取数据 */
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);// 表格标题行数,默认0
        importParams.setTitleRows(0);//表头行数,默认1
        importParams.setKeyIndex(null);
        List<EmployeeExcelVo> importDataList = new ArrayList<>();
        try {
            ExcelImportResult<EmployeeExcelVo> result = ExcelImportUtil.importExcelMore(EasyPoiExportUtil.getInputStream(fileUrl), EmployeeExcelVo.class, importParams);
            if (ObjectUtils.isNotEmpty(result)) {
                importDataList = result.getList();
                //筛选对象属性全部为null数据
                importDataList = BeanPropertyNullUtil.getAllFieldNullList(importDataList);
            }
            if (CollectionUtils.isEmpty(importDataList)) {
                throw new BizException("无法读取 Excel 中的数据，请检查数据是否符合模板格式要求");
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new BizException("无法读取 Excel 文件，请检查文件类型");
        }
        if (CollectionUtils.isEmpty(importDataList)){
            response.setTotalNum(0);
            response.setSuccessNum(0);
            response.setErrorNum(0);
            return new RestResponse<>(response);
        }
        logger.info("导入数据：{}", JSON.toJSONString(importDataList));
        response.setTotalNum(importDataList.size());

        List<String> roleNameList = importDataList.stream().filter(data -> StringUtils.isNotEmpty(data.getRoleName())).map(EmployeeExcelVo::getRoleName).distinct().collect(Collectors.toList());
        /* 获取角色列表数据 */
        Map<String, List<RoleExpandRespDto>> roleMap =this.getRoleMap(roleNameList,null);

        List<String> areaNameList = importDataList.stream().filter(data -> StringUtils.isNotEmpty(data.getGovernArea())).map(EmployeeExcelVo::getGovernArea).distinct().collect(Collectors.toList());

        //获取客户区域
        Map<String, List<CustomerAreaRespDto>> customerAreasMap = this.getCustomerAreaMap(areaNameList);

        //获取账户信息
        List<String> accountList = importDataList.stream().filter(data -> StringUtils.isNotEmpty(data.getAccount())).map(EmployeeExcelVo::getAccount).distinct().collect(Collectors.toList());
        Map<String, List<UserOrgizationRespDto>> userOrgMap = this.getAccoutMap(accountList);

        /* 校验数据 */
        importDataList = this.verifyData(importDataList,roleMap,customerAreasMap,userOrgMap,orgId);
        List<EmployeeExcelVo> successList = importDataList.stream().filter(dto -> StringUtils.isEmpty(dto.getErrorMsg())).collect(Collectors.toList());

        /* 合并数据 */
        List<EmployeeExcelVo> employeeExcelVoList = this.mergeData(successList);

        Map<String,Long> employeeInfoMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(employeeExcelVoList)){
            List<Long> userIdList = employeeExcelVoList.stream().map(EmployeeExcelVo::getUserId).collect(Collectors.toList());
            employeeInfoMap = this.getEmployeeMap(userIdList,Collections.singletonList(employeeExcelVoList.get(0).getOrgId()));
        }

        /* 处理数据 */
        for (EmployeeExcelVo data : employeeExcelVoList){
            //构建人员对象
            EmployeeExpandReqDto employeeExtReqDto = new EmployeeExpandReqDto();
            employeeExtReqDto.setOrganizationId(data.getOrgId());
            employeeExtReqDto.setOrgId(data.getOrgId());
            employeeExtReqDto.setName(data.getUserName());//姓名
            employeeExtReqDto.setPosition(data.getPosition());//职位
            employeeExtReqDto.setSex(data.getSex());//性别
            employeeExtReqDto.setStation(data.getDepartment());//部门
            // 设置人员类型，内部为0，外部为1
            employeeExtReqDto.setPersonType("内部".equals(data.getEmployeeType()) ? "Internal" : "External");
            employeeExtReqDto.setPhoneNum(data.getPhoneNumber());//手机号码
            employeeExtReqDto.setEmployeeRoleDtoList(data.getRoleList());//角色
            employeeExtReqDto.setUserId(data.getUserId());//账号
            employeeExtReqDto.setStartTime(new Date());
            employeeExtReqDto.setCustomerInfoList(data.getCustomerInfoList());
            employeeExtReqDto.setCustomerBlackList(data.getCustomerBlackList());
            employeeExtReqDto.setRegionInfoList(data.getAreaList());
            employeeExtReqDto.setOrganizationStatus(YesOrNoEnum.NO.getStatus());
            employeeExtReqDto.setStatus(1);
            //查询该账号在组织下是否已被绑定，若已绑定，则修改，没有则新增
//            String key = data.getOrgId() + "_" + data.getUserId();
            try {
//                if(!employeeInfoMap.isEmpty() && employeeInfoMap.containsKey(key)){
//                    Long id = employeeInfoMap.get(key);
//                    //修改
//                    employeeExtReqDto.setId(id);
//                    logger.info("修改人员入参:{}",JSON.toJSONString(employeeExtReqDto));
//                    this.modifyEmployee(instanceId,employeeExtReqDto);
//                }else {
                    //新增
                    logger.info("新增人员入参:{}",JSON.toJSONString(employeeExtReqDto));
                    this.addEmployee(instanceId,employeeExtReqDto);
//                }
            }catch (Exception e){
                logger.info("人员处理执行失败:{}",e);
                setErrorsMsg(importDataList,data.getAccount(),"执行失败！"+e.getMessage());

            }
        }

//        //执行错误的数据形成文件导出
//        List<EmployeeExcelVo> errorList = new ArrayList<>();
//        employeeExcelVoList.forEach(data->{
//            if (StringUtils.isNoneBlank(data.getErrorMsg())){
//                errorList.add(data);
//            }
//        });
        List<EmployeeExcelVo> errorList = importDataList.stream().filter(vo -> StringUtils.isNotEmpty(vo.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(errorList)){
            response.setErrorNum(errorList.size());
            String excelName ="人员导入失败信息-明细Excel-"+ com.dtyunxi.cube.utils.DateUtil.getDateFormat(new Date(), com.dtyunxi.cube.utils.DateUtil.YMDSTRING_DATA);
            String exportUrl;
            try {
                exportUrl = EasyPoiExportUtil.getExportUrl(errorList,EmployeeExcelVo.class, null, excelName, "xls");
                response.setErrorFileUrl(exportUrl);
            } catch (Exception e) {
                logger.info("人员导入失败信息文件生成失败");
                logger.info(e.getMessage(),e);
            }
        }

        response.setSuccessNum(response.getTotalNum()-response.getErrorNum());
        return new RestResponse<>(response);
    }

    /**
     *
     * @param list 原数据
     * @param account 账号
     * @param errorMsg 错误信息
     * @return
     */
    public List<EmployeeExcelVo> setErrorsMsg(List<EmployeeExcelVo> list,String account,String errorMsg){
        list.forEach(vo->{
            if(StringUtils.isBlank(vo.getErrorMsg()) && vo.getAccount().equals(account)){
                vo.setErrorMsg(errorMsg);
            }
        });
        return list;
    }

    /**
     * 校验数据
     * @param list 原数据
     * @return
     */
    public List<EmployeeExcelVo> verifyData(List<EmployeeExcelVo> list, Map<String,List<RoleExpandRespDto>>  roleMap,Map<String,List<CustomerAreaRespDto>> areasMap,
                                            Map<String, List<UserOrgizationRespDto>> userOrgMap,Long orgId){

        List<String> codes = new ArrayList<>();
        for (EmployeeExcelVo vo : list) {
            if (StringUtils.isBlank(vo.getAccount())){
                vo.setErrorMsg("登录账号不能为空");
                continue;
            }

            if(userOrgMap.isEmpty() || !userOrgMap.containsKey(vo.getAccount())){
                vo.setErrorMsg("登录账号错误");
                continue;
            }
            List<UserOrgizationRespDto> userOrgizationVos = userOrgMap.get(vo.getAccount());
            List<UserOrgizationRespDto> userOrgList = userOrgizationVos.stream().filter(e -> orgId.compareTo(e.getOrgId()) == 0).collect(Collectors.toList());
            if(CollectionUtils.isEmpty(userOrgList)){
                vo.setErrorMsg("登录账号所属组织错误");
                continue;
            }
            vo.setUserId(userOrgList.get(0).getUserId());
            vo.setOrgId(orgId);
            if (StringUtils.isBlank(vo.getUserName())){
                vo.setErrorMsg("姓名不能为空");
                continue;
            }
            if (StringUtils.isBlank(vo.getPosition())){
                vo.setErrorMsg("职位不能为空");
                continue;
            }
            if (StringUtils.isBlank(vo.getEmployeeType())){
                vo.setErrorMsg("人员类型不能为空");
                continue;
            }
            if(StringUtils.isBlank(vo.getPhoneNumber())){
                vo.setErrorMsg("手机号不能为空");
                continue;
            }
            if (!("内部".equals(vo.getEmployeeType()) || "外部".equals(vo.getEmployeeType()))){
                vo.setErrorMsg("人员类型只能为'内部'或'外部'");
                continue;
            }
            if(StringUtils.isNotEmpty(vo.getPhoneNumber())){
                if(!CommonUtil.checkPhoneNum(vo.getPhoneNumber())){
                    vo.setErrorMsg("手机号格式不正确;");
                    continue;
                }
            }

            if (StringUtils.isNoneBlank(vo.getRoleName())){
                if(roleMap.isEmpty() || !roleMap.containsKey(vo.getRoleName())){
                    vo.setErrorMsg("角色错误");
                    continue;
                }
                List<RoleExpandRespDto> roleExpandEos = roleMap.get(vo.getRoleName());
                List<RoleExpandRespDto> orgRoleList = roleExpandEos.stream()
                        .filter(e -> (Objects.nonNull(e.getBelongOrgId()) && e.getBelongOrgId().compareTo(vo.getOrgId()) == 0)|| e.getRoleType() == 1)
                        .collect(Collectors.toList());
                if(CollectionUtils.isEmpty(orgRoleList)){
                    vo.setErrorMsg("角色所属组织错误");
                    continue;
                }
                EmployeeRoleReqDto employeeRoleReqDto = new EmployeeRoleReqDto();
                employeeRoleReqDto.setRoleId(orgRoleList.get(0).getId());
                employeeRoleReqDto.setRoleCode(orgRoleList.get(0).getCode());
                vo.setRole(employeeRoleReqDto);
            }
            if (StringUtils.isNoneBlank(vo.getGovernArea())){
                if(areasMap.isEmpty() || !areasMap.containsKey(vo.getGovernArea())){
                    vo.setErrorMsg("管理区域错误");
                    continue;
                }
                List<CustomerAreaRespDto> customerAreaRespDtos = areasMap.get(vo.getGovernArea());
                List<CustomerAreaRespDto> orgAreaList = customerAreaRespDtos.stream().filter(e -> e.getOrgInfoId().compareTo(vo.getOrgId()) == 0).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(orgAreaList)){
                    vo.setErrorMsg("管理区域所属组织错误");
                    continue;
                }
                EmployeeRegionReqDto employeeRegionReqDto = new EmployeeRegionReqDto();
                employeeRegionReqDto.setRegionCode(orgAreaList.get(0).getCode());
                employeeRegionReqDto.setStartTime(new Date());
                vo.setArea(employeeRegionReqDto);
            }
            if(StringUtils.isNotEmpty(vo.getGovernCustomer())){
                codes.add(vo.getGovernCustomer());
            }
            if(StringUtils.isNotEmpty(vo.getBlacklist())){
                codes.add(vo.getBlacklist());
            }
            // 校验手机号和姓名在当前租户下唯一 todo 后面优化为批量的
            String userName = vo.getUserName();
            String phoneNumber = vo.getPhoneNumber();
            EmployeeExtQueryReqDto expandReqDto =  new EmployeeExtQueryReqDto();
            expandReqDto.setName(userName);
            expandReqDto.setPhoneNum(phoneNumber);
            expandReqDto.setOrganizationId(orgId);
            employeeExpandQueryApi.queryEmployeeByPhoneNumOrg(expandReqDto);

        }
        //根据编号获取客户信息
        if (CollectionUtils.isNotEmpty(codes)){
            codes = codes.stream().distinct().collect(Collectors.toList());
            List<CustomerRespDto> customerRespDtos = RestResponseHelper.extractData(employeeCustomerQueryApi.queryCustomerListByCodes(codes));
            Map<String,CustomerRespDto> customersMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(customerRespDtos)){
                customersMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(),(key1,key2)->key2));

            }
            for (EmployeeExcelVo vo : list) {
                if (StringUtils.isNoneBlank(vo.getErrorMsg())){
                    continue;
                }
                if(StringUtils.isNotEmpty(vo.getGovernCustomer())){
                    //根据编号转换管理客户对象
                    if(customersMap.isEmpty() || !customersMap.containsKey(vo.getGovernCustomer())){
                        vo.setErrorMsg("管理客户（客户编号）错误");
                        continue;
                    }
                    CustomerRespDto customerRespDto = customersMap.get(vo.getGovernCustomer());
                    if (null == customerRespDto.getOrgInfoId() || customerRespDto.getMerchantId().compareTo(vo.getOrgId()) !=0){
                        vo.setErrorMsg("管理客户（客户编号）所属组织错误");
                        continue;
                    }
                    EmployeeCustomerReqDto employeeCustomerReqDto = new EmployeeCustomerReqDto();
                    employeeCustomerReqDto.setCustomerId(customerRespDto.getId());
                    employeeCustomerReqDto.setStartTime(new Date());
                    vo.setCustomerDto(employeeCustomerReqDto);
                }

                if(StringUtils.isNotEmpty(vo.getBlacklist())){
                    //根据编号转换黑名单客户对象
                    if(customersMap.isEmpty() || !customersMap.containsKey(vo.getBlacklist())){
                        vo.setErrorMsg("管理黑名单（客户编号）错误");
                        continue;
                    }
                    CustomerRespDto customerBlacklistRespDto = customersMap.get(vo.getBlacklist());
                    if (null == customerBlacklistRespDto.getOrgInfoId() || customerBlacklistRespDto.getMerchantId().compareTo(vo.getOrgId()) !=0){
                        vo.setErrorMsg("管理黑名单（客户编号）所属组织错误");
                        continue;
                    }
                    EmployeeCustomerBlacklistReqDto customerBlacklistReqDto = new EmployeeCustomerBlacklistReqDto();
                    customerBlacklistReqDto.setCustomerId(customerBlacklistRespDto.getId());
                    customerBlacklistReqDto.setStartTime(new Date());
                    vo.setCustomerBlackDto(customerBlacklistReqDto);
                }
            }
        }

        return list;
    }

    /**
     * 合并数据（合并重复的数据）
     * @param list 原数据
     * @return
     */
    private List<EmployeeExcelVo> mergeData(List<EmployeeExcelVo> list) {
        if(CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        //根据账户进行分组
        Map<String, List<EmployeeExcelVo>> employeeGroupMap = list.stream().collect(Collectors.groupingBy(EmployeeExcelVo::getAccount));
        List<EmployeeExcelVo> resultVoList = Lists.newArrayList();
        for (String account : employeeGroupMap.keySet()) {
            List<EmployeeExcelVo> employeeExcelVos = employeeGroupMap.get(account);
            EmployeeExcelVo vo = new EmployeeExcelVo();
            CubeBeanUtils.copyProperties(vo,employeeExcelVos.get(0));
            //合并多个角色
            List<EmployeeRoleReqDto> roleList = employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getRole())).map(EmployeeExcelVo::getRole)
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(EmployeeRoleReqDto :: getRoleId))), ArrayList::new));
            if(CollectionUtils.isNotEmpty(roleList)){
                vo.setRoleList(roleList);
            }
            //合并多个区域
            List<EmployeeRegionReqDto> areaList = employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getArea())).map(EmployeeExcelVo::getArea)
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(EmployeeRegionReqDto :: getRegionCode))), ArrayList::new));
            if(CollectionUtils.isNotEmpty(areaList)){
                vo.setAreaList(areaList);
            }
            //合并多个管理客户
            List<EmployeeCustomerReqDto> customerInfoList = employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getCustomerDto())).map(EmployeeExcelVo::getCustomerDto)
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(EmployeeCustomerReqDto :: getCustomerId))), ArrayList::new));
            if(CollectionUtils.isNotEmpty(customerInfoList)){
                vo.setCustomerInfoList(customerInfoList);
            }
            //合并多个黑名单客户
            List<EmployeeCustomerBlacklistReqDto> customerBlackList = employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getCustomerBlackDto())).map(EmployeeExcelVo::getCustomerBlackDto)
                    .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(EmployeeCustomerBlacklistReqDto :: getCustomerId))), ArrayList::new));
            if(CollectionUtils.isNotEmpty(customerBlackList)){
                vo.setCustomerBlackList(customerBlackList);
            }
            resultVoList.add(vo);
        }

        return resultVoList;
    }





    /**
     * 填充客户姓名和编号
     *
     * @param dtoList
     */
    private void fillCustomInfo(List<EmployeeExpandRespDto> dtoList,Long merchantId) {
        List<Long> orgIdList = dtoList.stream().map(EmployeeExtRespDto::getOrganizationId).distinct().collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(orgIdList)){
            //客户人员查询
            CustomerSearchExtReqDto customerExtQuery = new CustomerSearchExtReqDto();
            customerExtQuery.setMerchantId(merchantId);
            customerExtQuery.setOrgInfoIds(orgIdList);
            List<CustomerRespDto> customerRespDtos = RestResponseHelper.extractData(customerQueryV3Api.queryCustomerByExtDtoList(customerExtQuery));
            if(CollectionUtils.isEmpty(customerRespDtos)){
                return;
            }
            Map<String, CustomerRespDto> customerMap  = customerRespDtos.stream().collect(Collectors.toMap(dto ->{
               return merchantId +"_"+ dto.getOrgInfoId();
            }, Function.identity()));
            for (EmployeeExtRespDto dto : dtoList) {
                String key = merchantId+"_"+dto.getOrganizationId();
                if(!customerMap.isEmpty() && customerMap.containsKey(key)){
                    CustomerRespDto customerRespDto = customerMap.get(key);
                    dto.setCustomerName(customerRespDto.getName());
                    dto.setCustomerCode(customerRespDto.getCode());
                }
            }
        }
    }

    /**
     * 填充客户编号和客户名称
     *
     * @param dtoList 返回的数据list
     */
    private void fillCustomerCodeAndName(List<EmployeeExpandRespDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        for (EmployeeExtRespDto respDto : dtoList) {
            if (Objects.isNull(respDto.getId())) {
                continue;
            }
            CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
            customerExtReqDto.setInstanceId(respDto.getInstanceId());
            //customerExtReqDto.setTenantId(respDto.getTenantId());
            customerExtReqDto.setOrgInfoId(respDto.getOrganizationId());
            customerExtReqDto.setEmployeeIds(Arrays.asList(respDto.getId()));
            customerExtReqDto.setType(respDto.getType());
            // 审核状态（WAIT_AUDIT：待审核、AUDIT_REJECT：审核不通过、AUDIT_PASS：审核通过、INVALID：作废、DRAFT：草稿）
            // customerExtReqDto.setAuditStatus("AUDIT_PASS");
            List<EmployeeCustomerRespDto> customerRespDtos = RestUtil.checkResponse(employeeCustomerQueryApi.queryEmployee(customerExtReqDto));
            if (CollectionUtils.isNotEmpty(customerRespDtos)) {
                EmployeeCustomerRespDto customerRespDto = customerRespDtos.get(0);
                respDto.setCustomerName(customerRespDto.getCustomerName());
                respDto.setCustomerCode(customerRespDto.getCustomerCode());
            }
        }
    }

    /**
     * 根据客户ID查询管理区域数和管理客户数
     * @param dtoList 返回dto数组
     * @param orgId 组织ID
     * @param instanceId 实例ID
     * @param tenantId 应用ID
     */
    private void fillCustomerAndRegionNum(List<EmployeeExpandRespDto> dtoList, Long orgId, Long instanceId, Long tenantId) {
        if (CollectionUtils.isEmpty(dtoList)){
            return;
        }
        List<Long> employeeIds = dtoList.stream().map(EmployeeExpandRespDto::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(employeeIds)){
            return;
        }
        EmployeeNumCountReqDto reqDto = new EmployeeNumCountReqDto();
        reqDto.setEmployeeIds(employeeIds);
        reqDto.setOrgId(orgId);
        //reqDto.setInstanceId(instanceId);
        //reqDto.setTenantId(tenantId);
        RestResponse<List<EmployeeNumCountRespDto>> response = employeeCustomerQueryApi.queryCountByEmployeeId(reqDto);
        if (Objects.nonNull(response) && "0".equals(response.getResultCode()) && CollectionUtils.isNotEmpty(response.getData())){
            List<EmployeeNumCountRespDto> list = response.getData();
            for (EmployeeExpandRespDto dto : dtoList) {
                for (EmployeeNumCountRespDto countNumDto : list){
                    if (Objects.nonNull(dto) && Objects.nonNull(dto.getId())
                            && Objects.nonNull(countNumDto) && Objects.nonNull(countNumDto.getEmployeeId())
                            && dto.getId().longValue() == countNumDto.getEmployeeId().longValue()){
                        dto.setCustomerNum(countNumDto.getCustomerNum());
                        dto.setRegionNum(countNumDto.getRegionNum());
                    }
                }
            }
        }
    }

    /**
     * 封装组织信息
     * @param dtoList
     */
    private void fillOrganizationInfo(List<EmployeeExpandRespDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        //组织id
        List<Long> organizationIdList = dtoList.stream().map(EmployeeExpandRespDto::getOrganizationId).collect(Collectors.toList());

        OrgSellerCustomerQueryReqDto queryReqDto = new OrgSellerCustomerQueryReqDto();
        queryReqDto.setPageNum(1);
        queryReqDto.setPageSize(organizationIdList.size());
        queryReqDto.setMerchantIdList(organizationIdList);
        RestResponse<PageInfo<OrgSellerCustomerRespDto>> orgSellerCustomerRest = orgSellerCustomerQueryApi.orgSellerCustomerPage(queryReqDto);
        Map<Long, OrgSellerCustomerRespDto> orgSellerMap = new HashMap<>();
        if(orgSellerCustomerRest != null && CollectionUtils.isNotEmpty(orgSellerCustomerRest.getData().getList())){
            List<OrgSellerCustomerRespDto> orgSellerList = orgSellerCustomerRest.getData().getList();
            orgSellerMap = orgSellerList.stream().collect(Collectors.toMap(OrgSellerCustomerRespDto::getOrgId, Function.identity(), (k1, k2) -> k1));
        }

        for (EmployeeExpandRespDto respDto : dtoList) {
            if(!orgSellerMap.isEmpty() && orgSellerMap.containsKey(respDto.getOrganizationId())){
                OrgSellerCustomerRespDto orgSellerCustomerRespDto = orgSellerMap.get(respDto.getOrganizationId());
                respDto.setOrganizationCode(orgSellerCustomerRespDto.getOrgCode());
                respDto.setOrganizationName(orgSellerCustomerRespDto.getOrgName());
                respDto.setSellerId(orgSellerCustomerRespDto.getSellerId());
                respDto.setSellerName(orgSellerCustomerRespDto.getSellerName());
                respDto.setSuperiorSellerName(orgSellerCustomerRespDto.getSuperiorSellerName());
                respDto.setDealerCode(orgSellerCustomerRespDto.getDealerCode());
            }
        }
    }

    /**
     * 绑定人员区域、人员客户、人员黑名单
     *
     * @param employeeDto
     */
//    @Transactional(rollbackFor = Exception.class)
    public void bindEmployeeCustomer(EmployeeExpandReqDto employeeDto) {
        logger.info("进入绑定人员客户");
//        String organizationId = super.getHeaderOrgId();
        //AssertUtil.assertNotBlank(organizationId, "请求头缺失组织ID[yes-req-cus-b2b-organizationId]");
        EmployeeCustomerAddReqDto bindCustomerDto = new EmployeeCustomerAddReqDto();
        bindCustomerDto.setEmployeeId(employeeDto.getId());
        bindCustomerDto.setUserId(employeeDto.getUserId());
        if(Objects.isNull(employeeDto.getUserId()) && StringUtils.isNotEmpty(employeeDto.getUserName())){
            //根据用户名称获取用户id
            UserQueryReqDto userQueryReqDto = new UserQueryReqDto();
            userQueryReqDto.setUserNames(Collections.singletonList(employeeDto.getUserName()));
            List<UserRespDto> userRespDtos = RestResponseHelper.extractData(userExtQueryApi.queryUserByUserNames(userQueryReqDto));
            bindCustomerDto.setUserId(userRespDtos.get(0).getId());
        }

        bindCustomerDto.setMerchantId(Optional.ofNullable(getHeaderOrgId()).orElse(employeeDto.getOrganizationId()));
        if(YesOrNoEnum.isYes(employeeDto.getOrganizationStatus())){
            bindCustomerDto.setMerchantId(Optional.ofNullable(getHeaderOrgId()).orElse(employeeDto.getOrgId()));
        }
        bindCustomerDto.setRegionInfoList(employeeDto.getRegionInfoList());
        bindCustomerDto.setCustomerInfoList(employeeDto.getCustomerInfoList());
        if (CollectionUtils.isEmpty(bindCustomerDto.getCustomerInfoList()) && StringUtils.isNotEmpty(employeeDto.getCustomerCode())){
            EmployeeCustomerReqDto employeeCustomerReqDto = new EmployeeCustomerReqDto();
            employeeCustomerReqDto.setEmployeeId(employeeDto.getId());
            employeeCustomerReqDto.setMerchantId(getHeaderOrgId());
            employeeCustomerReqDto.setUserId(employeeDto.getUserId());
            employeeCustomerReqDto.setStartTime(new Date());
            CustomerSearchExtReqDto searchReqDto = new CustomerSearchExtReqDto();
            searchReqDto.setCode(employeeDto.getCustomerCode());
            searchReqDto.setPageNum(1);
            searchReqDto.setPageSize(1);
            List<CustomerRespDto> customerRespDtos = RestUtil.checkResponse(customerQueryV3Api.queryCustomerByExtDtoList(searchReqDto));
            if (CollectionUtils.isNotEmpty(customerRespDtos)){
                employeeCustomerReqDto.setCustomerId(customerRespDtos.get(0).getId());
                bindCustomerDto.setCustomerInfoList(Lists.newArrayList(employeeCustomerReqDto));
            }
        }
        bindCustomerDto.setCustomerBlackList(employeeDto.getCustomerBlackList());
        employeeCustomerApi.saveEmployeeBindInfo(bindCustomerDto);
        logger.info("进入绑定人员客户结束");
    }

    public Long getHeaderOrgId() {
        String organizationId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationId");
        logger.info("获取请求头组织ID：{}", organizationId);
        if (StringUtils.isEmpty(organizationId)) {
            return null;
        }
        return Long.parseLong(organizationId);
    }
    @Override
    public RestResponse<PageInfo<EmployeeExpandRespDto>> queryPageByOrg(Long organizationId, Integer pageNum, Integer pageSize) {
        EmployeeExpandQueryReqDto queryReqDto = new EmployeeExpandQueryReqDto();
        queryReqDto.setPageNum(pageNum);
        queryReqDto.setPageSize(pageSize);
        queryReqDto.setOrganizationId(organizationId);
        return this.queryByPage(queryReqDto);
    }


    /**
     * 查询用户的绑定人员有效的组织id
     * @param userId
     * @return
     */
    @Override
    public RestResponse<List<Long>> getEmployeeOrgIdByUserId(Long userId){
        return employeeExpandQueryApi.getEmployeeOrgIdByUserId(userId);
    }

    @Override
    public RestResponse<List<EmployeeExtRespDto>> queryByRole(Long roleId, Long instanceId) {
        String organizationId = this.headerOrgId();
        logger.info("请求头组织ID：{}", organizationId);
        ServiceContext.getContext().set("yes.req.cus.b2b.organizationId",organizationId);
        MDC.put("yes.req.cus.b2b.organizationId",organizationId);
        return employeeExpandQueryApi.queryByRole(roleId,instanceId,organizationId);
    }

    /**
     * 查询用户的绑定人员有效的组织
     * @param userId
     * @return
     */
    @Override
    public RestResponse<List<OrganizationDto>> getOrgInfoByUserId(Long userId){
        List<OrganizationDto> organizationDtos = RestResponseHelper.extractData(employeeExpandQueryApi.getOrgInfoByUserId(userId));
        if(CollectionUtils.isEmpty(organizationDtos)){
            return new RestResponse<>();
        }
        List<Long> orgIdList = organizationDtos.stream().map(OrganizationDto::getId).collect(Collectors.toList());
        SellerExtQueryReqDto sellerExtQueryReqDto = new SellerExtQueryReqDto();
        sellerExtQueryReqDto.setOrgIdList(orgIdList);
        //查询商家信息
        List<SellerRespDto> sellerRespDtos = RestResponseHelper.extractData(sellerExpandQueryApi.queryBatchSellerList(sellerExtQueryReqDto));
        if(CollectionUtils.isEmpty(sellerRespDtos)){
            return new RestResponse<>(organizationDtos);
        }
        Map<Long, SellerRespDto> sellerOrgMap = sellerRespDtos.stream().collect(Collectors.toMap(SellerRespDto::getOrganizationId, Function.identity(), (k1, k2) -> k1));
        for (OrganizationDto organizationDto : organizationDtos) {
            if(sellerOrgMap.isEmpty() || !sellerOrgMap.containsKey(organizationDto.getId())){
                continue;
            }
            SellerRespDto sellerRespDto = sellerOrgMap.get(organizationDto.getId());
            organizationDto.setName(sellerRespDto.getName());
        }

        return new RestResponse<>(organizationDtos);
    }

    /**
     * 根据角色名称获取角色信息
     * @param roleNameList
     * @param orgId
     * @return
     */
    @Override
    public  Map<String, List<RoleExpandRespDto>> getRoleMap(List<String> roleNameList,Long orgId){
        if(CollectionUtils.isEmpty(roleNameList)){
            return new HashMap();
        }
        Map<String, List<RoleExpandRespDto>> roleMap = new HashMap<>(roleNameList.size() *4/3+2);
        RoleExpandReqDto roleExpandReqDto = new RoleExpandReqDto();
        roleExpandReqDto.setOrgId(orgId);
        roleExpandReqDto.setRoleNameList(roleNameList);
        List<RoleExpandRespDto> roleExpandRespDtos = RestResponseHelper.extractData(roleQueryApi.getRoleByNameList(roleExpandReqDto));
        if(CollectionUtils.isEmpty(roleExpandRespDtos)){
            return roleMap;
        }
        roleMap = roleExpandRespDtos.stream().collect(Collectors.groupingBy(RoleExpandRespDto::getName));
        return roleMap;
    }

    /**
     * 根据用户账户获取用户信息
     * @param accountList
     * @return
     */
    @Override
    public  Map<String, List<UserOrgizationRespDto>> getAccoutMap(List<String> accountList){
        if(CollectionUtils.isEmpty(accountList)){
            return new HashMap<>();
        }
        Map<String, List<UserOrgizationRespDto>> userOrgMap = new HashMap<>(accountList.size() *4/3+2);
        List<UserOrgizationRespDto> userOrgInfoList = RestResponseHelper.extractData(userOrgExpandQueryApi.queryUserOrgByUserName(accountList));
        if(CollectionUtils.isEmpty(userOrgInfoList)){
            return userOrgMap;
        }
        userOrgMap = userOrgInfoList.stream().collect(Collectors.groupingBy(UserOrgizationRespDto::getUserName));
        return userOrgMap;
    }

    /**
     * 根据客户区域编码获取区域信息
     * @param governAreaList
     * @return
     */
    @Override
    public  Map<String, List<CustomerAreaRespDto>>  getCustomerAreaMap(List<String> governAreaList){
        Map<String, List<CustomerAreaRespDto>> customerAreasMap = new HashMap<>(governAreaList.size() *4/3+2);
        if(CollectionUtils.isEmpty(governAreaList)) {
           return customerAreasMap;
        }
        CustomerAreaListExtReqDto areaListReqDto = new CustomerAreaListExtReqDto();
        areaListReqDto.setNameList(governAreaList);
        RestResponse<List<CustomerAreaRespDto>> areaRest = employeeRegionQueryApi.queryCustomerAreaByNames(areaListReqDto);
        if (null == areaRest || CollectionUtils.isEmpty(areaRest.getData())) {
            return customerAreasMap;
        }
        List<CustomerAreaRespDto> customerAreaList = areaRest.getData();
        customerAreasMap = customerAreaList.stream().collect(Collectors.groupingBy(CustomerAreaRespDto::getName));
        return customerAreasMap;
    }

    /**
     * 根据组织id和用户id获取员工ID信息
     * @param userIdList
     * @param orgIdList
     * @return
     */
    @Override
    public  Map<String,Long> getEmployeeMap(List<Long> userIdList,List<Long> orgIdList ){
        Map<String,Long> employeeInfoMap = new HashMap<>();
        if(CollectionUtils.isEmpty(userIdList)){
            return employeeInfoMap;
        }
        EmployeeExtQueryReqDto dto = new EmployeeExtQueryReqDto();
        dto.setOrganizationIdList(orgIdList);
        dto.setUserIds(userIdList);
        List<EmployeeExtRespDto> employeeList = RestResponseHelper.extractData(employeeExpandQueryApi.getEmployeeByUserOrgList(dto));
        if(CollectionUtils.isNotEmpty(employeeList)){
            employeeInfoMap = employeeList.stream().collect(Collectors.toMap(ee->{return ee.getOrganizationId()+"_"+ee.getUserId();},EmployeeExtRespDto::getId));
        }
        return employeeInfoMap;
    }


    /**
     * 根据组织名称获取组织信息
     * @param nameList
     * @return
     */
    @Override
    public Map<String,OrganizationDto> getOrgByNameMap(List<String> nameList){
        if(CollectionUtils.isEmpty(nameList)){
            return new HashMap<>();
        }
        List<OrganizationDto> dtoList = RestResponseHelper.extractData(orgInfoExtQueryApi.getOrgByNameList(nameList));
        if(CollectionUtils.isEmpty(dtoList)){
            return new HashMap<>();
        }
        Map<String, OrganizationDto> organizationEoMap = dtoList.stream().collect(Collectors.toMap(OrganizationDto::getName, Function.identity(), (k1, k2) -> k1));
        return organizationEoMap;
    }




}
