package com.dtyunxi.yundt.module.customer.biz.util;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 发送HTTP请求工具类
 *
 * @author jiejun
 * @Date 2021/9/7 10:52
 */
@Service
public class HttpExtUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpExtUtil.class);
    @Autowired
    private RestTemplate restTemplate;

    public <T>T httpGet(String url, Map<String,Object> params,Class<T> clazz){
        return httpGet(url,params,null,clazz);
    }

    public  <T>T httpGet(String url, Map<String,Object> params,Map<String,Object> header,Class<T> clazz){
        url = generateRequestParameters(url,params);
        ResponseEntity<T> forEntity = restTemplate.getForEntity(url, clazz);
        return forEntity.getBody();
    }

    public <T>T httpPost(String url, Map<String,Object> paramsMap,Map<String,Object> jsonMap,Class<T> clazz){
        return httpPost(url,paramsMap,jsonMap,null,clazz);
    }

    public <T>T httpPost(String url, Map<String,Object> jsonMap,Class<T> clazz){
        return httpPost(url,null,jsonMap,null,clazz);
    }

    public <T>T httpPost(String url,Map<String,Object> paramsMap, Map<String,Object> jsonMap,Map<String,Object> header,Class<T> clazz){
        logger.info("------>HttpPost：{}，{}，{}，{}",url, JSONObject.toJSONString(paramsMap),JSONObject.toJSONString(jsonMap),JSONObject.toJSONString(header));
        if (ObjectUtils.isNotEmpty(paramsMap)){
            url = generateRequestParameters(url,paramsMap);
        }
        ResponseEntity<T> forEntity = restTemplate.postForEntity(url,generatePostJson(jsonMap,header),clazz);
        logger.info("------>HttpPost结果：{}",JSONObject.toJSONString(forEntity));
        return forEntity.getBody();
    }

    /**
     * 拼接GET请求参数URL
     *
     * @param url 请求URL
     * @param params 请求参数
     * @return String
     */
    private String generateRequestParameters(String url,Map<String,Object> params){
        StringBuffer sb = new StringBuffer(url);
        if (ObjectUtils.isNotEmpty(params)){
            sb.append("?");
            for (Map.Entry map : params.entrySet()) {
                sb.append(map.getKey())
                        .append("=")
                        .append(map.getValue())
                        .append("&");
            }
            url = sb.substring(0, sb.length() - 1);
            return url;
        }
        return sb.toString();
    }

    /**
     * 组合post请求的body参数及header
     * @param jsonMap json参数
     * @param headerMap 请求头参数
     * @return HttpEntity
     */
    public HttpEntity<Map<String, Object>> generatePostJson(Map<String, Object> jsonMap,Map<String,Object> headerMap) {
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json;charset=UTF-8");
        httpHeaders.setContentType(type);

        //设置接收返回值的格式为json
        List<MediaType> mediaTypeList = new ArrayList<>();
        mediaTypeList.add(MediaType.APPLICATION_JSON_UTF8);
        httpHeaders.setAccept(mediaTypeList);

        if (ObjectUtils.isNotEmpty(headerMap)){
            for (Map.Entry map : headerMap.entrySet()){
                httpHeaders.add(map.getKey().toString(),map.getValue().toString());
            }
        }
        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(jsonMap, httpHeaders);

        return httpEntity;
    }

}
