/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserAccessRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserAccessVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserVo;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.customer.api.dto.response.LoginDto;
import com.dtyunxi.yundt.module.customer.biz.service.ILoginService;
import com.dtyunxi.yundt.module.customer.biz.service.IRoleService;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements ILoginService {
    private static final Logger logger = LoggerFactory.getLogger(LoginServiceImpl.class);
    @Resource
    IRoleService roleService;
    @Resource
    IUserQueryApi userQueryApi;

    @Override
    public RestResponse getAccessInfo() {
        Long userId = ServiceContext.getContext().getRequestUserId();
        Long instanceId = ServiceContext.getContext().getRequestInstanceId();
        logger.info("================\u83b7\u53d6\u8d44\u6e90\u65f6\u7684\u5e94\u7528\u5b9e\u4f8bID\uff1a" + instanceId);
        UserAccessVo userAccessVo = (UserAccessVo)this.roleService.queryUserAccess(instanceId, userId).getData();
        LoginDto loginDto = new LoginDto();
        loginDto.setUserAccessVo(userAccessVo);
        String[] exm = new String[]{"role"};
        RestResponse userRoleResp = this.userQueryApi.queryByIdAndResource(userId, exm, "{}");
        if (!userRoleResp.getResultCode().equals("0")) {
            throw new BusinessRuntimeException(userRoleResp.getResultMsg());
        }
        UserVo userVo = (UserVo)userRoleResp.getData();
        if (userVo != null && CollectionUtils.isNotEmpty((Collection)userVo.getRoleSet())) {
            for (RoleDto roleDto : userVo.getRoleSet()) {
                if ("tenant".equals(roleDto.getCode())) {
                    loginDto.setMenuType("tenant");
                    break;
                }
                if (!"system".equals(roleDto.getCode())) continue;
                loginDto.setMenuType("system");
                break;
            }
        }
        RestResponse result = new RestResponse();
        result.setData((Object)loginDto);
        return result;
    }

    @Override
    public UserAccessRespDto queryUserAccessResources() {
        Long userId = ServiceContext.getContext().getRequestUserId();
        UserAccessRespDto data = (UserAccessRespDto)this.roleService.queryUserAccessResources(userId).getData();
        return data;
    }
}

