package com.dtyunxi.yundt.module.customer.biz.mq.process;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.cube.biz.commons.utils.ExcelUtil;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerDataApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerImportSaveReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerInfoExcelReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ImportEventReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ImportUpdateReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.enmus.ImportStatusEnum;
import com.dtyunxi.yundt.module.customer.biz.mq.constants.MessageTag;
import com.dtyunxi.yundt.module.customer.biz.mq.constants.MessageTopic;
import com.dtyunxi.yundt.module.customer.biz.service.ICustomerImportLogService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;

/**
 * 客户信息导入监听与处理
 *
 * @author sumo on 2020/10/13 0013
 */

@Component
@MQDesc(topic = MessageTopic.CUSTOMER_INFO_IMPORT_TOPIC, tag = MessageTag.CUSTOMER_INFO_IMPORT_TAG)
public class CustomerInfoImportProcessor implements IMessageProcessor<CustomerImportSaveReqDto> {
    @Resource
    private ICacheService cacheService;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private ICustomerDataApi iCustomerDataApi;
    @Resource
    private ICustomerImportLogService customerImportLogService;
    @Resource
    private OssRegistryVo ossRegistryVo;

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public MessageResponse process(CustomerImportSaveReqDto eventDto) {
        logger.info("客户批量导入 ---> 收到批量客户信息批量导入的MQ消息" + eventDto.getTenantId());
        //注入实例id
        ServiceContext.getContext().setAttachment("yes.req.tenantId", String.valueOf(eventDto.getTenantId()));
        ServiceContext.getContext().setAttachment("yes.req.instanceId", String.valueOf(eventDto.getInstanceId()));
        MDC.put("yes.req.requestId", UUID.randomUUID().toString().replace("-", ""));

        logger.info("客户批量导入 ---> 收到批量客户信息批量导入的MQ消息:{}", JSON.toJSONString(eventDto) + "instanceId" + ServiceContext.getContext().getRequestInstanceId());
        //检查消息体内容信息
        if (eventDto.getUrl() == null) {
            logger.error("消息体内容不全，忽略处理");
            return MessageResponse.SUCCESS;
        }
        //todo:sumo增加判断模板是否异常
        if (StringUtils.isNotBlank(cacheService.getCache("customerExcelImportKey", eventDto.getId() + "", String.class))) {
            //该文件正在处理中，不处理
            return MessageResponse.SUCCESS;
        } else {
            cacheService.setCache("customerExcelImportKey", eventDto.getId() + "", "{}", 10);
        }
        final ImportUpdateReqDto memberImportRespDto = new ImportUpdateReqDto();
        try {
            long currentTimeMillis = System.currentTimeMillis();
            //2、获取消息体的导入文件URL地址
            logger.info("客户批量导入进行中 ---> 开始下载excel");
            InputStream is = getInputStream(eventDto.getUrl());
            // 转换导入数据
            logger.info("客户批量导入进行中 ---> 开始读取excel");
            ExcelImportResult<CustomerInfoExcelReqDto> objectExcelImportResult =
                    EasyPoiExportUtil.importExcel(is, 0, 1, CustomerInfoExcelReqDto.class);
            logger.info("客户批量导入进行中 ---> 读取excel成功,时间花费{}毫秒", System.currentTimeMillis() - currentTimeMillis);
            List<CustomerInfoExcelReqDto> customerInfoExcelReqDtos = objectExcelImportResult.getList();
            logger.info("客户批量导入进行中 --->提取数据成功,数据量" + customerInfoExcelReqDtos.size());
            //todo:sumo 做好超大数据校验
            if (customerInfoExcelReqDtos.isEmpty() || customerInfoExcelReqDtos.size() > 50000) {
                logger.error("客户信息批量导入数据为空或者超过最大数量");
                ImportUpdateReqDto eo = new ImportUpdateReqDto();
                eo.setId(eventDto.getId());
                eo.setStatus(ImportStatusEnum.EMPTY.getCode());
                eo.setTotalNum(0);
                eo.setErrorNum(0);
                eo.setSuccessNum(0);
                eo.setRepeatNum(0);
                eo.setErrorReason("客户信息批量导入数据为空或者超过最大数量");
                iCustomerDataApi.update(eo);
                return MessageResponse.SUCCESS;
            }

            ImportEventReqDto importEventReqDto = new ImportEventReqDto();
            BeanUtils.copyProperties(eventDto, importEventReqDto);
            importEventReqDto.setCustomerInfoExcelReqList(customerInfoExcelReqDtos);
            int totalSize = customerInfoExcelReqDtos.size();
            //todo: sumo  校验长度



            customerImportLogService.importCustomer(importEventReqDto, dataValidateResult -> {

                /*********************************************   数据校验结果处理  ***********************************************************/
                String downloadUrl = null;
                if (dataValidateResult.getErrorCustomerInfoExcelList().size() > 0) {
                    //封装Excel文件
                    String fileName = "客户信息错误列表" + com.dtyunxi.cube.utils.DateUtil.getDateFormat(new Date(), "yyyyMMddHHmmss") + String.format("%02d", new Random().nextInt(100)) + ".xlsx";
                    //生成excel并输出inputStream
                    InputStream inputStream = ExcelUtil.createExcel(new String[]{"客户信息错误列表"}, dataValidateResult.getErrorCustomerInfoExcelList());
                    //上传到oss
                    objectStorageService.put(ossRegistryVo.getBucketName(), fileName, inputStream);
                    //拼接下载链接
                    downloadUrl = objectStorageService.getFileUrl(fileName);
                    logger.info("客户批量导入 ---> 上传错误的Excel成功，连接地址：{}", downloadUrl);
                }

                Integer errorNum = dataValidateResult.getErrorCustomerInfoExcelList().size();
                Integer successNum = dataValidateResult.getCustomerInfoExcelList().size();

                memberImportRespDto.setTotalNum(totalSize);
                memberImportRespDto.setErrorNum(errorNum);
                memberImportRespDto.setSuccessNum(totalSize - errorNum);
                memberImportRespDto.setStatus(ImportStatusEnum.LOADING.getCode());
                memberImportRespDto.setErrorReason(downloadUrl);

                logger.info("客户批量导入 ---> 总数量:{} 不合格的数据量：{}，合格的数据量：{}", memberImportRespDto.getTotalNum(), errorNum, successNum);


                //就算有不合格数据，合格的数据先进行注册
                return true;
            });

            memberImportRespDto.setStatus(ImportStatusEnum.SUCCESS.getCode());
        } catch (Exception e) {
            // 不确认消息， 该消息会被重新投递
            logger.error("", e);
            e.printStackTrace();
            logger.info("客户批量导入异常 ---> 不会被重新投递");
            memberImportRespDto.setStatus(ImportStatusEnum.ERROR.getCode());
            return MessageResponse.SUCCESS;
        } finally {
            memberImportRespDto.setId(eventDto.getId());
            iCustomerDataApi.update(memberImportRespDto);

        }
        return MessageResponse.SUCCESS;
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        return conn.getInputStream();
    }
}
