package com.dtyunxi.yundt.module.customer.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AddressTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerInfoExcelReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ImportEventReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.*;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerLevelQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerStatusQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaGroupQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IAuthItemRuleApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.AuthItemRuleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BillInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ContactsInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerService;
import com.dtyunxi.yundt.module.customer.api.dto.request.CustomerDetailReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.UserAccountReqDto;
import com.dtyunxi.yundt.module.customer.biz.service.ICustomerImportLogService;
import com.dtyunxi.yundt.module.customer.biz.util.BeanHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.Predicate;
import java.util.stream.Collectors;

import static com.dtyunxi.yundt.module.customer.biz.util.CommonUtil.validateMobilePhone;


@Service
public class CustomerImportLogServiceImpl implements ICustomerImportLogService {

    private Logger logger = LoggerFactory.getLogger(CustomerImportLogServiceImpl.class);


    @Autowired
    private IAreaQueryApi areaQueryApi;

    @Autowired
    private ICustomerTypeQueryApi iCustomerTypeQueryApi;

    @Resource
    private IAreaGroupQueryApi areaGroupQueryApi;

    @Resource
    private ICustomerStatusQueryApi customerStatusQueryApi;
    @Resource
    private ICustomerStatusQueryApi iCustomerStatusQueryApi;

    @Autowired
    private IUserQueryApi iUserQueryApi;
    @Autowired
    private ICustomerService iCustomerService;

    @Resource
    private ICustomerQueryApi customerQueryApi;

    @Resource
    private ICustomerLevelQueryApi customerLevelQueryApi;

    @Resource
    private IContext context;

    @Resource
    private IAuthItemRuleApi authItemRuleApi;

    @Override
    public void importCustomer(ImportEventReqDto memberImportReqDto, Predicate<CustomerImportDataValidateRespDto> dataValidateResultHandler) {
        logger.info("客户批量导入 ---> 获取校验所需数据中" + memberImportReqDto.getUrl());
        //获取所有有效的客户类型
        List<CustomerTypeRespDto> customerTypeEos = iCustomerTypeQueryApi.queryAllSimpleCustomerType(memberImportReqDto.getType()).getData();
        //获取所有有效账户状态
        List<CustomerStatusRespDto> customerStatusRespDtoList = iCustomerStatusQueryApi.queryByList("").getData();
        //获取所有区域编码
        PageInfo<AreaGroupRespDto> groupRespDtoPageInfo = areaGroupQueryApi.queryByPage("{}", 1, Integer.MAX_VALUE).getData();
        List<AreaGroupRespDto> areaGroupRespDtoList = groupRespDtoPageInfo.getList();
        List<String> regionNameList = areaGroupRespDtoList.stream().map(AreaGroupRespDto::getName).collect(Collectors.toList());
        Map<String, String> regionCodeMap = areaGroupRespDtoList.stream()
                .collect(Collectors.toMap(AreaGroupRespDto::getName, AreaGroupRespDto::getCode, (e1, e2) -> e1));
        //获取所有客户
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        if (Objects.isNull(searchReqDto.getTenantId())) {
            searchReqDto.setTenantId(context.tenantId());
        }
        RestResponse<List<CustomerRespDto>> listRestResponse = customerQueryApi.queryByList(JSON.toJSONString(searchReqDto));
        List<CustomerRespDto> customerRespList = RestResponseHelper.extractData(listRestResponse);

        //获取所有客户级别
        RestResponse<List<CustomerLevelRespDto>> levelRestResp = customerLevelQueryApi.queryByList("{}");
        List<CustomerLevelRespDto> levelList = RestResponseHelper.extractData(levelRestResp);
        Map<String, Long> levelIdMap = levelList.stream()
                .collect(Collectors.toMap(CustomerLevelRespDto::getName, CustomerLevelRespDto::getId, (e1, e2) -> e1));
        //获取所有业务员
        PageInfo<UserDto> userDtoPageInfo = iUserQueryApi.queryUser(memberImportReqDto.getTenantId(), "", "", "", "", 1, Integer.MAX_VALUE).getData();
        List<UserDto> userDtoList = userDtoPageInfo.getList();

        logger.info("客户批量导入 ---> 开始导入数据校验");
        CustomerImportDataValidateRespDto dataValidateResult = this.importDataVerify(memberImportReqDto, customerTypeEos, customerStatusRespDtoList, regionNameList, userDtoList,customerRespList,levelList);
        logger.info("客户批量导入 ---> 结束导入数据校验");

        logger.info("客户批量导入 ---> 开始客户导入业务");
        dataValidateResult.getCustomerInfoExcelList().parallelStream().forEach(customerInfoExcelReqDto -> {
            try {
                logger.info("客户批量导入 ---> 进行数据构建" + memberImportReqDto.getUrl());
                BeanHelper.beanAttributeValueTrim(customerInfoExcelReqDto);

                //初始化CustomerDetailReqDto
                CustomerDetailReqDto customerDetailReqDto1 = getCustomerDetailReqDto(memberImportReqDto, customerTypeEos, customerStatusRespDtoList, regionCodeMap, customerInfoExcelReqDto, userDtoList,customerRespList,levelIdMap);

                //完成用户账号对象构建
                buildUserAccountReqDto(customerInfoExcelReqDto, customerDetailReqDto1);
                //完成用户联系人对象构建
                List<ContactsInfoDto> contactsInfoDtos = new ArrayList<>(1);
                contactsInfoDtos.add(buildContactsInfoDto(customerInfoExcelReqDto));
                customerDetailReqDto1.setContactsInfoList(contactsInfoDtos);
                //构建发票对象
                List<BillInfoDto> billInfoDtos = new ArrayList<>(1);
                billInfoDtos.add(buildBillInfoDto(customerInfoExcelReqDto));
                customerDetailReqDto1.setBillInfoList(billInfoDtos);
                if (StringUtils.isNotBlank(customerInfoExcelReqDto.getProvince())){
                    //构建地址对象
                    customerDetailReqDto1.setAddressDto(buildAddressDto(customerInfoExcelReqDto));
                }
                //进行保存
                logger.info("客户批量导入 ---> 调用接口保存" + memberImportReqDto.getUrl());
                iCustomerService.saveAll(customerDetailReqDto1);
                List<AuthItemRuleReqDto> authItemRuleReqDtoList = Lists.newArrayList();
                AuthItemRuleReqDto authItemRuleReqDto = new AuthItemRuleReqDto();
                authItemRuleReqDto.setCustomerId(customerDetailReqDto1.getId());
                authItemRuleReqDto.setCustomerCode(customerDetailReqDto1.getCode());
                authItemRuleReqDto.setCustomerName(customerDetailReqDto1.getName());
                authItemRuleReqDto.setAuthType(0);
                authItemRuleReqDto.setOrganizationId(customerDetailReqDto1.getMerchantId());
                authItemRuleReqDto.setTenantId(customerDetailReqDto1.getTenantId());
                authItemRuleReqDto.setInstanceId(customerDetailReqDto1.getInstanceId());
                authItemRuleReqDtoList.add(authItemRuleReqDto);
                authItemRuleApi.initAuthItemRule(authItemRuleReqDtoList);

            } catch (Exception e) {
                customerInfoExcelReqDto.setReason(e.getMessage());
                dataValidateResult.getErrorCustomerInfoExcelList().add(customerInfoExcelReqDto);
            }
        });
        //导入数据校验的结果处理，可以上传OSS，也可以交由第三方处理，返回结果true,则继续该客户导入
        if (!dataValidateResultHandler.test(dataValidateResult)) {
            return;
        }

        logger.info("客户批量导入 ---> 结束客户导入业务");
    }


    private CustomerDetailReqDto getCustomerDetailReqDto(ImportEventReqDto memberImportReqDto, List<CustomerTypeRespDto> customerTypeEos, List<CustomerStatusRespDto> customerStatusRespDtoList, Map<String, String> regionCodeMap,
                                                         CustomerInfoExcelReqDto customerInfoExcelReqDto, List<UserDto> userDtoList,List<CustomerRespDto> customerRespList,Map<String, Long> levelIdMap) {
        CustomerDetailReqDto customerDetailReqDto1 = new CustomerDetailReqDto();
        BeanUtils.copyProperties(customerInfoExcelReqDto, customerDetailReqDto1);
        if (StringUtils.isNotEmpty(customerInfoExcelReqDto.getProvince())){
            customerDetailReqDto1.setProvinceCode(getAreaCode(customerInfoExcelReqDto.getProvince(), 0));//编码
            customerDetailReqDto1.setProvince(customerInfoExcelReqDto.getProvince());
        }
        if (StringUtils.isNotEmpty(customerInfoExcelReqDto.getCity())){
            customerDetailReqDto1.setCityCode(getAreaCode(customerInfoExcelReqDto.getCity(), 1));//编码
            customerDetailReqDto1.setCity(customerInfoExcelReqDto.getCity());
        }
        if (StringUtils.isNotEmpty(customerInfoExcelReqDto.getCounty())){
            customerDetailReqDto1.setCountyCode(getAreaCode(customerInfoExcelReqDto.getCounty(), 2));//编码
            customerDetailReqDto1.setCounty(customerInfoExcelReqDto.getCounty());
        }

//        if (customerInfoExcelReqDto.getParentCustomerCode() != null) {
//            CustomerDetailRespDto customerDetailRespDto = iCustomerService.queryByCode(customerInfoExcelReqDto.getParentCustomerCode());
//            customerDetailReqDto1.setParentCustomerId(customerDetailRespDto.getId());
//        }

        customerDetailReqDto1.setInstanceId(memberImportReqDto.getInstanceId());
        customerDetailReqDto1.setTenantId(memberImportReqDto.getTenantId());

        String[] split = customerInfoExcelReqDto.getRegion().split("/");
        List<String> regionCodeList = new ArrayList<>();
        List<String> regionNameList = new ArrayList<>();
        for (String regionName : split) {
            String regionCode = regionCodeMap.get(regionName);
            regionNameList.add(regionName);
            regionCodeList.add(regionCode);
        }
        //设置客户级别id
        if (StringUtils.isNotEmpty(customerInfoExcelReqDto.getCustomerLevel())){
            Long levelId = levelIdMap.get(customerInfoExcelReqDto.getCustomerLevel());
            customerDetailReqDto1.setLevelId(levelId);
        }

        customerDetailReqDto1.setRegionCodeList(regionCodeList);
        customerDetailReqDto1.setRegionNameList(regionNameList);
        for (CustomerRespDto customerRespDto : customerRespList) {
            if (customerRespDto.getName().equals(customerInfoExcelReqDto.getParentCustomer())) {
                customerDetailReqDto1.setParentCustomerId(customerRespDto.getId());
                break;
            }
        }
        for (CustomerStatusRespDto customerStatusRespDto : customerStatusRespDtoList) {
            if (customerStatusRespDto.getName().equals(customerInfoExcelReqDto.getAccountStatusName())) {
                customerDetailReqDto1.setStatusId(customerStatusRespDto.getId());
                break;
            }
        }
        for (CustomerTypeRespDto customerTypeEo : customerTypeEos) {
            if (customerTypeEo.getName().equals(customerInfoExcelReqDto.getCustomerType())) {
                customerDetailReqDto1.setCustomerTypeId(customerTypeEo.getId());
                break;
            }
        }
        for (UserDto userDto : userDtoList) {
            if (StringUtils.isNoneBlank(customerInfoExcelReqDto.getSalesmanNameMobile()) && customerInfoExcelReqDto.getSalesmanNameMobile().equals(userDto.getPhone())) {
                customerDetailReqDto1.setSalesmanId(userDto.getId());
                break;
            }
        }
        return customerDetailReqDto1;
    }

    /**
     * 构建地址对象
     *
     * @author sumo on 2020/10/15 0015
     */
    private AddressDto buildAddressDto(CustomerInfoExcelReqDto customerInfoExcelReqDto) {
        AddressDto addressDto = new AddressDto();
        BeanUtils.copyProperties(customerInfoExcelReqDto, addressDto);
        addressDto.setProvinceCode(getAreaCode(customerInfoExcelReqDto.getProvince(), 0));//编码
        addressDto.setCityCode(getAreaCode(customerInfoExcelReqDto.getCity(), 1));//编码
        addressDto.setDistrictCode(getAreaCode(customerInfoExcelReqDto.getCounty(), 2));//编码

        addressDto.setProvince(customerInfoExcelReqDto.getProvince());
        addressDto.setCity(customerInfoExcelReqDto.getCity());
        addressDto.setDistrict(customerInfoExcelReqDto.getCounty());
        addressDto.setStatus(1);
        if (StringUtils.isNotEmpty(customerInfoExcelReqDto.getAddressType())){
            addressDto.setAddressType(Arrays.stream(AddressTypeEnum.values()).sequential().filter(r->r.getDesc().equals(customerInfoExcelReqDto.getAddressType())).map(AddressTypeEnum::getCode).findFirst().orElse(AddressTypeEnum.DELIVERY.getCode()));
        }
        return addressDto;
    }

    private BillInfoDto buildBillInfoDto(CustomerInfoExcelReqDto customerInfoExcelReqDto) {
        BillInfoDto billInfoDto = new BillInfoDto();
        BeanUtils.copyProperties(customerInfoExcelReqDto, billInfoDto);
        billInfoDto.setCompanyName(customerInfoExcelReqDto.getAccountName());
        billInfoDto.setDepositBank(customerInfoExcelReqDto.getBranchAccountName());
        billInfoDto.setBankAccount(customerInfoExcelReqDto.getBranchAccountNum());
        billInfoDto.setInvoiceStatus(1);
        return billInfoDto;
    }

    private ContactsInfoDto buildContactsInfoDto(CustomerInfoExcelReqDto customerInfoExcelReqDto) {
        ContactsInfoDto contactsInfoDto = new ContactsInfoDto();
        BeanUtils.copyProperties(customerInfoExcelReqDto, contactsInfoDto);
        contactsInfoDto.setPhoneNum(customerInfoExcelReqDto.getMobile());
        contactsInfoDto.setLinkName(customerInfoExcelReqDto.getContactPerson());
//        contactsInfoDto.setUsername(customerInfoExcelReqDto.getName());
//        contactsInfoDto.setProvince(getAreaCode(customerInfoExcelReqDto.getProvince(), 0));//编码
//        contactsInfoDto.setCity(getAreaCode(customerInfoExcelReqDto.getCity(), 1));//编码
//        contactsInfoDto.setDistrict(getAreaCode(customerInfoExcelReqDto.getCounty(), 2));//编码
//
//        contactsInfoDto.setProvinceCode(customerInfoExcelReqDto.getProvince());
//        contactsInfoDto.setCityCode(customerInfoExcelReqDto.getCity());
//        contactsInfoDto.setDistrictCode(customerInfoExcelReqDto.getCounty());
        contactsInfoDto.setStatus(1);
        return contactsInfoDto;

    }

    private String getAreaCode(String name, Integer levelId) {
        AreaQueryReqDto queryReqDto = new AreaQueryReqDto();
        queryReqDto.setLevelId(levelId);
        queryReqDto.setName(name);
        List<AreaDto> areaDtos = areaQueryApi.queryByPage(queryReqDto).getData().getList();
        return !CollectionUtils.isEmpty(areaDtos) ? areaDtos.get(0).getCode() : null;
    }

    private void buildUserAccountReqDto(CustomerInfoExcelReqDto customerInfoExcelReqDto, CustomerDetailReqDto customerDetailReqDto1) {
        UserAccountReqDto userAccountReqDto = new UserAccountReqDto();
        BeanUtils.copyProperties(customerInfoExcelReqDto, userAccountReqDto);
        List<CustomerStatusRespDto> customerStatusRespDtoList = iCustomerStatusQueryApi.queryByList("").getData();
        for (CustomerStatusRespDto customerStatusRespDto : customerStatusRespDtoList) {
            if (customerStatusRespDto.getName().equals(customerInfoExcelReqDto.getAccountStatusName())) {
                userAccountReqDto.setStatusId(customerStatusRespDto.getId());
            }
        }

        customerDetailReqDto1.setUserAccountReqDto(userAccountReqDto);
    }

    /**
     * @param importEventReqDto
     * @param customerTypeEos           有效的客户类型
     * @param customerStatusRespDtoList 获取所有客户状态
     * @param regionNameList      获取所有区域
     * @param userDtoList               业务员
     * @return
     */
    @Override
    public CustomerImportDataValidateRespDto importDataVerify(ImportEventReqDto importEventReqDto, List<CustomerTypeRespDto> customerTypeEos, List<CustomerStatusRespDto> customerStatusRespDtoList,
                                                              List<String> regionNameList, List<UserDto> userDtoList,List<CustomerRespDto> customerRespList,List<CustomerLevelRespDto> levelList) {
        List<CustomerInfoExcelReqDto> memberInfoExcelReqDtoList = importEventReqDto.getCustomerInfoExcelReqList();
        //校验通不过的数据集合
        List<CustomerInfoExcelReqDto> errorCustomerList = Lists.newArrayList();


        for (CustomerInfoExcelReqDto customerInfoExcelReqDto : memberInfoExcelReqDtoList) {
            //必填参数校验
            if (StringUtils.isBlank(customerInfoExcelReqDto.getName())
                    || StringUtils.isBlank(customerInfoExcelReqDto.getCustomerType())
                    || StringUtils.isBlank(customerInfoExcelReqDto.getRegion())
                    || StringUtils.isBlank(customerInfoExcelReqDto.getContactPerson())
                    || StringUtils.isBlank(customerInfoExcelReqDto.getMobile())
                    || StringUtils.isBlank(customerInfoExcelReqDto.getUserName())
                    || StringUtils.isBlank(customerInfoExcelReqDto.getPassword())
                    || StringUtils.isBlank(customerInfoExcelReqDto.getAccountStatusName())
                    || StringUtils.isBlank(customerInfoExcelReqDto.getAccountName())
                    || StringUtils.isBlank(customerInfoExcelReqDto.getBranchAccountName())
                    || StringUtils.isBlank(customerInfoExcelReqDto.getBranchAccountNum())
                    || StringUtils.isBlank(customerInfoExcelReqDto.getTaxpayerId())
                    || StringUtils.isBlank(customerInfoExcelReqDto.getInvoiceTitle())) {
                customerInfoExcelReqDto.setReason("必填字段为空,请检查");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            //格式校验
            //校验客户类型
            boolean customerTypeIsExit = customerTypeEos.stream().anyMatch(customerTypeEo -> customerTypeEo.getName().equals(customerInfoExcelReqDto.getCustomerType()));
            if (!customerTypeIsExit) {
                //由于类型不对
                customerInfoExcelReqDto.setReason("由于客户类型不匹配,请检查");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            //校验归属区域
            List<String> needRegionList = Arrays.asList(customerInfoExcelReqDto.getRegion().split("/"));
            needRegionList.retainAll(regionNameList);
            if (CollectionUtils.isEmpty(needRegionList)){
                //由于区域不对
                customerInfoExcelReqDto.setReason("[客户区域]错误,请检查");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            customerInfoExcelReqDto.setRegion(StringUtils.join(needRegionList,"/"));
            //校验客户级别
            boolean levelIsExit = StringUtils.isNoneBlank(customerInfoExcelReqDto.getCustomerLevel()) && levelList.stream().noneMatch(level -> customerInfoExcelReqDto.getCustomerLevel().equals(level.getName()));
            if (levelIsExit) {
                //由于客户级别
                customerInfoExcelReqDto.setReason("[客户级别名称]不正确,请检查");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            //校验归属上级
            boolean parentIsExit = StringUtils.isNoneBlank(customerInfoExcelReqDto.getParentCustomer()) && customerRespList.stream().noneMatch(customer -> customerInfoExcelReqDto.getParentCustomer().equals(customer.getName()));
            if (parentIsExit) {
                //由于所属上级
                customerInfoExcelReqDto.setReason("[所属上级]错误,请检查");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            //校验行政地区-所属省名
            if (StringUtils.isNotBlank(customerInfoExcelReqDto.getProvince()) && !isExit(customerInfoExcelReqDto.getProvince(), 0)) {
                //由于所属省名
                customerInfoExcelReqDto.setReason("[所属省名]错误,请检查");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            //校验行政地区-所属市名
            if (StringUtils.isNotBlank(customerInfoExcelReqDto.getCity()) && !isExit(customerInfoExcelReqDto.getCity(), 1)) {
                //由于所属市名
                customerInfoExcelReqDto.setReason("[所属市名]错误,请检查");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            //校验行政地区-所属区名
            if (StringUtils.isNotBlank(customerInfoExcelReqDto.getCounty()) && !isExit(customerInfoExcelReqDto.getCounty(), 2)) {
                //由于所属区名
                customerInfoExcelReqDto.setReason("[所属区名]错误,请检查");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }

            //校验所属业务员-通过名称校验,后续可考虑通过手机号,避免名字重复(非必填项不做校验)
            if (StringUtils.isNoneBlank(customerInfoExcelReqDto.getSalesmanNameMobile()) && CollectionUtils.isEmpty(userDtoList)) {
                //由于所属业务员
                customerInfoExcelReqDto.setReason("系统找不到员工数据,无法验证业务员手机号,请尝试删除业务员手机号活新增员工");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            boolean userIsExit = StringUtils.isNoneBlank(customerInfoExcelReqDto.getSalesmanNameMobile()) && !userDtoList.stream().anyMatch(userDto -> customerInfoExcelReqDto.getSalesmanNameMobile().equals(userDto.getPhone()));
            if (userIsExit) {
                //由于所属业务员
                customerInfoExcelReqDto.setReason("[所属业务员手机]错误,请检查");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            //校验手机
            boolean mobileIsExit = validateMobilePhone(customerInfoExcelReqDto.getMobile());
            if (!mobileIsExit) {
                //由于手机
                customerInfoExcelReqDto.setReason("[手机]格式错误,请检查");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            //校验预留手机
            boolean reserveMobileIsExit = StringUtils.isNoneBlank(customerInfoExcelReqDto.getReserveMobile()) && !validateMobilePhone(customerInfoExcelReqDto.getReserveMobile());
            if (reserveMobileIsExit) {
                //由于预留手机
                customerInfoExcelReqDto.setReason("[预留手机]格式错误,请检查");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            //校验账号状态
            boolean statusIsExit = customerStatusRespDtoList.stream().anyMatch(customerStatusRespDto -> customerStatusRespDto.getName().equals(customerInfoExcelReqDto.getAccountStatusName()));
            if (!statusIsExit) {
                //由于账号状态
                customerInfoExcelReqDto.setReason("[账号状态]与系统不匹配,请检查");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }


        }

        CustomerImportDataValidateRespDto resultDto = new CustomerImportDataValidateRespDto();
        resultDto.setErrorCustomerInfoExcelList(errorCustomerList);
        memberInfoExcelReqDtoList.removeAll(errorCustomerList);//剔除所有不合格的数据
        resultDto.setCustomerInfoExcelList(memberInfoExcelReqDtoList);

        return resultDto;
    }


    private boolean isExit(String name, Integer levelId) {
        AreaQueryReqDto queryReqDto = new AreaQueryReqDto();
        queryReqDto.setLevelId(levelId);
        queryReqDto.setName(name);
        List<AreaDto> areaDtos = areaQueryApi.queryByPage(queryReqDto).getData().getList();
        return !CollectionUtils.isEmpty(areaDtos);
    }
}
