package com.dtyunxi.yundt.module.customer.biz.impl;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.IEmployeeRegionApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeRegionRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeRegionQueryApi;
import com.dtyunxi.yundt.module.customer.api.IEmployeeRegionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Author: xiuji
 * @Date: 2022/1/20 10:03 AM
 */
@Service
public class EmployeeRegionServiceImpl implements IEmployeeRegionService {

    @Autowired
    private IEmployeeRegionApi employeeRegionApi;
    @Autowired
    private IEmployeeRegionQueryApi employeeRegionQueryApi;


    /**
     * 查询人员所属区域
     *
     * @param queryReqDto
     * @return
     */
    @Override
    public RestResponse<List<EmployeeRegionRespDto>> queryEmployeeRegionList(EmployeeRegionQueryReqDto queryReqDto) {
        return employeeRegionQueryApi.queryEmployeeRegionList(queryReqDto);
    }

    /**
     * 根据区域编码查询区域信息
     *
     * @param codes
     * @return
     */
    @Override
    public RestResponse<List<CustomerAreaRespDto>> queryCustomerAreaByCodes(List<String> codes) {
        return employeeRegionQueryApi.queryCustomerAreaByCodes(codes);
    }
}
