/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.BaseExportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditEntityApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerExportType;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ExportRecordReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryTobApi;
import com.dtyunxi.yundt.cube.center.user.api.ICustomerOrgInfoApi;
import com.dtyunxi.yundt.cube.center.user.api.ICustomerUserApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BillInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ContactsInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.CustomerOrgInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.ICustomerOrgInfoQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.ICustomerUserQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerExtService;
import com.dtyunxi.yundt.module.customer.api.ICustomerService;
import com.dtyunxi.yundt.module.customer.api.dto.request.CustomerDetailReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.UserAccountReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerDetailAddRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerDetailRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerListRespDto;
import com.dtyunxi.yundt.module.customer.api.enums.SrcTypeEnum;
import com.dtyunxi.yundt.module.customer.api.exception.CustomerModuleExceptionCode;
import com.dtyunxi.yundt.module.customer.biz.mq.producer.CustomerChangeProducer;
import com.dtyunxi.yundt.module.customer.biz.vo.CustomerExportExtVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.customer.api.dto.request.CustomerSearchExtThreeReqDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="customerService")
public class CustomerServiceImpl
implements ICustomerService {
    private static Logger logger = LoggerFactory.getLogger(CustomerServiceImpl.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private ICustomerOrgInfoApi customerOrgInfoApi;
    @Resource
    private ICustomerApi customerApi;
    @Autowired
    private IUserApi userApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private ICustomerUserQueryApi customerUserQueryApi;
    @Resource
    private ICustomerUserApi customerUserApi;
    @Resource
    private ICustomerOrgInfoQueryApi customerOrgInfoQueryApi;
    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private OssRegistryVo ossRegistryVo;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IOrderQueryTobApi orderQueryTobApi;
    @Resource
    private CustomerChangeProducer customerChangeProducer;
    @Resource
    private ICreditEntityApi iCreditEntityApi;
    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private HttpServletRequest request;
    @Resource
    private ICustomerExtService customerExtService;
    @Resource
    private ExportService exportService;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;

    public String getHeaderOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    private void checkCustomerArea(CustomerDetailReqDto reqDto) {
        List regionCodeList = reqDto.getRegionCodeList();
        if (CollUtil.isEmpty((Collection)regionCodeList)) {
            return;
        }
        reqDto.setRegionCodeList(new HashSet(regionCodeList).stream().collect(Collectors.toList()));
        CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
        customerAreaListReqDto.setCodes(regionCodeList);
        customerAreaListReqDto.setOrgInfoId(reqDto.getOrgInfoId());
        RestResponse listRestResponse = this.customerAreaQueryApi.queryForList(customerAreaListReqDto);
        List customerAreaRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        if (CollUtil.isEmpty((Collection)customerAreaRespDtos) || customerAreaRespDtos.size() != regionCodeList.size()) {
            throw new BizException(CustomerModuleExceptionCode.REGION_NO_EXISTS.getCode(), CustomerModuleExceptionCode.REGION_NO_EXISTS.getMsg());
        }
        reqDto.setRegionNameList(customerAreaRespDtos.stream().map(CustomerAreaRespDto::getName).collect(Collectors.toList()));
    }

    public CustomerDetailAddRespDto add(CustomerDetailReqDto reqDto) {
        String cacheKey_customerType;
        CustomerTypeRespDto customerTypeRespDto;
        logger.info("\u5f00\u59cb\u521b\u5efa\u5ba2\u6237\u4fe1\u606f,CustomerDetailReqDto:{}", (Object)JSON.toJSONString((Object)reqDto));
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        reqDto.setInstanceId(instanceId);
        reqDto.setTenantId(tenantId);
        if (Objects.nonNull(reqDto.getCustomerTypeId()) && Objects.isNull(customerTypeRespDto = (CustomerTypeRespDto)this.cacheService.getCache(cacheKey_customerType = "customerTypeById_" + reqDto.getCustomerTypeId().toString(), CustomerTypeRespDto.class))) {
            RestResponse restResponse = this.customerTypeQueryApi.queryById(reqDto.getCustomerTypeId());
            customerTypeRespDto = (CustomerTypeRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
            if (Objects.isNull(customerTypeRespDto)) {
                throw new BizException(CustomerModuleExceptionCode.CUSTOMER_TYPE_NO_EXISTS.getCode(), CustomerModuleExceptionCode.CUSTOMER_TYPE_NO_EXISTS.getMsg());
            }
            this.cacheService.add(cacheKey_customerType, (Object)customerTypeRespDto, 10);
        }
        this.checkCustomerArea(reqDto);
        RestResponse restResponse = this.customerApi.add((CustomerReqDto)reqDto);
        Long customerId = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        CustomerOrgInfoDto orgInfoDto = this.createCustomerOrgInfo(reqDto);
        orgInfoDto.setId(customerId);
        reqDto.setId(customerId);
        orgInfoDto.setExtension("");
        logger.info("\u65b0\u589e\u5ba2\u6237\u7ec4\u7ec7\u4fe1\u606f...\uff0c\u5165\u53c2CustomerOrgInfoDto\uff1a{}", (Object)JSON.toJSONString((Object)orgInfoDto));
        this.customerChangeProducer.sendCustomerChangeMq(orgInfoDto);
        CustomerDetailAddRespDto respDto = new CustomerDetailAddRespDto();
        respDto.setId(customerId);
        respDto.setOrgInfoId(customerId);
        return respDto;
    }

    public CustomerDetailAddRespDto saveAll(CustomerDetailReqDto reqDto) {
        AddressDto addressDto;
        Object billInfoDtos;
        Object contactsInfoDto2;
        List contactsInfoDtos;
        UserAccountReqDto userAccountReqDto;
        logger.info("\u5f00\u59cb\u4fdd\u5b58\u5168\u90e8\u5ba2\u6237\u76f8\u5173\u4fe1\u606f,CustomerDetailReqDto:{}", (Object)JSON.toJSONString((Object)reqDto));
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        if (Objects.nonNull(reqDto.getUserAccountReqDto())) {
            ArrayList userFilters = Lists.newArrayList();
            userFilters.add(SqlFilter.eq((String)"userName", (Object)reqDto.getUserAccountReqDto().getUserName()));
            HashMap filterMap = Maps.newHashMap();
            filterMap.put("filters", userFilters);
            filterMap.put("instanceId", instanceId);
            String queryFilter = JSONObject.toJSONString((Object)filterMap);
            RestResponse pageInfoRestResponse = this.userQueryApi.queryByPage(queryFilter, Integer.valueOf(1), Integer.valueOf(1));
            PageInfo userDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
            if (Objects.nonNull(userDtoPageInfo)) {
                if (reqDto.getUserAccountReqDto().getUserId() == null && CollectionUtils.isNotEmpty((Collection)userDtoPageInfo.getList())) {
                    throw new BizException(CustomerModuleExceptionCode.USER_NAME_EXISTS.getCode(), CustomerModuleExceptionCode.USER_NAME_EXISTS.getMsg());
                }
                if (reqDto.getUserAccountReqDto().getUserId() != null && CollectionUtils.isNotEmpty((Collection)userDtoPageInfo.getList()) && !((UserDto)userDtoPageInfo.getList().get(0)).getId().equals(reqDto.getUserAccountReqDto().getUserId())) {
                    throw new BizException(CustomerModuleExceptionCode.USER_NAME_EXISTS.getCode(), CustomerModuleExceptionCode.USER_NAME_EXISTS.getMsg());
                }
            }
        }
        if (Objects.isNull(reqDto.getId())) {
            CustomerDetailAddRespDto addRespDto = this.add(reqDto);
            userAccountReqDto = reqDto.getUserAccountReqDto();
            if (Objects.nonNull(userAccountReqDto)) {
                userAccountReqDto.setOrgInfoId(addRespDto.getOrgInfoId());
                this.addCustomerAccount(userAccountReqDto);
            }
            if (CollectionUtils.isNotEmpty((Collection)(contactsInfoDtos = reqDto.getContactsInfoList()))) {
                for (Object contactsInfoDto2 : contactsInfoDtos) {
                    contactsInfoDto2.setOrgInfoId(addRespDto.getOrgInfoId());
                    contactsInfoDto2.setInstanceId(instanceId);
                    contactsInfoDto2.setTenantId(tenantId);
                    RestResponse addContactsRestResp = this.customerUserApi.addCustomerContactsInfo((ContactsInfoDto)contactsInfoDto2);
                    RestResponseHelper.extractData((RestResponse)addContactsRestResp);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(billInfoDtos = reqDto.getBillInfoList()))) {
                contactsInfoDto2 = billInfoDtos.iterator();
                while (contactsInfoDto2.hasNext()) {
                    BillInfoDto billInfoDto = (BillInfoDto)contactsInfoDto2.next();
                    billInfoDto.setOrgInfoId(addRespDto.getOrgInfoId());
                    billInfoDto.setInstanceId(instanceId);
                    billInfoDto.setTenantId(tenantId);
                    RestResponse addBillInfoRestResp = this.customerUserApi.addCustomerBillInfo(billInfoDto);
                    RestResponseHelper.extractData((RestResponse)addBillInfoRestResp);
                }
            }
            if (Objects.nonNull(addressDto = reqDto.getAddressDto())) {
                addressDto.setOrgInfoId(addRespDto.getOrgInfoId());
                addressDto.setInstanceId(instanceId);
                addressDto.setTenantId(tenantId);
                RestResponse addAddressRestResp = this.customerUserApi.addCustomerAddress(addressDto);
                RestResponseHelper.extractData((RestResponse)addAddressRestResp);
            }
            return addRespDto;
        }
        CustomerDetailAddRespDto updateRespDto = new CustomerDetailAddRespDto();
        updateRespDto.setOrgInfoId(reqDto.getOrgInfoId());
        updateRespDto.setId(reqDto.getId());
        this.update(reqDto);
        userAccountReqDto = reqDto.getUserAccountReqDto();
        if (Objects.nonNull(userAccountReqDto)) {
            userAccountReqDto.setOrgInfoId(updateRespDto.getOrgInfoId());
            if (Objects.isNull(userAccountReqDto.getUserId())) {
                this.addCustomerAccount(userAccountReqDto);
            } else {
                this.updateCustomerAccount(userAccountReqDto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(contactsInfoDtos = reqDto.getContactsInfoList()))) {
            billInfoDtos = contactsInfoDtos.iterator();
            while (billInfoDtos.hasNext()) {
                contactsInfoDto2 = (ContactsInfoDto)billInfoDtos.next();
                contactsInfoDto2.setOrgInfoId(updateRespDto.getOrgInfoId());
                contactsInfoDto2.setInstanceId(instanceId);
                contactsInfoDto2.setTenantId(tenantId);
                if (Objects.isNull(contactsInfoDto2.getId())) {
                    RestResponse addContactsRestResp = this.customerUserApi.addCustomerContactsInfo((ContactsInfoDto)contactsInfoDto2);
                    RestResponseHelper.extractData((RestResponse)addContactsRestResp);
                    continue;
                }
                RestResponse updateContactsRestResp = this.customerUserApi.updateCustomerContactsInfo((ContactsInfoDto)contactsInfoDto2);
                RestResponseHelper.extractData((RestResponse)updateContactsRestResp);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(billInfoDtos = reqDto.getBillInfoList()))) {
            contactsInfoDto2 = billInfoDtos.iterator();
            while (contactsInfoDto2.hasNext()) {
                BillInfoDto billInfoDto = (BillInfoDto)contactsInfoDto2.next();
                billInfoDto.setOrgInfoId(updateRespDto.getOrgInfoId());
                billInfoDto.setInstanceId(instanceId);
                billInfoDto.setTenantId(tenantId);
                if (Objects.isNull(billInfoDto.getId())) {
                    RestResponse addBillInfoRestResp = this.customerUserApi.addCustomerBillInfo(billInfoDto);
                    RestResponseHelper.extractData((RestResponse)addBillInfoRestResp);
                    continue;
                }
                RestResponse updateBillInfoRestResp = this.customerUserApi.updateCustomerBillInfo(billInfoDto);
                RestResponseHelper.extractData((RestResponse)updateBillInfoRestResp);
            }
        }
        if (Objects.nonNull(addressDto = reqDto.getAddressDto())) {
            addressDto.setOrgInfoId(updateRespDto.getOrgInfoId());
            addressDto.setInstanceId(instanceId);
            addressDto.setTenantId(tenantId);
            if (Objects.isNull(addressDto.getId())) {
                RestResponse addAddressRestResp = this.customerUserApi.addCustomerAddress(addressDto);
                RestResponseHelper.extractData((RestResponse)addAddressRestResp);
            } else {
                RestResponse updateAddressRestResp = this.customerUserApi.updateCustomerAddress(addressDto);
                RestResponseHelper.extractData((RestResponse)updateAddressRestResp);
            }
        }
        return updateRespDto;
    }

    public void update(CustomerDetailReqDto reqDto) {
        logger.info("\u5f00\u59cb\u4fee\u6539\u5ba2\u6237\u4fe1\u606f,CustomerDetailReqDto:{}", (Object)JSON.toJSONString((Object)reqDto));
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        reqDto.setInstanceId(instanceId);
        reqDto.setTenantId(tenantId);
        if (Objects.nonNull(reqDto.getCustomerTypeId())) {
            RestResponse restResponse = this.customerTypeQueryApi.queryById(reqDto.getCustomerTypeId());
            CustomerTypeRespDto customerTypeRespDto = (CustomerTypeRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        }
        this.checkCustomerArea(reqDto);
        CustomerOrgInfoDto orgInfoDto = this.createCustomerOrgInfo(reqDto);
        if (Objects.isNull(reqDto.getOrgInfoId())) {
            RestResponse customerRestResp = this.customerQueryApi.queryById(reqDto.getId());
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customerRestResp);
            reqDto.setOrgInfoId(customerRespDto.getOrgInfoId());
        }
        orgInfoDto.setId(reqDto.getOrgInfoId());
        orgInfoDto.setExtension("");
        logger.info("\u66f4\u65b0\u5ba2\u6237\u7ec4\u7ec7\u4fe1\u606f...\uff0c\u5165\u53c2CustomerOrgInfoDto\uff1a{}", (Object)JSON.toJSONString((Object)orgInfoDto));
        RestResponse restResponse = this.customerApi.update((CustomerReqDto)reqDto);
        RestResponseHelper.extractData((RestResponse)restResponse);
        this.customerChangeProducer.sendCustomerChangeMq(orgInfoDto);
    }

    public void addCustomerAccount(UserAccountReqDto userAccountReqDto) {
        logger.info("\u5f00\u59cb\u521b\u5efa\u5ba2\u6237\u8d26\u53f7\u4fe1\u606f,CustomerDetailReqDto:{}", (Object)JSON.toJSONString((Object)userAccountReqDto));
        UserDto userDto = new UserDto();
        BeanUtils.copyProperties((Object)userAccountReqDto, (Object)userDto);
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        userDto.setTenantId(tenantId);
        userDto.setInstanceId(instanceId);
        RestResponse longRestResponse = this.userApi.addUser(instanceId, userDto);
        Long userId = (Long)RestResponseHelper.extractData((RestResponse)longRestResponse);
        CustomerReqDto customerReqDto = new CustomerReqDto();
        BeanUtils.copyProperties((Object)userAccountReqDto, (Object)customerReqDto);
        customerReqDto.setUserId(userId);
        customerReqDto.setOrgInfoId(userAccountReqDto.getOrgInfoId());
        this.customerApi.updateAccountStatus(customerReqDto);
    }

    public void updateCustomerAccount(UserAccountReqDto userAccountReqDto) {
        logger.info("\u5f00\u59cb\u7f16\u8f91\u5ba2\u6237\u8d26\u53f7\u4fe1\u606f,CustomerDetailReqDto:{}", (Object)JSON.toJSONString((Object)userAccountReqDto));
        UserDto userDto = new UserDto();
        BeanUtils.copyProperties((Object)userAccountReqDto, (Object)userDto);
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        userDto.setTenantId(tenantId);
        userDto.setInstanceId(instanceId);
        RestResponse restResponse = this.userApi.updatePasswordPermitted(userAccountReqDto.getUserId(), userDto);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        CustomerReqDto customerReqDto = new CustomerReqDto();
        BeanUtils.copyProperties((Object)userAccountReqDto, (Object)customerReqDto);
        customerReqDto.setUserId(null);
        customerReqDto.setOrgInfoId(userAccountReqDto.getOrgInfoId());
        this.customerApi.updateAccountStatus(customerReqDto);
    }

    public PageInfo<CustomerListRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        String sellerorgid;
        String headerOrgId;
        RestResponse enableCustomerIds;
        CustomerSearchExtReqDto searchReqDto = new CustomerSearchExtReqDto();
        logger.info("queryByPage params:{}", (Object)filter);
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (CustomerSearchExtReqDto)JSONObject.parseObject((String)filter, CustomerSearchExtReqDto.class);
        }
        searchReqDto.setTenantId(this.context.tenantId());
        this.settingUserIdsForSearch((CustomerSearchReqDto)searchReqDto);
        if (Objects.nonNull(searchReqDto.getUserFlag()) && !searchReqDto.getUserFlag().booleanValue()) {
            return new PageInfo();
        }
        searchReqDto.setListFlag(Boolean.valueOf(true));
        if (SrcTypeEnum.SALESMAN.getCode().equals(searchReqDto.getSrcType())) {
            searchReqDto.setSalesmanUserId(this.context.userId());
            CustomerSearchExtReqDto searchExtReqDto = new CustomerSearchExtReqDto();
            CubeBeanUtils.copyProperties((Object)searchExtReqDto, (Object)searchReqDto, (String[])new String[0]);
            searchExtReqDto.setOrgInfoId(searchReqDto.getMerchantId());
            searchExtReqDto.setSalesmanId(this.context.userId());
            searchExtReqDto.setPageNum(pageNum);
            searchExtReqDto.setPageSize(pageSize);
            RestResponse pageInfoRestResponse = this.employeeCustomerQueryApi.queryValidCustomerPage(searchExtReqDto);
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
            ArrayList listRespDtoList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                List customerIds = (List)this.customerExtQueryApi.queryCustomerIdByOrgId(pageInfo.getList().stream().map(CustomerRespDto::getMerchantId).distinct().collect(Collectors.toList())).getData();
                List customerList = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)customerIds)) {
                    customerList = (List)this.customerExtQueryApi.queryListByCustomerIds(customerIds).getData();
                }
                logger.info("\u83b7\u53d6\u6240\u5c5e\u5546\u5bb6 customerIds = {}, customerList = {}", (Object)JSONObject.toJSONString((Object)customerIds), (Object)JSONObject.toJSONString((Object)customerList));
                List orgInfoIds = pageInfo.getList().stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
                List orgAndOrgInfoByIds = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryOrgAndOrgInfoByIds(orgInfoIds));
                logger.info("\u83b7\u53d6\u6240\u5c5eorgInfo orgInfoIds = {}, orgAndOrgInfoList = {}", (Object)JSONObject.toJSONString(orgInfoIds), (Object)JSONObject.toJSONString((Object)orgAndOrgInfoByIds));
                for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                    CustomerListRespDto listRespDto = new CustomerListRespDto();
                    CubeBeanUtils.copyProperties((Object)listRespDto, (Object)customerRespDto, (String[])new String[0]);
                    if (CollectionUtils.isNotEmpty((Collection)customerList)) {
                        for (CustomerRespDto customer2 : customerList) {
                            if (!Objects.equals(customerRespDto.getMerchantId(), customer2.getOrgInfoId())) continue;
                            listRespDto.setMerchantName(customer2.getName());
                            break;
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)orgAndOrgInfoByIds)) {
                        for (OrgAndOrgInfoRespDto orgAndOrgInfoRespDto : orgAndOrgInfoByIds) {
                            if (!Objects.equals(customerRespDto.getOrgInfoId(), orgAndOrgInfoRespDto.getOrganizationDto().getId())) continue;
                            listRespDto.setOrgName(orgAndOrgInfoRespDto.getOrganizationInfoDto().getOrgName());
                            break;
                        }
                    }
                    listRespDtoList.add(listRespDto);
                }
            }
            logger.info("\u4e1a\u52a1\u5458\u7aeflistRespDtoList>>>>{}", (Object)JSON.toJSONString((Object)listRespDtoList));
            PageInfo listRespDtoPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)listRespDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
            listRespDtoPageInfo.setList((List)listRespDtoList);
            return listRespDtoPageInfo;
        }
        if ("Y".equalsIgnoreCase(searchReqDto.getIsHaveCreditAccount())) {
            enableCustomerIds = this.iCreditEntityApi.getEnableCustomerIds("3");
            searchReqDto.setIdList((List)enableCustomerIds.getData());
        }
        if (Objects.equals(searchReqDto.getIsFilterCreditEntity(), "Y")) {
            enableCustomerIds = this.iCreditEntityApi.getEnableCustomerIds("3");
            searchReqDto.setIdNotInList((List)enableCustomerIds.getData());
            logger.info("[\u5ba2\u5546\u5ba2\u6237] >>> \u8fc7\u6ee4\u6389\u5df2\u4fe1\u7528\u51c6\u5165\u7684\u5ba2\u6237id:{}", (Object)searchReqDto.getIdNotInList());
        }
        searchReqDto.setIsFilterDownstreamCustomersByCurrentUser(Boolean.valueOf(true));
        CustomerSearchExtThreeReqDto customerSearchExtThreeReqDto = new CustomerSearchExtThreeReqDto();
        CubeBeanUtils.copyProperties((Object)customerSearchExtThreeReqDto, (Object)searchReqDto, (String[])new String[0]);
        if (searchReqDto.getType() != null && searchReqDto.getType() == 2 && StringUtils.isNotBlank((CharSequence)(headerOrgId = this.getHeaderOrgId()))) {
            customerSearchExtThreeReqDto.setMerchantIds(Collections.singletonList(Long.valueOf(headerOrgId)));
        }
        if (StringUtils.isNotEmpty((CharSequence)(sellerorgid = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.sellerorgid"))) && StringUtils.isNumeric((CharSequence)sellerorgid)) {
            customerSearchExtThreeReqDto.setOrganizationId(Long.valueOf(sellerorgid));
        }
        logger.info("\u5ba2\u6237\u5217\u8868\u67e5\u8be2 \u5165\u53c2 {}", (Object)JSON.toJSONString((Object)customerSearchExtThreeReqDto));
        RestResponse pageInfoRestResponse = this.customerExtThreeQueryApi.queryByPage(customerSearchExtThreeReqDto, pageNum, pageSize);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        PageInfo listRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)listRespDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList listRespDtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            JSONObject filterJson;
            for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                CustomerListRespDto listRespDto = new CustomerListRespDto();
                CubeBeanUtils.copyProperties((Object)listRespDto, (Object)customerRespDto, (String[])new String[0]);
                listRespDtoList.add(listRespDto);
            }
            Long skuId = null;
            if (StringUtils.isNotBlank((CharSequence)filter) && (filterJson = JSONObject.parseObject((String)filter)).containsKey((Object)"skuId")) {
                skuId = filterJson.getLong("skuId");
            }
            if (Objects.nonNull(skuId)) {
                logger.info("\u68c0\u67e5\u5ba2\u6237\u5bf9SKU[{}]\u7684\u6388\u6743\u72b6\u6001", skuId);
                List orgInfoIds = listRespDtoList.stream().map(BaseRespDto::getId).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(orgInfoIds)) {
                    ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
                    itemAuthReqDto.setTargetType(Integer.valueOf(1));
                    itemAuthReqDto.setTargetIdList(orgInfoIds);
                    itemAuthReqDto.setBusinessType("SKU");
                    itemAuthReqDto.setBusinessIdList((List)Lists.newArrayList((Object[])new Long[]{skuId}));
                    itemAuthReqDto.setStatus(Integer.valueOf(1));
                    RestResponse authResponse = this.itemAuthQueryApi.list(itemAuthReqDto);
                    List authList = (List)RestResponseHelper.extractData((RestResponse)authResponse);
                    if (CollectionUtils.isNotEmpty((Collection)authList)) {
                        Set authorizedOrgIds = authList.stream().map(auth -> auth.getTargetId()).collect(Collectors.toSet());
                        logger.info("\u5df2\u6388\u6743\u7684\u7ec4\u7ec7ID: {}", authorizedOrgIds);
                        for (CustomerListRespDto customer3 : listRespDtoList) {
                            customer3.setIsAuthorized(Boolean.valueOf(authorizedOrgIds.contains(customer3.getId())));
                        }
                    } else {
                        listRespDtoList.forEach(customer -> customer.setIsAuthorized(Boolean.valueOf(false)));
                    }
                }
            }
        }
        listRespDtoPageInfo.setList((List)listRespDtoList);
        return listRespDtoPageInfo;
    }

    private String getRegionName(List<String> regionCodeList, Long orgId) {
        CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
        customerAreaListReqDto.setCodes(regionCodeList);
        customerAreaListReqDto.setOrgInfoId(orgId);
        return ((List)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.queryForList(customerAreaListReqDto))).stream().map(CustomerAreaRespDto::getName).collect(Collectors.joining(","));
    }

    public List<Long> getCustomerIdsBySalesmanId(Long salesmanId) {
        List<Object> customerIds = Lists.newArrayList();
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        searchReqDto.setSalesmanId(salesmanId);
        searchReqDto.setTenantId(this.context.tenantId());
        RestResponse listRestResp = this.customerQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResp);
        if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
            customerIds = customerRespDtos.stream().map(BaseRespDto::getId).collect(Collectors.toList());
        }
        return customerIds;
    }

    private void settingUserIdsForSearch(CustomerSearchReqDto searchReqDto) {
        if (StringUtils.isNotEmpty((CharSequence)searchReqDto.getUserName())) {
            ArrayList userFilters = Lists.newArrayList();
            userFilters.add(SqlFilter.like((String)"userName", (Object)("%" + searchReqDto.getUserName() + "%")));
            HashMap filterMap = Maps.newHashMap();
            filterMap.put("filters", userFilters);
            filterMap.put("tenantId", searchReqDto.getTenantId());
            filterMap.put("instanceId", searchReqDto.getInstanceId());
            String queryFilter = JSONObject.toJSONString((Object)filterMap);
            RestResponse pageInfoRestResponse = this.userQueryApi.queryByPage(queryFilter, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
            PageInfo userDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
            ArrayList userIdList = Lists.newArrayList();
            if (Objects.nonNull(userDtoPageInfo) && CollectionUtils.isNotEmpty((Collection)userDtoPageInfo.getList())) {
                for (UserDto userDto : userDtoPageInfo.getList()) {
                    userIdList.add(userDto.getId());
                }
            }
            if (CollectionUtils.isEmpty((Collection)userIdList)) {
                searchReqDto.setUserFlag(Boolean.valueOf(false));
            }
            searchReqDto.setUserIds((List)userIdList);
        }
    }

    public CustomerDetailRespDto queryById(Long id) {
        RestResponse billInfoRestResp;
        List billInfoDtos;
        RestResponse contactsInfoRestResp;
        List contactsInfoDtos;
        RestResponse userRestResp;
        UserDto userDto;
        RestResponse salesmanRestResp;
        UserDto salesman;
        CustomerDetailRespDto customerDetailRespDto = new CustomerDetailRespDto();
        RestResponse customerRestResp = this.customerQueryApi.queryById(id);
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customerRestResp);
        BeanUtils.copyProperties((Object)customerRespDto, (Object)customerDetailRespDto);
        RestResponse orgInfoRestResp = this.customerOrgInfoQueryApi.queryById(customerRespDto.getOrgInfoId());
        CustomerOrgInfoDto orgInfoDto = (CustomerOrgInfoDto)RestResponseHelper.extractData((RestResponse)orgInfoRestResp);
        if (orgInfoDto != null) {
            customerDetailRespDto.setBussinessLicenseUrl(orgInfoDto.getBussinessLicenseUrl());
        }
        if (Objects.nonNull(customerRespDto.getSalesmanId()) && Objects.nonNull(salesman = (UserDto)RestResponseHelper.extractData((RestResponse)(salesmanRestResp = this.userQueryApi.queryById(customerRespDto.getSalesmanId(), "{}"))))) {
            customerDetailRespDto.setSalesmanName(salesman.getNickName());
        }
        if (Objects.nonNull(customerRespDto.getUserId()) && Objects.nonNull(userDto = (UserDto)RestResponseHelper.extractData((RestResponse)(userRestResp = this.userQueryApi.queryById(customerRespDto.getUserId(), "{}"))))) {
            customerDetailRespDto.setUserName(userDto.getUserName());
        }
        HashMap regionNameMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)customerRespDto.getRegionCodeList())) {
            customerDetailRespDto.setRegionNameList(Arrays.asList(this.getRegionName(customerRespDto.getRegionCodeList(), customerRespDto.getOrgInfoId()).split(",")));
        }
        if (CollectionUtils.isNotEmpty((Collection)(contactsInfoDtos = (List)RestResponseHelper.extractData((RestResponse)(contactsInfoRestResp = this.customerUserQueryApi.queryContactsInfoListByOrgInfoId(customerRespDto.getOrgInfoId())))))) {
            customerDetailRespDto.setContactsInfoList(contactsInfoDtos);
        }
        if (CollectionUtils.isNotEmpty((Collection)(billInfoDtos = (List)RestResponseHelper.extractData((RestResponse)(billInfoRestResp = this.customerUserQueryApi.queryBillInfoListByOrgInfoId(customerRespDto.getOrgInfoId())))))) {
            customerDetailRespDto.setBillInfoList(billInfoDtos);
        }
        RestResponse addressRestResp = this.customerUserQueryApi.queryAddressListByOrgInfoId(customerRespDto.getOrgInfoId());
        List addressDtos = (List)RestResponseHelper.extractData((RestResponse)addressRestResp);
        customerDetailRespDto.setAddressDtoList(addressDtos);
        return customerDetailRespDto;
    }

    public CustomerDetailRespDto queryByCode(String code) {
        CustomerDetailRespDto customerDetailRespDto = new CustomerDetailRespDto();
        RestResponse customerRespDtoRestResponse = this.customerQueryApi.queryByCode(code);
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customerRespDtoRestResponse);
        BeanUtils.copyProperties((Object)customerRespDto, (Object)customerDetailRespDto);
        return customerDetailRespDto;
    }

    public Boolean isExistByRegionCode(String regionCode) {
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        ArrayList regionCodes = Lists.newArrayList((Object[])new String[]{regionCode});
        searchReqDto.setRegionCodes((List)regionCodes);
        searchReqDto.setTenantId(this.context.tenantId());
        RestResponse pageInfoRestResponse = this.customerQueryApi.queryByPage(JSON.toJSONString((Object)searchReqDto), Integer.valueOf(1), Integer.valueOf(10));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        return Objects.nonNull(pageInfo) && CollectionUtils.isNotEmpty((Collection)pageInfo.getList());
    }

    public void moveCustomerToRegion(String sourceRegionCode, String targetRegionCode) {
        RestResponse restResponse = this.customerApi.moveCustomerToRegion(sourceRegionCode, targetRegionCode);
        RestResponseHelper.extractData((RestResponse)restResponse);
    }

    public String exportCustomer(CustomerSearchReqDto customerSearchReqDto) {
        String operator = this.context.userName();
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        customerSearchReqDto.setTenantId(tenantId);
        String fileName = "\u5ba2\u6237\u6570\u636e_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + new Random().nextInt(100) + ".xls";
        ExecutorUtils.execute(() -> {
            this.settingUserIdsForSearch(customerSearchReqDto);
            List<CustomerRespDto> list = Objects.nonNull(customerSearchReqDto.getUserFlag()) && customerSearchReqDto.getUserFlag() == false ? new ArrayList<CustomerRespDto>() : this.queryByList(JSON.toJSONString((Object)customerSearchReqDto));
            List<CustomerDetailRespDto> detailList = this.queryCustomerDetailByList(tenantId, instanceId, list);
            long startTime1 = new Date().getTime();
            int exportNum = list.size();
            String data = new String(new byte[]{-17, -69, -65}) + this.processData(detailList);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data.getBytes());
            logger.info("Excel\u6587\u4ef6\uff1a{}\u5f00\u59cb\u4e0a\u4f20\u5230oss\u670d\u52a1\u5668...", (Object)(this.ossRegistryVo.getEndpoint() + "/" + fileName));
            try {
                this.objectStorageService.put(this.ossRegistryVo.getBucketName(), fileName, (InputStream)inputStream);
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa\u5ba2\u6237\u4e0a\u4f20oss\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
                throw new BizException(CustomerModuleExceptionCode.CUSTOMER_UPLOAD_OSS_ERROR.getCode(), CustomerModuleExceptionCode.CUSTOMER_UPLOAD_OSS_ERROR.getMsg());
            }
            finally {
                try {
                    long startTime2 = new Date().getTime();
                    logger.info("Excel\u6587\u4ef6\u8fdb\u884c\u6574\u7406\u5b8c\u6bd5,\u82b1\u8d39[{}]\u8c6a\u79d2", (Object)(startTime2 - startTime1));
                    inputStream.close();
                }
                catch (Exception e) {
                    logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38");
                }
            }
            logger.info("Excel\u4e0a\u4f20\u5230oss\u670d\u52a1\u5668\u5b8c\u6bd5,\u4e0b\u8f7d\u94fe\u63a5\uff1a{},\u5bfc\u51fa\u5165\u53c2\uff1a{}", (Object)(this.ossRegistryVo.getEndpoint() + "/" + fileName), (Object)JSON.toJSONString((Object)customerSearchReqDto));
            this.saveExportRecord(operator, CustomerExportType.CUSTOMER_LIST, fileName, exportNum, this.ossRegistryVo.getEndpoint() + "/" + fileName);
        });
        String downloadUrl = this.objectStorageService.getFileUrl(fileName);
        return downloadUrl;
    }

    public String exportCustomerExt(String filter) {
        logger.info("\u5ba2\u6237\u5bfc\u51faEXT\uff1a{}", (Object)JSON.toJSONString((Object)filter));
        String name = "\u5ba2\u6237\u6570\u636e_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + new Random().nextInt(100);
        BaseExportService baseExportService = new BaseExportService(name, ExportTypeEnum.CUSTOMER);
        baseExportService.executor(req -> {
            PageInfo pageInfo = this.customerExtService.queryByPage(req, Integer.valueOf(1), Integer.valueOf(100000));
            if (ObjectUtil.isNotEmpty((Object)pageInfo) && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                ArrayList exportExtVoList = new ArrayList();
                pageInfo.getList().forEach(info -> {
                    CustomerExportExtVo exportExtVo = (CustomerExportExtVo)BeanUtil.copyProperties((Object)info, CustomerExportExtVo.class, (String[])new String[0]);
                    exportExtVoList.add(exportExtVo);
                });
                baseExportService.exportUrl(exportExtVoList, CustomerExportExtVo.class);
            } else {
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + name + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            }
            return null;
        }, (Object)filter);
        return "\u5bfc\u51fa" + name + "\u6210\u529f";
    }

    private void saveExportRecord(String operator, CustomerExportType type, String fileName, int num, String downloadUrl) {
        ExportRecordReqDto exportRecordReqDto = new ExportRecordReqDto();
        exportRecordReqDto.setNum(Integer.valueOf(num));
        exportRecordReqDto.setFileName(fileName);
        exportRecordReqDto.setUrl(downloadUrl);
        exportRecordReqDto.setType(Integer.valueOf(type.getCode()));
        exportRecordReqDto.setCreatePerson(operator);
        this.customerApi.saveCustomerExportRecord(exportRecordReqDto);
    }

    private List<CustomerDetailRespDto> queryCustomerDetailByList(Long tenantId, Long instanceId, List<CustomerRespDto> customerRespList) {
        ArrayList detailRespList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(customerRespList)) {
            return detailRespList;
        }
        ArrayList orgInfoIdList = Lists.newArrayList();
        HashSet userIds = Sets.newHashSet();
        HashSet regionCodes = Sets.newHashSet();
        HashSet parentCustomerIds = Sets.newHashSet();
        for (CustomerRespDto customerRespDto : customerRespList) {
            orgInfoIdList.add(customerRespDto.getOrgInfoId());
            if (Objects.nonNull(customerRespDto.getUserId())) {
                userIds.add(customerRespDto.getUserId());
            }
            if (StringUtils.isNotEmpty((CharSequence)customerRespDto.getRegionCodes())) {
                List<String> regionList = Arrays.asList(customerRespDto.getRegionCodes().split(","));
                regionCodes.addAll(regionList);
            }
            if (Objects.nonNull(customerRespDto.getSalesmanId())) {
                userIds.add(customerRespDto.getSalesmanId());
            }
            if (!Objects.nonNull(customerRespDto.getParentCustomerId())) continue;
            parentCustomerIds.add(customerRespDto.getParentCustomerId());
        }
        Map<Object, Object> userMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            RestResponse salesmanRestResp = this.employeeExpandQueryApi.queryByIdList(new ArrayList(userIds));
            List userList = (List)RestResponseHelper.extractData((RestResponse)salesmanRestResp);
            userMap = userList.stream().collect(Collectors.toMap(UserDto::getId, e -> e));
        }
        HashMap regionNameMap = new HashMap();
        ArrayList newRegionCodes = new ArrayList(regionCodes);
        ArrayList newRegionCodes2 = new ArrayList();
        newRegionCodes2.add(newRegionCodes.get(1));
        newRegionCodes2.add(newRegionCodes.get(0));
        Map<Object, Object> parentCustomerMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)parentCustomerIds)) {
            RestResponse listRestResponse = this.customerQueryApi.queryListByIds((List)Lists.newArrayList((Iterable)parentCustomerIds));
            List nameList = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
            parentCustomerMap = nameList.stream().collect(Collectors.toMap(CustomerNameSimpleRespDto::getId, CustomerNameSimpleRespDto::getName));
        }
        RestResponse contactsInfoRestResp = this.customerUserQueryApi.queryContactsInfoListByOrgInfoIdList((List)orgInfoIdList);
        List contactsInfoDtos = (List)RestResponseHelper.extractData((RestResponse)contactsInfoRestResp);
        Map<Long, List<ContactsInfoDto>> contactsInfoMap = contactsInfoDtos.stream().collect(Collectors.groupingBy(ContactsInfoDto::getOrgInfoId));
        RestResponse billInfoRestResp = this.customerUserQueryApi.queryBillInfoListByOrgInfoIdList((List)orgInfoIdList);
        List billInfoDtos = (List)RestResponseHelper.extractData((RestResponse)billInfoRestResp);
        Map<Long, List<BillInfoDto>> billInfoMap = billInfoDtos.stream().collect(Collectors.groupingBy(BillInfoDto::getOrgInfoId));
        for (CustomerRespDto customerRespDto : customerRespList) {
            CustomerDetailRespDto newCustomerDetailDto;
            int i;
            UserDto userDto;
            UserDto salesman;
            CustomerDetailRespDto customerDetailRespDto = new CustomerDetailRespDto();
            BeanUtils.copyProperties((Object)customerRespDto, (Object)customerDetailRespDto);
            if (Objects.nonNull(customerRespDto.getSalesmanId()) && Objects.nonNull(salesman = (UserDto)userMap.get(customerRespDto.getSalesmanId()))) {
                customerDetailRespDto.setSalesmanName(salesman.getNickName());
            }
            if (Objects.nonNull(customerRespDto.getUserId()) && Objects.nonNull(userDto = (UserDto)userMap.get(customerRespDto.getUserId()))) {
                customerDetailRespDto.setUserName(userDto.getUserName());
            }
            if (StringUtils.isNotEmpty((CharSequence)customerRespDto.getRegionCodes())) {
                customerDetailRespDto.setRegion(this.getRegionName(customerRespDto.getRegionCodeList(), customerRespDto.getOrgInfoId()));
            }
            if (Objects.nonNull(customerRespDto.getParentCustomerId())) {
                String customerName = (String)parentCustomerMap.get(customerRespDto.getParentCustomerId());
                customerDetailRespDto.setParentCustomerName(customerName);
            }
            List<ContactsInfoDto> contactsInfoList = contactsInfoMap.get(customerRespDto.getOrgInfoId());
            List<BillInfoDto> billInfoList = billInfoMap.get(customerRespDto.getOrgInfoId());
            if (CollectionUtils.isEmpty(contactsInfoList) && CollectionUtils.isEmpty(billInfoList)) {
                detailRespList.add(customerDetailRespDto);
                continue;
            }
            if (CollectionUtils.isNotEmpty(contactsInfoList)) {
                if (CollectionUtils.isNotEmpty(billInfoList)) {
                    if (contactsInfoList.size() > billInfoList.size()) {
                        for (i = 0; i < contactsInfoList.size(); ++i) {
                            newCustomerDetailDto = new CustomerDetailRespDto();
                            BeanUtils.copyProperties((Object)customerDetailRespDto, (Object)newCustomerDetailDto);
                            newCustomerDetailDto.setContactsInfoDto(contactsInfoList.get(i));
                            if (i < billInfoList.size()) {
                                newCustomerDetailDto.setBillInfoDto(billInfoList.get(i));
                            }
                            detailRespList.add(newCustomerDetailDto);
                        }
                        continue;
                    }
                    for (i = 0; i < billInfoList.size(); ++i) {
                        newCustomerDetailDto = new CustomerDetailRespDto();
                        BeanUtils.copyProperties((Object)customerDetailRespDto, (Object)newCustomerDetailDto);
                        newCustomerDetailDto.setBillInfoDto(billInfoList.get(i));
                        if (i < contactsInfoList.size()) {
                            newCustomerDetailDto.setContactsInfoDto(contactsInfoList.get(i));
                        }
                        detailRespList.add(newCustomerDetailDto);
                    }
                    continue;
                }
                for (i = 0; i < contactsInfoList.size(); ++i) {
                    newCustomerDetailDto = new CustomerDetailRespDto();
                    BeanUtils.copyProperties((Object)customerDetailRespDto, (Object)newCustomerDetailDto);
                    newCustomerDetailDto.setContactsInfoDto(contactsInfoList.get(i));
                    detailRespList.add(newCustomerDetailDto);
                }
                continue;
            }
            for (i = 0; i < billInfoList.size(); ++i) {
                newCustomerDetailDto = new CustomerDetailRespDto();
                BeanUtils.copyProperties((Object)customerDetailRespDto, (Object)newCustomerDetailDto);
                newCustomerDetailDto.setBillInfoDto(billInfoList.get(i));
                detailRespList.add(newCustomerDetailDto);
            }
        }
        return detailRespList;
    }

    public List<CustomerRespDto> queryByList(String filter) {
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (CustomerSearchReqDto)JSONObject.parseObject((String)filter, CustomerSearchReqDto.class);
        }
        if (Objects.isNull(searchReqDto.getTenantId())) {
            searchReqDto.setTenantId(this.context.tenantId());
        }
        RestResponse listRestResponse = this.customerQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto));
        List customerRespList = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        return customerRespList;
    }

    public Boolean checkExportCustomer(String fileName) {
        boolean exists = this.objectStorageService.exists(this.ossRegistryVo.getBucketName(), fileName);
        return exists;
    }

    public PageInfo<AddressDto> queryAddressByPage(String keyword, String addressType, Long customerId, Integer pageNum, Integer pageSize) {
        RestResponse customerRestResp;
        CustomerRespDto customerRespDto;
        if (StringUtils.isEmpty((CharSequence)addressType)) {
            addressType = "1";
        }
        if (Objects.isNull(customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)(customerRestResp = this.customerQueryApi.queryById(customerId))))) {
            return new PageInfo((List)Lists.newArrayList());
        }
        RestResponse listRestResponse = this.customerUserQueryApi.queryAddressListByOrgInfoId(customerRespDto.getOrgInfoId());
        List addressDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        if (CollectionUtils.isEmpty((Collection)addressDtos)) {
            return new PageInfo((List)Lists.newArrayList());
        }
        String finalAddressType = addressType;
        List addressDtosTemp = addressDtos.stream().filter(address -> address.getAddressType().equals(finalAddressType)).collect(Collectors.toList());
        ArrayList<Object> newAddressDtos = new ArrayList<Object>();
        if (StringUtils.isEmpty((CharSequence)keyword)) {
            newAddressDtos.addAll(addressDtosTemp);
        } else {
            for (AddressDto addressDto : addressDtosTemp) {
                String contact = addressDto.getContact();
                String phone = addressDto.getPhone();
                if (!contact.contains(keyword) && !phone.contains(keyword)) continue;
                newAddressDtos.add(addressDto);
            }
        }
        int startPage = (pageNum - 1) * pageSize + 1;
        ArrayList respDtoList = new ArrayList(pageSize);
        for (int i = startPage; i <= pageNum * pageSize; ++i) {
            if (newAddressDtos.size() < i || i - 1 < 0) continue;
            respDtoList.add(newAddressDtos.get(i - 1));
        }
        PageInfo pageInfo = new PageInfo();
        pageInfo.setList(respDtoList);
        pageInfo.setTotal((long)newAddressDtos.size());
        pageInfo.setPageSize(pageSize.intValue());
        pageInfo.setPageNum(pageNum.intValue());
        return pageInfo;
    }

    public AddressDto queryDefaultAddress(String addressType, Long customerId) {
        RestResponse customerRestResp;
        CustomerRespDto customerRespDto;
        if (StringUtils.isEmpty((CharSequence)addressType)) {
            addressType = "1";
        }
        if (Objects.isNull(customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)(customerRestResp = this.customerQueryApi.queryById(customerId))))) {
            return null;
        }
        RestResponse listRestResponse = this.customerUserQueryApi.queryAddressListByOrgInfoId(customerRespDto.getOrgInfoId());
        List addressDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        if (CollectionUtils.isEmpty((Collection)addressDtos)) {
            return null;
        }
        for (AddressDto addressDto : addressDtos) {
            if (!addressType.equals(addressDto.getAddressType()) || addressDto.getStatus() != 1) continue;
            return addressDto;
        }
        return null;
    }

    private String processData(List<CustomerDetailRespDto> list) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u5ba2\u6237\u540d\u79f0,\u5ba2\u6237\u7c7b\u578b,\u5ba2\u6237\u7f16\u53f7,\u5ba2\u6237\u533a\u57df,\u5ba2\u6237\u7ea7\u522b,\u6240\u5c5e\u4e0a\u7ea7,\u6240\u5c5e\u7701,\u6240\u5c5e\u5e02,\u6240\u5c5e\u533a,\u8be6\u7ec6\u5730\u5740,\u6240\u5c5e\u4e1a\u52a1\u5458,\u5907\u6ce8,\u8054\u7cfb\u4eba,\u804c\u4f4d,\u624b\u673a,\u7535\u8bdd,\u90ae\u7bb1,\u9884\u7559\u624b\u673a,\u767b\u5f55\u8d26\u53f7,\u767b\u5f55\u5bc6\u7801,\u8d26\u53f7\u72b6\u6001,\u5f00\u6237\u540d\u79f0,\u5f00\u6237\u94f6\u884c,\u94f6\u884c\u8d26\u53f7,\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7,\u5f00\u7968\u62ac\u5934,\u53d1\u7968\u5185\u5bb9,\u652f\u4ed8\u5b9d\u53f7,\u5fae\u4fe1\u53f7\n");
        Iterator<CustomerDetailRespDto> iterator = list.iterator();
        while (iterator.hasNext()) {
            CustomerDetailRespDto customerDetailRespDto = iterator.next();
            String name = StringUtils.isNotBlank((CharSequence)customerDetailRespDto.getName()) ? customerDetailRespDto.getName() : "";
            String customerTypeName = StringUtils.isNotBlank((CharSequence)customerDetailRespDto.getCustomerTypeName()) ? customerDetailRespDto.getCustomerTypeName() : "";
            String code = StringUtils.isNotBlank((CharSequence)customerDetailRespDto.getCode()) ? customerDetailRespDto.getCode() : "";
            String region = StringUtils.isNotBlank((CharSequence)customerDetailRespDto.getRegion()) ? customerDetailRespDto.getRegion() : "";
            String levelName = StringUtils.isNotBlank((CharSequence)customerDetailRespDto.getLevelName()) ? customerDetailRespDto.getLevelName() : "";
            String parentCustomerName = StringUtils.isNotBlank((CharSequence)customerDetailRespDto.getParentCustomerName()) ? customerDetailRespDto.getParentCustomerName() : "";
            String province = StringUtils.isNotBlank((CharSequence)customerDetailRespDto.getProvince()) ? customerDetailRespDto.getProvince() : "";
            String city = StringUtils.isNotBlank((CharSequence)customerDetailRespDto.getCity()) ? customerDetailRespDto.getCity() : "";
            String county = StringUtils.isNotBlank((CharSequence)customerDetailRespDto.getCounty()) ? customerDetailRespDto.getCounty() : "";
            String address = StringUtils.isNotBlank((CharSequence)customerDetailRespDto.getAddress()) ? customerDetailRespDto.getAddress() : "";
            String salesmanName = StringUtils.isNotBlank((CharSequence)customerDetailRespDto.getSalesmanName()) ? customerDetailRespDto.getSalesmanName() : "";
            String remark = StringUtils.isNotBlank((CharSequence)customerDetailRespDto.getRemark()) ? customerDetailRespDto.getRemark() : "";
            ContactsInfoDto contactsInfoDto = customerDetailRespDto.getContactsInfoDto();
            String linkName = "";
            String position = "";
            String phoneNum = "";
            String tel = "";
            String postcode = "";
            String reserveMobile = "";
            if (Objects.nonNull(contactsInfoDto)) {
                linkName = StringUtils.isNotBlank((CharSequence)contactsInfoDto.getLinkName()) ? contactsInfoDto.getLinkName() : "";
                position = StringUtils.isNotBlank((CharSequence)contactsInfoDto.getPosition()) ? contactsInfoDto.getPosition() : "";
                phoneNum = StringUtils.isNotBlank((CharSequence)contactsInfoDto.getPhoneNum()) ? contactsInfoDto.getPhoneNum() : "";
                tel = StringUtils.isNotBlank((CharSequence)contactsInfoDto.getTel()) ? contactsInfoDto.getTel() : "";
                postcode = StringUtils.isNotBlank((CharSequence)contactsInfoDto.getPostcode()) ? contactsInfoDto.getPostcode() : "";
                reserveMobile = StringUtils.isNotBlank((CharSequence)contactsInfoDto.getReserveMobile()) ? contactsInfoDto.getReserveMobile() : "";
            }
            String userName = StringUtils.isNotBlank((CharSequence)customerDetailRespDto.getUserName()) ? customerDetailRespDto.getUserName() : "";
            String password = "";
            String statusName = StringUtils.isNotBlank((CharSequence)customerDetailRespDto.getStatusName()) ? customerDetailRespDto.getStatusName() : "";
            BillInfoDto billInfoDto = customerDetailRespDto.getBillInfoDto();
            String companyName = "";
            String depositBank = "";
            String bankAccount = "";
            String dutyNum = "";
            String invoiceTitle = "";
            String invoiceContent = "";
            String alipayNumber = "";
            String wechatNumber = "";
            if (Objects.nonNull(billInfoDto)) {
                companyName = StringUtils.isNotBlank((CharSequence)billInfoDto.getCompanyName()) ? billInfoDto.getCompanyName() : "";
                depositBank = StringUtils.isNotBlank((CharSequence)billInfoDto.getDepositBank()) ? billInfoDto.getDepositBank() : "";
                bankAccount = StringUtils.isNotBlank((CharSequence)billInfoDto.getBankAccount()) ? billInfoDto.getBankAccount() : "";
                dutyNum = StringUtils.isNotBlank((CharSequence)billInfoDto.getDutyNum()) ? billInfoDto.getDutyNum() : "";
                invoiceTitle = StringUtils.isNotBlank((CharSequence)billInfoDto.getInvoiceTitle()) ? billInfoDto.getInvoiceTitle() : "";
                invoiceContent = StringUtils.isNotBlank((CharSequence)billInfoDto.getInvoiceContent()) ? billInfoDto.getInvoiceContent() : "";
                alipayNumber = StringUtils.isNotBlank((CharSequence)billInfoDto.getAlipayNumber()) ? billInfoDto.getAlipayNumber() : "";
                wechatNumber = StringUtils.isNotBlank((CharSequence)billInfoDto.getWechatNumber()) ? billInfoDto.getWechatNumber() : "";
            }
            sb.append("\t").append(name).append(",");
            sb.append("\t").append(customerTypeName).append(",");
            sb.append("\t").append(code).append(",");
            sb.append("\t").append(region).append(",");
            sb.append("\t").append(levelName).append(",");
            sb.append("\t").append(parentCustomerName).append(",");
            sb.append("\t").append(province).append(",");
            sb.append("\t").append(city).append(",");
            sb.append("\t").append(county).append(",");
            sb.append("\t").append(address).append(",");
            sb.append("\t").append(salesmanName).append(",");
            sb.append("\t").append(remark).append(",");
            sb.append("\t").append(linkName).append(",");
            sb.append("\t").append(position).append(",");
            sb.append("\t").append(phoneNum).append(",");
            sb.append("\t").append(tel).append(",");
            sb.append("\t").append(postcode).append(",");
            sb.append("\t").append(reserveMobile).append(",");
            sb.append("\t").append(userName).append(",");
            sb.append("\t").append(password).append(",");
            sb.append("\t").append(statusName).append(",");
            sb.append("\t").append(companyName).append(",");
            sb.append("\t").append(depositBank).append(",");
            sb.append("\t").append(bankAccount).append(",");
            sb.append("\t").append(dutyNum).append(",");
            sb.append("\t").append(invoiceTitle).append(",");
            sb.append("\t").append(invoiceContent).append(",");
            sb.append("\t").append(alipayNumber).append(",");
            sb.append("\t").append(wechatNumber).append("\r\n");
            iterator.remove();
        }
        return sb.toString();
    }

    private CustomerOrgInfoDto createCustomerOrgInfo(CustomerDetailReqDto reqDto) {
        CustomerOrgInfoDto orgInfoDto = new CustomerOrgInfoDto();
        CubeBeanUtils.copyProperties((Object)orgInfoDto, (Object)reqDto, (String[])new String[]{"id"});
        orgInfoDto.setOrgCode(reqDto.getCode());
        orgInfoDto.setOrgName(reqDto.getName());
        return orgInfoDto;
    }
}

