/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ICustomerInfoApi;
import com.dtyunxi.tcbj.api.dto.request.CustomerExtReqDto;
import com.dtyunxi.tcbj.api.dto.request.QueryCustomerOrgInfoReqDto;
import com.dtyunxi.tcbj.api.dto.response.QueryCustomerOrgInfoRespDto;
import com.dtyunxi.tcbj.api.dto.response.QueryCustomerVerifyTaskRespDto;
import com.dtyunxi.tcbj.api.query.ICustomerDistributorsQueryApi;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyVerifyRespDto;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditEntityApi;
import com.dtyunxi.yundt.cube.center.customer.api.IImportRecordApi;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerStatusExtEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.IsCustomerEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreAreaLevelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreIsFirstParentEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerReqExtDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreQueryProvinceReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernExcelRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreAreaQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryTobApi;
import com.dtyunxi.yundt.cube.center.user.api.ICustomerOrgInfoApi;
import com.dtyunxi.yundt.cube.center.user.api.ICustomerUserApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationThreeApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ModifyOrganizationInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.ICustomerOrgInfoQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.ICustomerUserQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerExtService;
import com.dtyunxi.yundt.module.customer.api.ICustomerV4Service;
import com.dtyunxi.yundt.module.customer.api.dto.request.CheckCreditByCustomerCodeReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.CompanyVerifyExtReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.VerifyCustomerByExcelReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.VerifyCustomerByOrgIdReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerListRespDto;
import com.dtyunxi.yundt.module.customer.api.enums.CompanyVerifyEnum;
import com.dtyunxi.yundt.module.customer.api.enums.SrcTypeEnum;
import com.dtyunxi.yundt.module.customer.biz.impl.CustomerServiceImpl;
import com.dtyunxi.yundt.module.customer.biz.mq.producer.CustomerChangeProducer;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.ICustomerExtThreeApi;
import com.yx.tcbj.center.customer.api.ICustomerSyncCreditApi;
import com.yx.tcbj.center.customer.api.dto.request.ComputeCustomerNameRateReqDto;
import com.yx.tcbj.center.customer.api.dto.request.CustomerSearchExtThreeReqDto;
import com.yx.tcbj.center.customer.api.dto.request.UpdateOrgAddressReqDto;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import com.yx.tcbj.center.customer.api.query.IStoreQueryApi;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="customerV4Service")
public class CustomerServiceV4Impl
implements ICustomerV4Service {
    private static final Logger log = LoggerFactory.getLogger(CustomerServiceV4Impl.class);
    private static Logger logger = LoggerFactory.getLogger(CustomerServiceImpl.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private ICustomerOrgInfoApi customerOrgInfoApi;
    @Resource
    private ICustomerApi customerApi;
    @Autowired
    private IUserApi userApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private ICustomerUserQueryApi customerUserQueryApi;
    @Resource
    private ICustomerUserApi customerUserApi;
    @Resource
    private ICustomerOrgInfoQueryApi customerOrgInfoQueryApi;
    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private OssRegistryVo ossRegistryVo;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IOrderQueryTobApi orderQueryTobApi;
    @Resource
    private CustomerChangeProducer customerChangeProducer;
    @Resource
    private ICreditEntityApi iCreditEntityApi;
    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICustomerInfoApi customerInfoApi;
    @Resource
    private ICustomerExtService customerExtService;
    @Resource
    private IOrganizationExtApi organizationExtApi;
    @Resource
    private ICustomerExtThreeApi customerExtThreeApi;
    @Resource
    private com.yx.tcbj.center.customer.api.query.ICustomerQueryApi customerQueryApi2;
    @Resource
    private IStoreQueryApi storeQueryApi;
    @Resource
    private ICustomerDistributorsQueryApi customerDistributorsQueryApi;
    @Resource
    private IOrganizationThreeApi organizationThreeApi;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private IImportRecordApi importRecordApi;
    @Resource
    private ExportService exportService;
    @Resource
    private IStoreAreaQueryApi storeAreaQueryApi;
    @Resource
    private ICustomerSyncCreditApi customerSyncCreditApi;

    public PageInfo<CustomerListRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        RestResponse enableCustomerIds;
        CustomerSearchExtThreeReqDto searchReqDto = new CustomerSearchExtThreeReqDto();
        logger.info("queryByPage params:{}", (Object)filter);
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (CustomerSearchExtThreeReqDto)JSONObject.parseObject((String)filter, CustomerSearchExtThreeReqDto.class);
        }
        searchReqDto.setTenantId(this.context.tenantId());
        this.settingUserIdsForSearch((CustomerSearchReqDto)searchReqDto);
        if (Objects.nonNull(searchReqDto.getUserFlag()) && !searchReqDto.getUserFlag().booleanValue()) {
            return new PageInfo();
        }
        searchReqDto.setListFlag(Boolean.valueOf(true));
        if (SrcTypeEnum.SALESMAN.getCode().equals(searchReqDto.getSrcType())) {
            searchReqDto.setSalesmanUserId(this.context.userId());
            RestResponse pageInfoRestResponse = this.customerQueryApi.queryByPage(JSON.toJSONString((Object)searchReqDto), pageNum, pageSize);
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
            ArrayList listRespDtoList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                List customerIds = (List)this.customerExtQueryApi.queryCustomerIdByOrgId(pageInfo.getList().stream().map(CustomerRespDto::getMerchantId).distinct().collect(Collectors.toList())).getData();
                List customerList = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)customerIds)) {
                    customerList = (List)this.customerExtQueryApi.queryListByCustomerIds(customerIds).getData();
                }
                logger.info("\u83b7\u53d6\u6240\u5c5e\u5546\u5bb6 customerIds = {}, customerList = {}", (Object)JSONObject.toJSONString((Object)customerIds), (Object)JSONObject.toJSONString((Object)customerList));
                List orgInfoIds = pageInfo.getList().stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
                List orgAndOrgInfoByIds = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryOrgAndOrgInfoByIds(orgInfoIds));
                logger.info("\u83b7\u53d6\u6240\u5c5eorgInfo orgInfoIds = {}, orgAndOrgInfoList = {}", (Object)JSONObject.toJSONString(orgInfoIds), (Object)JSONObject.toJSONString((Object)orgAndOrgInfoByIds));
                for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                    CustomerListRespDto listRespDto = new CustomerListRespDto();
                    CubeBeanUtils.copyProperties((Object)listRespDto, (Object)customerRespDto, (String[])new String[0]);
                    if (CollectionUtils.isNotEmpty((Collection)customerList)) {
                        for (CustomerRespDto customer : customerList) {
                            if (!Objects.equals(customerRespDto.getMerchantId(), customer.getOrgInfoId())) continue;
                            listRespDto.setMerchantName(customer.getName());
                            break;
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)orgAndOrgInfoByIds)) {
                        for (OrgAndOrgInfoRespDto orgAndOrgInfoRespDto : orgAndOrgInfoByIds) {
                            if (!Objects.equals(customerRespDto.getOrgInfoId(), orgAndOrgInfoRespDto.getOrganizationDto().getId())) continue;
                            listRespDto.setOrgName(orgAndOrgInfoRespDto.getOrganizationInfoDto().getOrgName());
                            break;
                        }
                    }
                    listRespDtoList.add(listRespDto);
                }
            }
            logger.info("\u4e1a\u52a1\u5458\u7aeflistRespDtoList>>>>{}", (Object)JSON.toJSONString((Object)listRespDtoList));
            PageInfo listRespDtoPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)listRespDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
            listRespDtoPageInfo.setList((List)listRespDtoList);
            return listRespDtoPageInfo;
        }
        if ("Y".equalsIgnoreCase(searchReqDto.getIsHaveCreditAccount())) {
            enableCustomerIds = this.iCreditEntityApi.getEnableCustomerIds("3");
            searchReqDto.setIdList((List)enableCustomerIds.getData());
        }
        if (Objects.equals(searchReqDto.getIsFilterCreditEntity(), "Y")) {
            enableCustomerIds = this.iCreditEntityApi.getEnableCustomerIds("3");
            searchReqDto.setIdNotInList((List)enableCustomerIds.getData());
            logger.info("[\u5ba2\u5546\u5ba2\u6237] >>> \u8fc7\u6ee4\u6389\u5df2\u4fe1\u7528\u51c6\u5165\u7684\u5ba2\u6237id:{}", (Object)searchReqDto.getIdNotInList());
        }
        searchReqDto.setIsFilterDownstreamCustomersByCurrentUser(Boolean.valueOf(true));
        if (searchReqDto.getType() == null) {
            searchReqDto.setType(CustomerTypeEnum.DEALER.getCode());
        }
        if (searchReqDto.getChannel() == null) {
            searchReqDto.setChannel(CustomerTypeEnum.DEALER.getCode());
        }
        if (searchReqDto.getOrganizationId() != null) {
            searchReqDto.setMerchantIds(Arrays.asList(searchReqDto.getOrganizationId()));
        }
        RestResponse pageInfoRestResponse = this.customerExtThreeQueryApi.queryByPage(JSON.toJSONString((Object)searchReqDto), pageNum, pageSize);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        PageInfo listRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)listRespDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList listRespDtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                CustomerListRespDto listRespDto = new CustomerListRespDto();
                CubeBeanUtils.copyProperties((Object)listRespDto, (Object)customerRespDto, (String[])new String[0]);
                listRespDtoList.add(listRespDto);
            }
        }
        listRespDtoPageInfo.setList((List)listRespDtoList);
        return listRespDtoPageInfo;
    }

    private void settingUserIdsForSearch(CustomerSearchReqDto searchReqDto) {
        if (StringUtils.isNotEmpty((CharSequence)searchReqDto.getUserName())) {
            ArrayList userFilters = Lists.newArrayList();
            userFilters.add(SqlFilter.like((String)"userName", (Object)("%" + searchReqDto.getUserName() + "%")));
            HashMap filterMap = Maps.newHashMap();
            filterMap.put("filters", userFilters);
            filterMap.put("tenantId", searchReqDto.getTenantId());
            filterMap.put("instanceId", searchReqDto.getInstanceId());
            String queryFilter = JSONObject.toJSONString((Object)filterMap);
            RestResponse pageInfoRestResponse = this.userQueryApi.queryByPage(queryFilter, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
            PageInfo userDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
            ArrayList userIdList = Lists.newArrayList();
            if (Objects.nonNull(userDtoPageInfo) && CollectionUtils.isNotEmpty((Collection)userDtoPageInfo.getList())) {
                for (UserDto userDto : userDtoPageInfo.getList()) {
                    userIdList.add(userDto.getId());
                }
            }
            if (CollectionUtils.isEmpty((Collection)userIdList)) {
                searchReqDto.setUserFlag(Boolean.valueOf(false));
            }
            searchReqDto.setUserIds((List)userIdList);
        }
    }

    public StoreSellerGovernExcelRespDto verifyCustomerByExcel(MultipartFile file) {
        Long recordId = this.exportService.init(file.getOriginalFilename(), ExportTypeEnum.VERIFY_CUSTOMER_BATCH);
        ((ICustomerV4Service)this.applicationContext.getBean(ICustomerV4Service.class)).verifyCustomerByExcelAsyn(file, recordId);
        return null;
    }

    @Async
    public StoreSellerGovernExcelRespDto verifyCustomerByExcelAsyn(MultipartFile file, Long recordId) {
        boolean isSuccess = false;
        StoreSellerGovernExcelRespDto result = new StoreSellerGovernExcelRespDto();
        try {
            result = this.verifyCustomerByExcelAsyn0(file);
            isSuccess = true;
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u4e09\u8981\u7d20\u8ba4\u8bc1\u5931\u8d25 \u4efb\u52a1id:" + recordId);
            e.printStackTrace();
            this.exportService.fail(recordId, String.format("\u6587\u4ef6\u540d\uff1a%s , \u4efb\u52a1id\uff1a%s , \u8ba4\u8bc1\u5931\u8d25\u539f\u56e0\uff1a%s", file.getOriginalFilename(), recordId, e));
        }
        if (isSuccess) {
            this.exportService.success(recordId, result.getErrorFile(), String.format("\u603b\u8ba4\u8bc1\uff1a%s\u6761\uff0c\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761", result.getNum(), result.getSuccessNum(), result.getFailNum()));
        }
        return null;
    }

    public StoreSellerGovernExcelRespDto verifyCustomerByExcelAsyn0(MultipartFile file) {
        StoreSellerGovernExcelRespDto respDto = new StoreSellerGovernExcelRespDto();
        respDto.setNum(Integer.valueOf(0));
        respDto.setSuccessNum(Integer.valueOf(0));
        respDto.setFailNum(Integer.valueOf(0));
        ImportParams importParams = new ImportParams();
        importParams.setTitleRows(0);
        importParams.setHeadRows(1);
        List excelDtos = null;
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), VerifyCustomerByExcelReqDto.class, (ImportParams)importParams);
            excelDtos = result.getList();
        }
        catch (Exception e2) {
            throw new BizException("\u89e3\u6790excel\u5f02\u5e38" + e2);
        }
        if (excelDtos == null) {
            throw new BizException("\u89e3\u6790excel\u5931\u8d25 \u89e3\u6790\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (excelDtos.size() > 1000) {
            throw new BizException("\u89e3\u6790excel\u5931\u8d25 \u6570\u636e\u4e0d\u80fd\u8d85\u8fc71000\u6761");
        }
        List<VerifyCustomerByOrgIdReqDto> verifyDtos = excelDtos.stream().map(e -> {
            e.setVerifyDto(VerifyCustomerByOrgIdReqDto.builder().cusCode(e.getCusCode()).orgName(e.getOrgName()).creditCode(e.getCreditCode()).legalName(e.getLegalName()).province(e.getProvince()).city(e.getCity()).district(e.getDistrict()).build());
            return e.getVerifyDto();
        }).collect(Collectors.toList());
        this.verifyCustomerByCustomerCode(verifyDtos);
        excelDtos.forEach(e -> {
            e.setVerify(e.getVerifyDto().isSuccess());
            e.setVerifyResult(e.getVerifyDto().getMsg());
        });
        int successNum = (int)excelDtos.stream().filter(VerifyCustomerByExcelReqDto::isVerify).count();
        if (CollectionUtils.isNotEmpty((Collection)excelDtos)) {
            try {
                String fileName = "\u5ba2\u6237\u6279\u91cf\u4e09\u8981\u7d20\u8ba4\u8bc1";
                if (StringUtils.isNotEmpty((CharSequence)file.getOriginalFilename())) {
                    fileName = file.getOriginalFilename().substring(0, file.getOriginalFilename().lastIndexOf("."));
                }
                ArrayList excelTempDtos = new ArrayList(excelDtos);
                String exportUrl = EasyPoiExportUtil.getExportUrl(excelTempDtos, VerifyCustomerByExcelReqDto.class, null, (String)("cube/" + fileName + "-\u8ba4\u8bc1\u7ed3\u679c-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss")), (String)"xls");
                respDto.setErrorFile(exportUrl);
                respDto.setFailNum(Integer.valueOf(excelDtos.size() - successNum));
            }
            catch (Exception e3) {
                throw new BizException("\u5904\u7406\u660e\u7ec6excel\u751f\u6210\u5931\u8d25\uff1a" + e3);
            }
        }
        respDto.setNum(Integer.valueOf(excelDtos.size()));
        respDto.setSuccessNum(Integer.valueOf(successNum));
        return respDto;
    }

    private void verifyCustomerByCustomerCode(List<VerifyCustomerByOrgIdReqDto> dtos) {
        for (VerifyCustomerByOrgIdReqDto dto : dtos) {
            if (StringUtils.isEmpty((CharSequence)dto.getCusCode())) {
                dto.setMsg("\u6570\u636e\u5f02\u5e38\uff1a[\u5ba2\u6237\u7f16\u53f7*]\u5b57\u6bb5\u7f3a\u5931\uff0c\u65e0\u6cd5\u8ba4\u8bc1");
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)dto.getOrgName())) {
                dto.setMsg("\u6570\u636e\u5f02\u5e38\uff1a\u5ba2\u6237\u4e09\u8981\u7d20\u4e0a\u4f20\u4e0d\u5168\uff0c[\u516c\u53f8\u540d\u79f0*]\u5b57\u6bb5\u7f3a\u5931\uff0c\u65e0\u6cd5\u8ba4\u8bc1");
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)dto.getCreditCode())) {
                dto.setMsg("\u6570\u636e\u5f02\u5e38\uff1a\u5ba2\u6237\u4e09\u8981\u7d20\u4e0a\u4f20\u4e0d\u5168\uff0c[\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801*]\u5b57\u6bb5\u7f3a\u5931\uff0c\u65e0\u6cd5\u8ba4\u8bc1");
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)dto.getLegalName())) {
                dto.setMsg("\u6570\u636e\u5f02\u5e38\uff1a\u5ba2\u6237\u4e09\u8981\u7d20\u4e0a\u4f20\u4e0d\u5168\uff0c[\u6cd5\u5b9a\u4ee3\u8868\u4eba*]\u5b57\u6bb5\u7f3a\u5931\uff0c\u65e0\u6cd5\u8ba4\u8bc1");
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)dto.getProvince())) {
                dto.setMsg("\u6570\u636e\u5f02\u5e38\uff1a\u5ba2\u6237\u4e09\u8981\u7d20\u4e0a\u4f20\u4e0d\u5168\uff0c[\u516c\u53f8\u6240\u5c5e\u7701\u4efd*]\u5b57\u6bb5\u7f3a\u5931\uff0c\u65e0\u6cd5\u8ba4\u8bc1");
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)dto.getCity())) {
                dto.setMsg("\u6570\u636e\u5f02\u5e38\uff1a\u5ba2\u6237\u4e09\u8981\u7d20\u4e0a\u4f20\u4e0d\u5168\uff0c[\u516c\u53f8\u6240\u5c5e\u57ce\u5e02*]\u5b57\u6bb5\u7f3a\u5931\uff0c\u65e0\u6cd5\u8ba4\u8bc1");
                continue;
            }
            dto.setCusCode(dto.getCusCode().trim());
            dto.setCreditCode(dto.getCreditCode().trim());
            dto.setOrgName(dto.getOrgName().trim());
            dto.setLegalName(dto.getLegalName().trim());
            List customerOrgInfos = (List)RestResponseHelper.extractData((RestResponse)this.customerInfoApi.queryCustomerOrgInfo(QueryCustomerOrgInfoReqDto.builder().code(dto.getCusCode()).build()));
            log.info("\u67e5\u8be2\u6570\u636e customerOrgInfos={}", (Object)JSONObject.toJSONString((Object)customerOrgInfos));
            if (customerOrgInfos == null || customerOrgInfos.isEmpty()) {
                dto.setMsg("\u6570\u636e\u5f02\u5e38\uff1a[\u5ba2\u6237\u7f16\u53f7]\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a");
                continue;
            }
            QueryCustomerOrgInfoRespDto customer = (QueryCustomerOrgInfoRespDto)customerOrgInfos.get(0);
            if (customer.getIfCertification().equals("1") && customer.getExistOrgInfo().equals("1")) {
                dto.setMsg("\u65e0\u9700\u5904\u7406\uff1a\u5ba2\u6237\u4e09\u8981\u7d20\u5df2\u8ba4\u8bc1\uff0c\u65e0\u9700\u91cd\u590d\u8ba4\u8bc1");
                continue;
            }
            String provinceCode = this.getStoreAreaCodeByName(dto.getProvince(), "CN", String.valueOf(StoreAreaLevelEnum.PROVINCE.getCode()));
            if (provinceCode == null) {
                dto.setMsg("\u6570\u636e\u5f02\u5e38\uff1a[\u516c\u53f8\u6240\u5c5e\u7701\u4efd]\u7f16\u7801\u65e0\u6cd5\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u540d\u79f0\u662f\u5426\u6b63\u786e");
                continue;
            }
            dto.setProvinceCode(provinceCode);
            String cityCode = this.getStoreAreaCodeByName(dto.getCity(), provinceCode, String.valueOf(StoreAreaLevelEnum.CITY.getCode()));
            if (cityCode == null) {
                dto.setMsg("\u6570\u636e\u5f02\u5e38\uff1a[\u516c\u53f8\u6240\u5c5e\u57ce\u5e02]\u7f16\u7801\u65e0\u6cd5\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u540d\u79f0\u662f\u5426\u6b63\u786e");
                continue;
            }
            dto.setCityCode(cityCode);
            if (dto.getDistrict() != null) {
                String districtCode = this.getStoreAreaCodeByName(dto.getDistrict(), cityCode, String.valueOf(StoreAreaLevelEnum.DISTRICT.getCode()));
                if (districtCode == null) {
                    dto.setMsg("\u6570\u636e\u5f02\u5e38\uff1a[\u516c\u53f8\u6240\u5c5e\u5730\u533a]\u7f16\u7801\u65e0\u6cd5\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u540d\u79f0\u662f\u5426\u6b63\u786e");
                    continue;
                }
                dto.setDistrictCode(districtCode);
            }
            boolean verifyResult = false;
            try {
                CompanyVerifyExtReqDto companyVerifyReqDto = new CompanyVerifyExtReqDto();
                companyVerifyReqDto.setCode(dto.getCreditCode());
                companyVerifyReqDto.setName(dto.getOrgName());
                companyVerifyReqDto.setLegalPersonName(dto.getLegalName());
                companyVerifyReqDto.setProvinceCode(dto.getProvinceCode());
                companyVerifyReqDto.setCityCode(dto.getCityCode());
                companyVerifyReqDto.setCustomerId(customer.getCusId());
                companyVerifyReqDto.setCustomerCode(dto.getCusCode());
                CompanyVerifyRespDto companyVerifyRespDto = this.customerExtService.verifyCompany(companyVerifyReqDto);
                if (!Objects.equals(companyVerifyRespDto.getResult(), CompanyVerifyEnum.SUCCESS.getCode())) {
                    dto.setMsg("\u5ba2\u6237\u4e09\u8981\u7d20\u8ba4\u8bc1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + companyVerifyRespDto.getRemark());
                    continue;
                }
                this.checkCreditByCustomerCode(CheckCreditByCustomerCodeReqDto.builder().cusCode(dto.getCusCode()).creditCode(dto.getCreditCode()).orgName(dto.getOrgName()).build());
                verifyResult = true;
            }
            catch (Exception e) {
                dto.setMsg("\u5ba2\u6237\u4e09\u8981\u7d20\u8ba4\u8bc1\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            }
            if (!verifyResult) continue;
            dto.setSuccess(true);
            dto.setMsg("\u4e09\u8981\u7d20\u8ba4\u8bc1\u6210\u529f");
            CustomerReqExtDto updateCusReq = new CustomerReqExtDto();
            updateCusReq.setId(Long.valueOf(customer.getCusId()));
            updateCusReq.setIfCertification(Integer.valueOf(1));
            this.customerExtThreeApi.updateCustomerByDto(updateCusReq);
            this.organizationThreeApi.saveOrUpdateOrgInfo(ModifyOrganizationInfoReqDto.builder().orgId(Long.valueOf(customer.getOrgId())).creditCode(dto.getCreditCode()).orgName(dto.getOrgName()).legalName(dto.getLegalName()).build());
            this.customerSyncCreditApi.updateOrgAddress(UpdateOrgAddressReqDto.builder().reqDto(StoreReqDto.builder().province(dto.getProvince()).provinceCode(dto.getProvinceCode()).city(dto.getCity()).cityCode(dto.getCityCode()).district(dto.getDistrict()).districtCode(dto.getDistrictCode()).build()).orgId(customer.getOrgId()).build());
        }
    }

    private String getStoreAreaCodeByName(String name, String parentCode, String level) {
        log.info("\u6839\u636e\u533a\u57df\u540d\u79f0\u83b7\u53d6\u533a\u57dfcode\u53c2\u6570 ==> \u533a\u57df\u540d\u79f0: {}; \u533a\u57dfparentCode {}; level {}", new Object[]{name, parentCode, level});
        if (parentCode == null) {
            return null;
        }
        StoreAreaRespDto storeAreaRespDto = (StoreAreaRespDto)RestResponseHelper.extractData((RestResponse)this.storeAreaQueryApi.queryByProvince(StoreQueryProvinceReqDto.builder().parentCode(parentCode).level(level).name(name).build()));
        log.info("\u6839\u636e\u533a\u57df\u540d\u79f0\u83b7\u53d6\u533a\u57dfcode\u7ed3\u679c ==> \u533a\u57dfcode: {}", (Object)storeAreaRespDto.getCode());
        return storeAreaRespDto.getCode();
    }

    public void checkCreditByCustomerCode(CheckCreditByCustomerCodeReqDto dto) {
        RestResponse storeRespDtoRestResponse = this.storeQueryApi.queryStoreRespDtoByCreditNum(dto.getCreditCode());
        StoreRespDto storeRespDto = (StoreRespDto)RestResponseHelper.extractData((RestResponse)storeRespDtoRestResponse);
        logger.info("\u836f\u5e97\u3010{}\u3011\u8be6\u7ec6\u4fe1\u606f\uff1a{}", (Object)dto.getCreditCode(), (Object)JSON.toJSONString((Object)storeRespDto));
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{storeRespDto})) {
            Assert.isTrue((boolean)storeRespDto.getIsCustomer().equals(IsCustomerEnum.NOT_CUSTOMER.getCode()), (String)"0001", (String)"\u5f53\u524d\u4fe1\u7528\u4ee3\u7801\u4e3a\u5927\u5ba2\u6237!!!");
            Assert.isTrue((boolean)storeRespDto.getIsFirstPartner().equals(StoreIsFirstParentEnum.NOT_FIRST_PARENT.getCode()), (String)"0001", (String)"\u5f53\u524d\u4fe1\u7528\u4ee3\u7801\u4e3a\u4e00\u7ea7\u7ecf\u9500\u5546!!!");
            Assert.isTrue((!StoreStatusEnum.findCustomerStatus((String)storeRespDto.getState()).equals((Object)CustomerStatusExtEnum.CANCEL) ? 1 : 0) != 0, (String)"0001", (String)"\u5f53\u524d\u4fe1\u7528\u4ee3\u7801\u5df2\u6ce8\u9500!!!");
        }
        RestResponse customer = this.customerQueryApi2.queryCustomerByCode(dto.getCusCode());
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customer);
        logger.info("\u5f53\u524d\u6821\u9a8c\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)customerRespDto));
        CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
        customerExtReqDto.setCreditCode(dto.getCreditCode());
        customerExtReqDto.setMerchantId(customerRespDto.getMerchantId());
        List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerDistributorsQueryApi.queryCustomerList(customerExtReqDto));
        List customerCodes = customerRespDtoList.stream().filter(c -> c.getType().equals(CustomerTypeEnum.RETAILER.getCode())).map(CustomerRespDto::getCode).filter(code -> !code.equals(dto.getCusCode())).collect(Collectors.toList());
        logger.info("\u6821\u9a8c\u4fe1\u7528\u4ee3\u7801\u67e5\u8be2\u5ba2\u6237\u7ed3\u679c\u96c6\uff1a{}", (Object)JSON.toJSONString(customerCodes));
        Assert.isTrue((boolean)CollectionUtils.isEmpty(customerCodes), (String)"0001", (String)("\u5546\u5bb6\u5df2\u5b58\u5728\u8be5\u96f6\u552e\u5546\u5ba2\u6237[" + StringUtils.join(customerCodes, (String)" | ") + "],\u8bf7\u68c0\u67e5\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801"));
        this.customerExtThreeApi.computeCustomerNameRate(ComputeCustomerNameRateReqDto.builder().orgName(dto.getOrgName()).cusName(customerRespDto.getName()).creditCode(dto.getCreditCode()).build());
    }

    public Void verifyCustomerByTable() {
        List customerVerifyTasks = (List)RestResponseHelper.extractData((RestResponse)this.customerInfoApi.queryCustomerVerifyTask());
        if (customerVerifyTasks == null || customerVerifyTasks.isEmpty()) {
            return null;
        }
        List<VerifyCustomerByOrgIdReqDto> verifyDtos = customerVerifyTasks.stream().map(e -> VerifyCustomerByOrgIdReqDto.builder().taskId(e.getId()).cusCode(e.getCode()).orgName(e.getOrgName()).creditCode(e.getCreditCode()).legalName(e.getLegalName()).build()).collect(Collectors.toList());
        this.verifyCustomerByCustomerCode(verifyDtos);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (VerifyCustomerByOrgIdReqDto verifyDto : verifyDtos) {
            QueryCustomerVerifyTaskRespDto updateParam = QueryCustomerVerifyTaskRespDto.builder().id(verifyDto.getTaskId()).verify(String.valueOf(verifyDto.isSuccess())).verifyResult(verifyDto.getMsg()).processStatus(verifyDto.isSuccess() ? "1" : "0").updateTime(sdf.format(new Date())).build();
            this.customerInfoApi.updateVerifyTask(updateParam);
        }
        return null;
    }
}

