/**
 * @(#)UserLoginBo.java 1.0 2019年7月10日
 *
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.module.customer.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Range;

/**
 * 用户登录请求参数
 * 
 * @author wu.sheng
 * @time 2019年7月10日 下午2:12:31
 */
@ApiModel(value = "LoginInfo", description = "用户登录请求参数")
public class LoginInfo {

	@ApiModelProperty(name = "loginType", value = "登陆方式(必填)：(0,手机号\\用户名\\邮箱 + 密码),(1,用户名+密码)（2，手机+密码），（3，手机+验证码），（4，邮箱+密码），（5,身份证+加密码），（6,用户名+加密码+验证码）", required = true)
	@Range(min = 0, max = 6)
	private Integer loginType;

	@ApiModelProperty(name = "password", value = "密码,根据登录方式选填")
	private String password;

	@ApiModelProperty(name = "loginName", value = "登录名(必填):手机、邮箱、用户名、身份证号码,根据登录方式选择其中之一", required = true)
	private String loginName;

	@ApiModelProperty(name = "captcha", value = "验证码,根据登录方式选填")
	private String captcha;

	@ApiModelProperty(name = "captchaId", value = "验证码唯一id,根据登录方式选填")
	private String captchaId;

	@ApiModelProperty(name = "keepDays", value = "保持登录状态(单位:天),token有效时间选填")
	private Integer keepDays;

	@ApiModelProperty(name="srcType",value = "来源类型（1:经销商小程序端，2:PC管理端，3:业务员小程序端）")
	private Integer srcType;

	@ApiModelProperty(name="type",value = "是否是邀请注册，1是，2不是，默认不是")
	private Integer type = 2;


	public Integer getSrcType() {
		return srcType;
	}

	public void setSrcType(Integer srcType) {
		this.srcType = srcType;
	}

	public Integer getLoginType() {
		return loginType;
	}

	public void setLoginType(Integer loginType) {
		this.loginType = loginType;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getLoginName() {
		return loginName;
	}

	public void setLoginName(String loginName) {
		this.loginName = loginName;
	}

	public Integer getKeepDays() {
		return keepDays;
	}

	public void setKeepDays(Integer keepDays) {
		this.keepDays = keepDays;
	}

	public String getPassword() {
		return password;
	}

	public String getCaptcha() {
		return captcha;
	}

	public void setCaptcha(String captcha) {
		this.captcha = captcha;
	}

	public String getCaptchaId() {
		return captchaId;
	}

	public void setCaptchaId(String captchaId) {
		this.captchaId = captchaId;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}
}
