/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerSalesmanApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.SalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerSalesmanRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerSalesmanQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba2\u5546\u7ec4\u4ef6\uff1a\u5ba2\u6237\u4e1a\u52a1\u5458\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/customer/salesman"})
public class CustomerSalesmanRest {
    @Resource
    private ICustomerSalesmanApi customerSalesmanApi;
    @Resource
    private ICustomerSalesmanQueryApi customerSalesmanQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e\u4e1a\u52a1\u5458", notes="\u65b0\u589e\u4e1a\u52a1\u5458")
    public RestResponse<Long> addCustomerSalesman(@RequestBody CustomerSalesmanReqDto addReqDto) {
        return this.customerSalesmanApi.addCustomerSalesman(addReqDto);
    }

    @PutMapping
    @ApiOperation(value="\u4fee\u6539\u4e1a\u52a1\u5458", notes="\u4fee\u6539\u4e1a\u52a1\u5458")
    public RestResponse<Void> modifyCustomerSalesman(@RequestBody CustomerSalesmanReqDto modifyReqDto) {
        return this.customerSalesmanApi.modifyCustomerSalesman(modifyReqDto);
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u4e1a\u52a1\u5458", notes="\u5220\u9664\u4e1a\u52a1\u5458")
    public RestResponse<Void> remove(@RequestParam(value="ids") String ids) {
        return this.customerSalesmanApi.removeCustomerSalesman(ids);
    }

    @PostMapping(value={"change-salesman"})
    @ApiOperation(value="\u66f4\u6362\u4e1a\u52a1\u5458", notes="\u66f4\u6362\u4e1a\u52a1\u5458")
    public RestResponse<Void> changeSalesman(@RequestBody SalesmanReqDto salesmanReqDto) {
        return this.customerSalesmanApi.changeSalesman(salesmanReqDto);
    }

    @PostMapping(value={"end-salesman"})
    @ApiOperation(value="\u7ed3\u675f\u4e1a\u52a1\u5458", notes="\u7ed3\u675f\u4e1a\u52a1\u5458")
    public RestResponse<Void> endSalesman(@RequestBody SalesmanReqDto salesmanReqDto) {
        return this.customerSalesmanApi.endSalesman(salesmanReqDto);
    }

    @PostMapping(value={"add-customer-salesman"})
    @ApiOperation(value="\u65b0\u52a0\u5ba2\u6237\u4e1a\u52a1\u5458\u5173\u8054", notes="\u65b0\u52a0\u5ba2\u6237\u4e1a\u52a1\u5458\u5173\u8054")
    public RestResponse<Void> addSalesmanRelation(@RequestBody SalesmanReqDto salesmanReqDto) {
        return this.customerSalesmanApi.addSalesmanRelation(salesmanReqDto);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u4e1a\u52a1\u5458\u4fe1\u606f", notes="\u6839\u636eid\u67e5\u8be2\u4e1a\u52a1\u5458\u4fe1\u606f")
    public RestResponse<CustomerSalesmanRespDto> queryById(@PathVariable(value="id") Long id) {
        RestResponse sellerRespDtoRestResponse;
        RestResponse customerSalesmanRespDtoRestResponse = this.customerSalesmanQueryApi.queryById(id);
        CustomerSalesmanRespDto data = (CustomerSalesmanRespDto)customerSalesmanRespDtoRestResponse.getData();
        if (Objects.nonNull(data) && Objects.nonNull(data.getOrgInfoId()) && Objects.nonNull((sellerRespDtoRestResponse = this.sellerExtQueryApi.querySellerByOrganizationId(data.getOrgInfoId())).getData())) {
            data.setSellerName(((SellerRespDto)sellerRespDtoRestResponse.getData()).getName());
        }
        return customerSalesmanRespDtoRestResponse;
    }

    @GetMapping(value={"page"})
    @ApiOperation(value="\u4e1a\u52a1\u5458\u8868\u5206\u9875\u6570\u636e", notes="\u4e1a\u52a1\u5458\u8868\u5206\u9875\u6570\u636e")
    public RestResponse<PageInfo<CustomerSalesmanRespDto>> queryByPage(@SpringQueryMap CustomerSalesmanReqDto customerSalesmanReqDto, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return this.customerSalesmanQueryApi.queryByPage(customerSalesmanReqDto, pageNum, pageSize);
    }
}

