package com.dtyunxi.yundt.module.customer.rest.user;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.customer.api.user.IWeixinService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;


/**
 * 微信服务
 *
 * @author wu.sheng
 * @date 2020/2/28 10:05
 */
@Api(tags = {"用户组件：微信服务"})
@RestController
@RequestMapping("/v1/weixin")
public class WeixinRest {

    private static final Logger logger = LoggerFactory.getLogger(WeixinRest.class);

    @Resource
    private IWeixinService weixinService;

    @Resource
    private ICacheService cacheService;

    @GetMapping("/config")
    @ApiOperation(value = "获取微信JSSKD配置")
    @ApiImplicitParam(paramType = "query", name = "url", dataType = "String", required = true, value = "页面地址")
    public RestResponse jsSkdConfig(@RequestParam(value = "url") String url) {
        return new RestResponse<>(weixinService.jsSdkSign(url));
    }

    @GetMapping("/oauth-uri")
    @ApiOperation(value = "获取openid第一步：获取微信网页授权地址")
    public RestResponse oauthUri(@RequestParam(value = "redirectUri") String redirectUri) {
        return new RestResponse<>(weixinService.getCodeUri(redirectUri));
    }

    @GetMapping("/code")
    @ApiOperation(value = "接受微信网页授权code,重定向到redirectUri", notes = "因为前端redirectUri中带有#号，微信重定向会丢失，所以后端服务重定向")
    public void redirectUri(String code, String state, HttpServletResponse httpServletResponse) {
        logger.info("微信网页授权code：{}", code);
        String redirectUri = cacheService.getCache(state, String.class);
        int index = redirectUri.indexOf("?");
        String codeStr = null;
        if (index > 0) {
            codeStr = "&code=" + code;
        } else {
            codeStr = "?code=" + code;
        }
        redirectUri = redirectUri + codeStr;

        try {
            httpServletResponse.sendRedirect(redirectUri);
        } catch (IOException e) {
            logger.error("忽略重定向异常");
        }
    }

    @GetMapping("/openid")
    @ApiOperation(value = "获取openid第二步：根据网页授权code获取openid")
    public RestResponse getOpenId(String code) {
        return new RestResponse<>(weixinService.getOpenId(code));
    }

    @GetMapping("wxacode")
    @ApiOperation(value = "获取小程序二维码.path为路径。width二维码宽度280px-1280px之间")
    public RestResponse<String> getWxaCode(String path, int width) {
        return new RestResponse<>(weixinService.getWxaCode(path, width));
    }


}