/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.rest;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerDataApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerImportSaveReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.enmus.ImportTypeEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.biz.mq.process.CustomerInfoImportProcessor;
import com.dtyunxi.yundt.module.customer.biz.mq.process.SupplierInfoImportProcessor;
import com.dtyunxi.yundt.module.customer.biz.mq.producer.CustomerImportProducer;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba2\u5546\u7ec4\u4ef6\uff1a\u5ba2\u5546\u4e2d\u5fc3\u5bfc\u5165\u76f8\u5173\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/customer/data"})
public class ICustomerDataRest {
    private static final Logger logger = LoggerFactory.getLogger(ICustomerDataRest.class);
    @Resource
    ICustomerDataApi customerDataApi;
    @Resource
    CustomerInfoImportProcessor customerInfoImportProcessor;
    @Resource
    SupplierInfoImportProcessor supplierInfoImportProcessor;
    @Resource
    CustomerImportProducer customerImportProducer;
    @Resource
    private IContext context;

    @PostMapping(value={"customer-import"})
    @ApiOperation(value="\u4fdd\u5b58\u6279\u91cf\u5bfc\u5165\u63a5\u53e3")
    public RestResponse<Void> customerImport(@RequestBody CustomerImportSaveReqDto customerImportSaveReqDto) {
        customerImportSaveReqDto.setOperator(this.context.userName());
        RestResponse longRestResponse = this.customerDataApi.saveCustomerInfoImport(customerImportSaveReqDto);
        Long aLong = (Long)RestResponseHelper.extractData((RestResponse)longRestResponse);
        logger.info("\u4fdd\u5b58\u6210\u529f,\u5f00\u59cb\u901a\u77e51 = [" + customerImportSaveReqDto.toString() + "]instanceId:" + customerImportSaveReqDto.getInstanceId());
        customerImportSaveReqDto.setId(aLong);
        customerImportSaveReqDto.setInstanceId(null != ServiceContext.getContext().getRequestInstanceId() ? ServiceContext.getContext().getRequestInstanceId() : customerImportSaveReqDto.getInstanceId());
        customerImportSaveReqDto.setTenantId(null != ServiceContext.getContext().getRequestTenantId() ? ServiceContext.getContext().getRequestTenantId() : customerImportSaveReqDto.getTenantId());
        logger.info("\u4fdd\u5b58\u6210\u529f,\u5f00\u59cb\u901a\u77e52 = [" + customerImportSaveReqDto.toString() + "]instanceId:" + customerImportSaveReqDto.getInstanceId());
        this.customerImportProducer.sendCustomerImportMq(customerImportSaveReqDto);
        return new RestResponse();
    }

    @PostMapping(value={"/test"})
    @ApiOperation(value="\u6d4b\u8bd5\u9488\u5bf9\u4e0a\u4f20\u6587\u6863\u7684\u5904\u7406\u903b\u8f91,\u53ef\u53c2\u8003\u4ee5\u4e0b\u5bfc\u5165\u6570\u636e", notes="{\n  \"createPerson\": \"ssssss\",\n  \"extFields\": {},\n  \"extension\": \"string\",\n  \"fileName\": \"\u4f9b\u5e94\u5546\u5bfc\u5165\u8868\u6a21v1.0.0\",\n  \"importType\": 1,\n  \"instanceId\": 1,\n  \"tenantId\": 1,\n  \"operator\": \"sumo\",\n  \"id\": 1255590515967578139,\n  \"updatePerson\": \"string\",\n  \"url\": \"https://yunxi-isales.oss-cn-shenzhen.aliyuncs.com/\u5ba2\u6237\u5bfc\u5165\u8868\u6a21v1.0.2 - \u771f\u5b9e\u6570\u636e.xlsx\"\n}")
    public RestResponse<MessageResponse> test(@RequestBody CustomerImportSaveReqDto customerImportSaveReqDto) {
        customerImportSaveReqDto.setInstanceId(null != ServiceContext.getContext().getRequestInstanceId() ? ServiceContext.getContext().getRequestInstanceId() : customerImportSaveReqDto.getInstanceId());
        customerImportSaveReqDto.setTenantId(null != ServiceContext.getContext().getRequestTenantId() ? ServiceContext.getContext().getRequestTenantId() : customerImportSaveReqDto.getTenantId());
        if (ImportTypeEnum.fromCode((Integer)customerImportSaveReqDto.getImportType()) == ImportTypeEnum.CUSTOMER) {
            this.customerInfoImportProcessor.process(customerImportSaveReqDto);
        } else if (ImportTypeEnum.fromCode((Integer)customerImportSaveReqDto.getImportType()) == ImportTypeEnum.SUPPLIER) {
            this.supplierInfoImportProcessor.process(customerImportSaveReqDto);
        }
        return new RestResponse();
    }
}

