/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.rest;

import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.query.IStoreSearchQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreDataOriginEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernExcelRespDto;
import com.dtyunxi.yundt.module.customer.biz.service.IStoreService;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.customer.api.IStoreApi;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.api.query.IStoreQueryApi;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5ba2\u5546\u7ec4\u4ef6\uff1a\u836f\u5e97\u76f8\u5173\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/store"})
public class StoreRest {
    @Resource
    private IStoreQueryApi storeQueryApi;
    @Resource
    private IStoreApi storeApi;
    @Resource
    private IStoreSearchQueryApi storeSearchQueryApi;
    @Resource
    private IStoreService storeService;

    @PostMapping(value={"/excel"}, produces={"application/json"})
    @ApiOperation(value="\u836f\u5e97\u6570\u636eExcel\u5bfc\u5165", notes="\u836f\u5e97\u6570\u636eExcel\u5bfc\u5165")
    public RestResponse<StoreSellerGovernExcelRespDto> excel(@RequestParam(value="file") MultipartFile file) {
        List brandDtoList = (List)RestResponseHelper.extractData((RestResponse)this.storeSearchQueryApi.queryBrands());
        Map<String, String> brandMap = brandDtoList.stream().collect(Collectors.toMap(e -> e.getName(), t -> t.getCode(), (e1, e2) -> e1));
        return this.storeApi.excel(file, JSON.toJsonString(brandMap));
    }

    @PostMapping(value={"/addStoreBatch"})
    @ApiOperation(value="\u6279\u91cf\u63d2\u5165\u5e97\u94fa\u6570\u636e", notes="\u6279\u91cf\u63d2\u5165\u5e97\u94fa\u6570\u636e")
    RestResponse<Void> addStoreBatch(@RequestBody List<StoreReqDto> reqDtos) {
        return this.storeApi.addStoreBatch(reqDtos);
    }

    @PostMapping(value={"/addStore"})
    @ApiOperation(value="\u63d2\u5165\u5e97\u94fa\u6570\u636e", notes="\u63d2\u5165\u5e97\u94fa\u6570\u636e")
    RestResponse<Void> addStoreBatch(@RequestBody StoreReqDto reqDtos) {
        return this.storeApi.addStoreBatch(Arrays.asList(reqDtos));
    }

    @PostMapping(value={"/updateStoreBatch"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u4f01\u4e1a\u4fe1\u606f", notes="\u6279\u91cf\u4fee\u6539\u4f01\u4e1a\u4fe1\u606f")
    RestResponse<Void> updateStoreBatch(@RequestBody List<StoreReqDto> reqDtos) {
        return this.storeApi.updateStoreBatch(reqDtos);
    }

    @PostMapping(value={"/updateStore"})
    @ApiOperation(value="\u4fee\u6539\u4f01\u4e1a\u4fe1\u606f", notes="\u4fee\u6539\u4f01\u4e1a\u4fe1\u606f")
    RestResponse<Void> updateStore(@RequestBody StoreReqDto reqDto) {
        return this.storeApi.updateStore(reqDto);
    }

    @PostMapping(value={"/queryPage"})
    @ApiOperation(value="\u836f\u5e97\u5206\u9875\u67e5\u8be2\uff08\u54c1\u724c\u7aef\uff09", notes="\u836f\u5e97\u5206\u9875\u67e5\u8be2\uff08\u54c1\u724c\u7aef\uff09")
    RestResponse<PageInfo<StoreRespDto>> queryPage(@RequestBody StoreQueryReqDto reqDto) {
        return this.storeQueryApi.queryPage(reqDto);
    }

    @GetMapping(value={"/queryStoreRespDtoByCreditNum"})
    @ApiOperation(value="\u6839\u636e\u4fe1\u7528\u4ee3\u7801\u67e5\u8be2\u836f\u5e97\u8be6\u60c5", notes="\u6839\u636e\u4fe1\u7528\u4ee3\u7801\u67e5\u8be2\u836f\u5e97\u8be6\u60c5")
    RestResponse<StoreRespDto> queryStoreRespDtoByCreditNum(@RequestParam(value="creditNum") String creditNum) {
        return this.storeQueryApi.queryStoreRespDtoExtByCreditNum(creditNum);
    }

    @PostMapping(value={"/saveOrUpdateStore"})
    @ApiOperation(value="\u65b0\u589e\u4fee\u6539\u836f\u5e97\u6570\u636e", notes="\u65b0\u589e\u4fee\u6539\u836f\u5e97\u6570\u636e")
    RestResponse<Void> saveOrUpdateStore(@RequestBody StoreReqDto reqDto) {
        if (reqDto.getId() == null) {
            reqDto.setDataOrigin(StoreDataOriginEnum.MANUALLY_ENTER.getCode());
        }
        return this.storeService.saveOrUpdateStore(reqDto);
    }

    @PostMapping(value={"/saveOrUpdateStoreByExcel"})
    @ApiOperation(value="\u836f\u5e97\u6570\u636e\u5bfc\u5165\u53d8\u66f4", notes="\u836f\u5e97\u6570\u636e\u5bfc\u5165\u53d8\u66f4")
    RestResponse<Void> saveOrUpdateStoreByExcel(@RequestParam(value="file") MultipartFile file) {
        this.storeService.saveOrUpdateStoreByExcel(file);
        return RestResponse.SUCCESS;
    }

    @PostMapping(value={"/queryCreditAndNameInDisable"})
    @ApiOperation(value="\u6ce8\u9500\u836f\u5e97\u6a21\u7cca\u5339\u914d\u67e5\u8be2", notes="\u6ce8\u9500\u836f\u5e97\u6a21\u7cca\u5339\u914d\u67e5\u8be2 \u67e5\u8be2\u5b57\u6bb5storeName: \u5305\u62ecstoreName\u4e0ecredit\u7684\u6a21\u7cca\u5339\u914d; \u8fd4\u56de\u5b57\u6bb5storeName: \u5305\u62ecstoreName\u4e0ecredit")
    RestResponse<List<StoreRespDto>> queryCreditAndNameInDisable(@RequestBody StoreQueryReqDto reqDto) {
        return this.storeQueryApi.queryCreditAndNameInDisable(reqDto);
    }
}

