/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.rest.user;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.customer.api.user.IWeixinService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u7ec4\u4ef6\uff1a\u5fae\u4fe1\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/weixin"})
public class WeixinRest {
    private static final Logger logger = LoggerFactory.getLogger(WeixinRest.class);
    @Resource
    private IWeixinService weixinService;
    @Resource
    private ICacheService cacheService;

    @GetMapping(value={"/config"})
    @ApiOperation(value="\u83b7\u53d6\u5fae\u4fe1JSSKD\u914d\u7f6e")
    @ApiImplicitParam(paramType="query", name="url", dataType="String", required=true, value="\u9875\u9762\u5730\u5740")
    public RestResponse jsSkdConfig(@RequestParam(value="url") String url) {
        return new RestResponse((Object)this.weixinService.jsSdkSign(url));
    }

    @GetMapping(value={"/oauth-uri"})
    @ApiOperation(value="\u83b7\u53d6openid\u7b2c\u4e00\u6b65\uff1a\u83b7\u53d6\u5fae\u4fe1\u7f51\u9875\u6388\u6743\u5730\u5740")
    public RestResponse oauthUri(@RequestParam(value="redirectUri") String redirectUri) {
        return new RestResponse((Object)this.weixinService.getCodeUri(redirectUri));
    }

    @GetMapping(value={"/code"})
    @ApiOperation(value="\u63a5\u53d7\u5fae\u4fe1\u7f51\u9875\u6388\u6743code,\u91cd\u5b9a\u5411\u5230redirectUri", notes="\u56e0\u4e3a\u524d\u7aefredirectUri\u4e2d\u5e26\u6709#\u53f7\uff0c\u5fae\u4fe1\u91cd\u5b9a\u5411\u4f1a\u4e22\u5931\uff0c\u6240\u4ee5\u540e\u7aef\u670d\u52a1\u91cd\u5b9a\u5411")
    public void redirectUri(String code, String state, HttpServletResponse httpServletResponse) {
        logger.info("\u5fae\u4fe1\u7f51\u9875\u6388\u6743code\uff1a{}", (Object)code);
        String redirectUri = (String)this.cacheService.getCache(state, String.class);
        int index = redirectUri.indexOf("?");
        String codeStr = null;
        codeStr = index > 0 ? "&code=" + code : "?code=" + code;
        redirectUri = redirectUri + codeStr;
        try {
            httpServletResponse.sendRedirect(redirectUri);
        }
        catch (IOException e) {
            logger.error("\u5ffd\u7565\u91cd\u5b9a\u5411\u5f02\u5e38");
        }
    }

    @GetMapping(value={"/openid"})
    @ApiOperation(value="\u83b7\u53d6openid\u7b2c\u4e8c\u6b65\uff1a\u6839\u636e\u7f51\u9875\u6388\u6743code\u83b7\u53d6openid")
    public RestResponse getOpenId(String code) {
        return new RestResponse((Object)this.weixinService.getOpenId(code));
    }

    @GetMapping(value={"wxacode"})
    @ApiOperation(value="\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u4e8c\u7ef4\u7801.path\u4e3a\u8def\u5f84\u3002width\u4e8c\u7ef4\u7801\u5bbd\u5ea6280px-1280px\u4e4b\u95f4")
    public RestResponse<String> getWxaCode(String path, int width) {
        return new RestResponse((Object)this.weixinService.getWxaCode(path, width));
    }
}

