/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.rest.user;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.request.ModifyPasswordReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.ResetPasswordReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.TenantGuideRespDto;
import com.dtyunxi.yundt.module.customer.api.user.IAuthentication;
import com.dtyunxi.yundt.module.customer.bo.LoginInfo;
import com.dtyunxi.yundt.module.customer.bo.TokenInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u7ec4\u4ef6\uff1a\u8ba4\u8bc1\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/user"})
public class AuthenticationRest {
    @Resource
    private IContext context;
    @Resource
    private IAuthentication authenticationImpl;

    @PostMapping(value={"/token"})
    @ApiOperation(value="\u7528\u6237\u767b\u5f55", notes="\u767b\u9646\u65b9\u5f0floginType\uff1a(0,\u624b\u673a\u53f7/\u7528\u6237\u540d/\u90ae\u7bb1 + \u5bc6\u7801), (1,\u7528\u6237\u540d+\u5bc6\u7801),(2,\u624b\u673a+\u5bc6\u7801),(3,\u624b\u673a+\u9a8c\u8bc1\u7801),(4,\u90ae\u7bb1+\u5bc6\u7801),(5,\u8eab\u4efd\u8bc1+\u52a0\u5bc6\u7801),(6,\u7528\u6237\u540d+\u52a0\u5bc6\u7801+\u9a8c\u8bc1\u7801)")
    @ApiImplicitParam(paramType="body", name="loginInfo", dataType="LoginInfo", required=true, value="\u7528\u6237\u767b\u5f55")
    RestResponse<TokenInfo> login(@Valid @RequestBody LoginInfo loginInfo) {
        return new RestResponse((Object)this.authenticationImpl.login(loginInfo));
    }

    @PostMapping(value={"/new/token"})
    @ApiOperation(value="\u7528\u6237\u767b\u5f55", notes="\u767b\u9646\u65b9\u5f0floginType\uff1a(0,\u624b\u673a\u53f7/\u7528\u6237\u540d/\u90ae\u7bb1 + \u5bc6\u7801), (1,\u7528\u6237\u540d+\u5bc6\u7801),(2,\u624b\u673a+\u5bc6\u7801),(3,\u624b\u673a+\u9a8c\u8bc1\u7801),(4,\u90ae\u7bb1+\u5bc6\u7801),(5,\u8eab\u4efd\u8bc1+\u52a0\u5bc6\u7801),(6,\u7528\u6237\u540d+\u52a0\u5bc6\u7801+\u9a8c\u8bc1\u7801)")
    @ApiImplicitParam(paramType="body", name="loginInfo", dataType="LoginInfo", required=true, value="\u7528\u6237\u767b\u5f55")
    RestResponse<TokenInfo> newLogin(@Valid @RequestBody LoginInfo loginInfo) {
        return new RestResponse((Object)this.authenticationImpl.newLogin(loginInfo));
    }

    @DeleteMapping(value={"/logout/token"})
    @ApiOperation(value="\u6ce8\u9500")
    RestResponse<Void> logout() {
        this.authenticationImpl.logout(this.context.userId());
        return RestResponse.VOID;
    }

    @ApiOperation(value="\u6839\u636e\uff08\u7528\u6237\u540d+\u539f\u5bc6\u7801\uff09\u4fee\u6539\u5bc6\u7801")
    @ApiImplicitParam(paramType="body", name="modifyPasswordReqDto", dataType="ModifyPasswordReqDto", required=true, value="\u4fee\u6539\u5bc6\u7801\u53c2\u6570")
    @PutMapping(value={"/password"})
    RestResponse<Void> modifyPassword(@Valid @RequestBody ModifyPasswordReqDto modifyPasswordReqDto) {
        this.authenticationImpl.modifyPassword(modifyPasswordReqDto.getUserName(), modifyPasswordReqDto.getPassword(), modifyPasswordReqDto.getNewPassword());
        return RestResponse.VOID;
    }

    @ApiOperation(value="\u6839\u636e(\u624b\u673a/\u90ae\u7bb1+\u9a8c\u8bc1\u7801)\u91cd\u7f6e\u5bc6\u7801")
    @ApiImplicitParam(paramType="body", name="resetPasswordReqDto", dataType="ResetPasswordReqDto", required=true, value="\u4fee\u6539\u5bc6\u7801\u53c2\u6570")
    @PutMapping(value={"/password/reset"})
    RestResponse<Void> resetPassword(@Valid @RequestBody ResetPasswordReqDto resetPasswordReqDto) {
        this.authenticationImpl.resetPassword(resetPasswordReqDto);
        return RestResponse.VOID;
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u91cd\u7f6e\u5bc6\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", name="userId", dataType="Long", required=true, value="\u7528\u6237id"), @ApiImplicitParam(paramType="query", name="newPassword", dataType="String", required=true, value="\u65b0\u5bc6\u7801")})
    @PutMapping(value={"/{userId}/password/reset"})
    RestResponse<Void> resetPassword(@PathVariable(value="userId") Long userId, @RequestParam(value="newPassword") String newPassword) {
        this.authenticationImpl.resetPassword(userId, newPassword);
        return RestResponse.VOID;
    }

    @ApiOperation(value="\u624b\u673a\u53f7\u7801\u7ed1\u5b9a")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", name="userId", dataType="Long", required=true, value="\u7528\u6237id"), @ApiImplicitParam(paramType="query", name="phone", dataType="String", required=true, value="\u624b\u673a\u53f7\u7801")})
    @PutMapping(value={"/{userId}/phone/bind"})
    RestResponse<Void> bindPhone(@PathVariable(value="userId") Long userId, @RequestParam(value="phone") String phone) {
        this.authenticationImpl.bindPhone(userId, phone);
        return RestResponse.VOID;
    }

    @ApiOperation(value="\u624b\u673a\u53f7\u7801\u89e3\u7ed1")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", name="userId", dataType="Long", required=true, value="\u7528\u6237id"), @ApiImplicitParam(paramType="query", name="phone", dataType="String", required=true, value="\u624b\u673a\u53f7\u7801")})
    @PutMapping(value={"/{userId}/phone/unbind"})
    RestResponse<Void> unbindPhone(@PathVariable(value="userId") Long userId, @RequestParam(value="phone") String phone) {
        this.authenticationImpl.unbindPhone(userId, phone);
        return RestResponse.VOID;
    }

    @GetMapping(value={"/tenant/guide"})
    @ApiOperation(value="\u79df\u6237\u6307\u5f15")
    RestResponse<TenantGuideRespDto> tenantGuide() {
        return new RestResponse((Object)this.authenticationImpl.tenantGuide(this.context.tenantId()));
    }
}

