package com.dtyunxi.yundt.module.customer.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaTreeRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 省市区
 * @author xuhuaqiang
 * @version 1.0.0
 * @description
 * @date 2020/9/28 18:06
 */
@Api(tags = {"客商组件：地区信息服务"})
@RestController
@RequestMapping("/v1/basedata/area")
public class AreaRest {

    @Resource
    private IAreaQueryApi areaQueryApi;

    /**
     * 通过编码查询下级地址集合
     *
     * @param parentCode
     * @return
     * @author xuhuaqiang
     * @time 2020年9月28日
     * @version
     */
    @ApiOperation(value = "根据区域父编码查询区域", notes = "当parentCode=0时，查询所有省数据")
    @GetMapping("/list")
    public RestResponse queryAreaList(@RequestParam(required = false, defaultValue = "0") String parentCode) {
        return areaQueryApi.queryByParentCode(parentCode);
    }

    @RequestMapping(
            value = {"/tree"},
            method = {RequestMethod.GET}
    )
    @ApiOperation(
            value = "查询区域树",
            notes = "查询区域树"
    )
    public RestResponse<List<AreaTreeRespDto>> queryForTree(){
        return areaQueryApi.queryForTree();
    }

    @RequestMapping(
            value = {"/tree/level/{level}"},
            method = {RequestMethod.GET}
    )
    @ApiOperation(
            value = "查询区域树",
            notes = "查询区域树"
    )
    public RestResponse<List<AreaTreeRespDto>> queryForTree(@PathVariable("level") Integer level){
        return areaQueryApi.queryForTree(level);
    }
}
