/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.rest;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.module.customer.api.ICustomerService;
import com.dtyunxi.yundt.module.customer.api.dto.request.CustomerDetailReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.UserAccountReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerDetailAddRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerDetailRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerListRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba2\u5546\u7ec4\u4ef6\uff1a\u5ba2\u6237\u4fe1\u606f\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/customer"})
public class CustomerRest {
    private static final Logger logger = LoggerFactory.getLogger(CustomerRest.class);
    @Autowired
    private ICustomerService customerService;
    @Autowired
    private IUserApi userApi;

    @ApiOperation(value="\u65b0\u589e\u5ba2\u6237\u4fe1\u606f", notes="\u65b0\u589e\u5ba2\u6237\u4fe1\u606f")
    @Deprecated
    RestResponse<CustomerDetailAddRespDto> add(@Valid @RequestBody CustomerDetailReqDto reqDto) {
        logger.info("\u521b\u5efa\u5ba2\u6237\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return new RestResponse((Object)this.customerService.add(reqDto));
    }

    @ApiOperation(value="\u4fdd\u5b58\u5168\u90e8\u5ba2\u6237\u76f8\u5173\u4fe1\u606f", notes="\u4fdd\u5b58\u5168\u90e8\u5ba2\u6237\u76f8\u5173\u4fe1\u606f")
    @Deprecated
    RestResponse<CustomerDetailAddRespDto> saveAll(@Valid @RequestBody CustomerDetailReqDto reqDto) {
        logger.info("\u4fdd\u5b58\u5168\u90e8\u5ba2\u6237\u76f8\u5173\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return new RestResponse((Object)this.customerService.saveAll(reqDto));
    }

    @ApiOperation(value="\u4fee\u6539\u5ba2\u6237\u4fe1\u606f", notes="\u4fee\u6539\u5ba2\u6237\u4fe1\u606f")
    @Deprecated
    RestResponse<Void> update(@Valid @RequestBody CustomerDetailReqDto reqDto) {
        logger.info("\u4fee\u6539\u5ba2\u6237\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        this.customerService.update(reqDto);
        return new RestResponse();
    }

    @PostMapping(value={"/addAccount"})
    @ApiOperation(value="\u521b\u5efa\u5ba2\u6237\u8d26\u53f7\u4fe1\u606f", notes="\u521b\u5efa\u5ba2\u6237\u8d26\u53f7\u4fe1\u606f")
    RestResponse<Long> addCustomerAccount(@Validated @RequestBody UserAccountReqDto userAccountReqDto) {
        this.customerService.addCustomerAccount(userAccountReqDto);
        return new RestResponse();
    }

    @PostMapping(value={"/updateAccount"})
    @ApiOperation(value="\u7f16\u8f91\u5ba2\u6237\u8d26\u53f7\u4fe1\u606f", notes="\u7f16\u8f91\u5ba2\u6237\u8d26\u53f7\u4fe1\u606f")
    RestResponse<Long> updateCustomerAccount(@Validated @RequestBody UserAccountReqDto userAccountReqDto) {
        this.customerService.updateCustomerAccount(userAccountReqDto);
        return new RestResponse();
    }

    @GetMapping(value={""}, produces={"application/json"})
    @ApiOperation(value="\u5ba2\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2", notes="\u5ba2\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="filter", value="\u8fc7\u6ee4\u6761\u4ef6, tenantId, instanceId\u901a\u8fc7filter\u4f20\u9012", dataType="string", paramType="query"), @ApiImplicitParam(name="pageNum", value="\u8d77\u59cb\u9875", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="pageSize", value="\u6bcf\u4e00\u9875\u7684\u8bb0\u5f55\u6570", dataType="int", paramType="query", required=true)})
    RestResponse<PageInfo<CustomerListRespDto>> queryByPage(@RequestParam(name="filter", required=false) String filter, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return new RestResponse((Object)this.customerService.queryByPage(filter, pageNum, pageSize));
    }

    @PostMapping(value={"/queryByPage"}, produces={"application/json"})
    @ApiOperation(value="\u5ba2\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2", notes="\u5ba2\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2")
    RestResponse<PageInfo<CustomerListRespDto>> queryByPage(@RequestBody CustomerSearchReqDto searchReqDto, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return new RestResponse((Object)this.customerService.queryByPage(JSON.toJSONString((Object)searchReqDto), pageNum, pageSize));
    }

    @ApiOperation(value="\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u8be6\u60c5", notes="\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u8be6\u60c5")
    @ApiImplicitParam(name="id", value="ID", dataType="Long", paramType="path", required=true)
    @GetMapping(value={"/{id}"}, produces={"application/json"})
    RestResponse<CustomerDetailRespDto> queryById(@PathVariable(value="id") Long id) {
        return new RestResponse((Object)this.customerService.queryById(id));
    }

    @PutMapping(value={"/move-customer"}, produces={"application/json"})
    @ApiOperation(value=" \u8fc1\u79fb\u5ba2\u6237\u5230\u6307\u5b9a\u533a\u57df\u4e0b", notes=" \u8fc1\u79fb\u5ba2\u6237\u5230\u6307\u5b9a\u533a\u57df\u4e0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sourceRegionCode", value="\u8d77\u59cb\u533a\u57df", dataType="String", paramType="query", required=true), @ApiImplicitParam(name="targetRegionCode", value="\u76ee\u6807\u533a\u57df", dataType="String", paramType="query", required=true)})
    RestResponse<Void> moveCustomerToRegion(@RequestParam(value="sourceRegionCode") String sourceRegionCode, @RequestParam(value="targetRegionCode") String targetRegionCode) {
        this.customerService.moveCustomerToRegion(sourceRegionCode, targetRegionCode);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/export"}, produces={"application/json"})
    @ApiOperation(value="\u5bfc\u51fa\u5ba2\u6237", notes="\u5bfc\u51fa\u5ba2\u6237")
    RestResponse<String> exportCustomer(@RequestBody CustomerSearchReqDto customerSearchReqDto) {
        return new RestResponse((Object)this.customerService.exportCustomer(customerSearchReqDto));
    }

    @GetMapping(value={"/exportExt"}, produces={"application/json"})
    @ApiOperation(value="\u5bfc\u51fa\u5ba2\u6237Ext", notes="\u5bfc\u51fa\u5ba2\u6237Ext")
    RestResponse<String> exportCustomer(@RequestParam(name="filter", required=false) String filter, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return new RestResponse("0", this.customerService.exportCustomerExt(filter));
    }

    @ApiOperation(value="\u6821\u9a8c\u5ba2\u6237\u5bfc\u51fa\u4e0a\u4f20oss\u662f\u5426\u6210\u529f", notes="\u6821\u9a8c\u5ba2\u6237\u5bfc\u51fa\u4e0a\u4f20oss\u662f\u5426\u6210\u529f")
    @GetMapping(value={"/check-export"})
    RestResponse<Boolean> checkExportCustomer(@RequestParam(value="fileName") String fileName) {
        return new RestResponse((Object)this.customerService.checkExportCustomer(fileName));
    }

    @GetMapping(value={"/address-page"}, produces={"application/json"})
    @ApiOperation(value="\u5ba2\u6237\u7684\u5730\u5740\u4fe1\u606f\u5206\u9875\u67e5\u8be2", notes="\u5ba2\u6237\u7684\u5730\u5740\u4fe1\u606f\u5206\u9875\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57\u641c\u7d22(\u6536\u8d27\u4eba/\u8054\u7cfb\u65b9\u5f0f)", dataType="string", paramType="query"), @ApiImplicitParam(name="addressType", value="\u5730\u5740\u7c7b\u578b:1\u6536\u8d27\u5730\u5740\uff0c2\u6536\u7968\u5730\u5740", dataType="string", paramType="query"), @ApiImplicitParam(name="customerId", value="\u5ba2\u6237ID", dataType="Long", paramType="query", required=true), @ApiImplicitParam(name="pageNum", value="\u8d77\u59cb\u9875", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="pageSize", value="\u6bcf\u4e00\u9875\u7684\u8bb0\u5f55\u6570", dataType="int", paramType="query", required=true)})
    RestResponse<PageInfo<AddressDto>> queryAddressByPage(@RequestParam(name="keyword", required=false) String keyword, @RequestParam(name="addressType", required=false) String addressType, @RequestParam(value="customerId") Long customerId, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return new RestResponse((Object)this.customerService.queryAddressByPage(keyword, addressType, customerId, pageNum, pageSize));
    }

    @GetMapping(value={"/default-address"}, produces={"application/json"})
    @ApiOperation(value="\u5ba2\u6237\u7684\u9ed8\u8ba4\u5730\u5740\u4fe1\u606f\u67e5\u8be2", notes="\u5ba2\u6237\u7684\u9ed8\u8ba4\u5730\u5740\u4fe1\u606f\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="addressType", value="\u5730\u5740\u7c7b\u578b:1FF\u6536\u8d27\u5730\u5740\uff0c2\u6536\u7968\u5730\u5740", dataType="string", paramType="query"), @ApiImplicitParam(name="customerId", value="\u5ba2\u6237ID", dataType="Long", paramType="query", required=true)})
    RestResponse<AddressDto> queryDefaultAddress(@RequestParam(name="addressType", required=false) String addressType, @RequestParam(value="customerId") Long customerId) {
        return new RestResponse((Object)this.customerService.queryDefaultAddress(addressType, customerId));
    }
}

