package com.dtyunxi.yundt.module.customer.rest.user;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.IOrgInfoExtApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrganizationInfoExtDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrgInfoExtQueryApi;
import com.dtyunxi.yundt.module.customer.api.user.IAccessExtService;
import com.dtyunxi.yundt.module.customer.api.user.IOrgInfoExtService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Author: xiuji
 * @Date: 2022/2/25 10:58 AM
 */
@Api(tags = {"用户组件：组织信息管理"})
@RestController
@RequestMapping("/v2/orgInfoExt")
public class OrgInfoExtRest  {

    @Autowired
    private IOrgInfoExtService orgInfoExtService;


    @PostMapping("/queryOrgInfoByOrgId")
    @ApiOperation(value = "根据组织id查询组织公司信息", notes = "根据组织id查询组织公司信息")
    public RestResponse<List<OrganizationInfoExtDto>> queryOrgInfoByOrgId(@RequestBody List<Long> orgIdList){
        return orgInfoExtService.queryOrgInfoByOrgId(orgIdList);
    }

    /**
     * 新增或修改当前组织公司信息
     *
     * @param reqDto 请求参数
     * @return 组织ID
     */
    @PostMapping("/addOrUpd")
    @ApiOperation(value = "新增或修改当前组织公司信息", notes = "新增或修改当前组织公司信息")
    public RestResponse<Long> addOrUpd(@RequestBody OrganizationInfoExtDto reqDto) {
        return orgInfoExtService.addOrUpd(reqDto);
    }
}
