/*
 * @(#) LoginRest.java 1.1.0 2019-06-24
 * Copyright (c)  2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.module.customer.rest.user;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.customer.biz.service.ILoginService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 用户登陆
 *
 * @author sumo on 2020/10/20 0020
 */
@Api(tags = {"用户登陆:权限角色相关"})
@RestController
@RequestMapping("/v1/users")
@Validated
public class LoginRest {

    @Resource
    private ILoginService loginService;

    @RequestMapping(value = {"/queryUserAccessResources"}, produces = "application/json", method = RequestMethod.GET)
    @ApiOperation(value = "获取用户权限")
    public RestResponse getAccessInfo() {

        return new RestResponse<>(loginService.getAccessInfo());
    }

    @RequestMapping(value = {"/access"}, produces = "application/json", method = RequestMethod.GET)
    @ApiOperation(value = "用户角色权限资源查询,菜单树", notes = "用户角色权限资源查询，" +
            "返回结构与/v1/access/{instanceId}/user/{userId}不一致，构建了菜单树" +
            ",filter :{ \"withNoFirstNode\"=1} 表示菜单树不要第一级节点，第一级节点不等于根节点code=0")
    public RestResponse queryUserAccessResources() {
        return new RestResponse<>(loginService.queryUserAccessResources());

    }

}
