package com.dtyunxi.yundt.module.customer.rest.user;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.entity.ImportBaseResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeImportReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.EmployeeImportExtReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.EmployeeExpandQueryReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.EmployeeExpandReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.EmployeeExpandRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.SellerEmployeeImportDto;
import com.dtyunxi.yundt.module.customer.api.user.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author liangfa
 * @Description 人员信息
 * @date 2022-01-14 17:42
 * @since 1.0.0
 */
@Api(tags = {"用户组件：人员定开扩展信息"})
@RestController
@RequestMapping("/v2/ext/employee")
public class EmployeeExpand2Rest {

    @Resource
    private IEmployeeExpand2Service employeeExpand2Service;

    @Resource
    private IB2bEmployeeExpandService ib2bEmployeeExpandService;
    @Resource
    private ICustomerEmployeeExpandService customerEmployeeExpandService;
    @Resource
    private IOrgEmployeeExpandService orgEmployeeExpandService;
    @Resource
    private ISellerEmployeeExtService sellerEmployeeExtService;

    @PostMapping({"/addEmployee/{instanceId}"})
    @ApiOperation(value = "新增人员信息", notes = "新增人员信息")
    public RestResponse<Long> addEmployee(@PathVariable("instanceId") Long instanceId,
                                          @RequestBody EmployeeExpandReqDto reqDto) {
        return employeeExpand2Service.addEmployee(instanceId, reqDto);
    }

    @PostMapping({"/modifyEmployee/{instanceId}"})
    @ApiOperation(value = "修改人员信息", notes = "修改人员信息")
    public RestResponse<Void> modifyEmployee(@PathVariable("instanceId") Long instanceId,
                                             @RequestBody EmployeeExpandReqDto reqDto) {
        return employeeExpand2Service.modifyEmployee(instanceId, reqDto);
    }

    /**
     * 更新人员状态(支持批量)
     *
     * @param reqDto 请求参数DTO
     * @return
     */
    @PostMapping({"/upateStatus/{instanceId}"})
    @ApiOperation(value = "更新人员状态(支持批量)", notes = "更新人员状态(支持批量)")
    public RestResponse<Void> upateStatus(@PathVariable("instanceId") Long instanceId,
                                          @RequestBody EmployeeExtReqDto reqDto) {
        return employeeExpand2Service.updateStatus(instanceId, reqDto);
    }

    /**
     * 设置超管
     *
     * @param reqDto 请求参数DTO
     * @return
     */
    @PostMapping({"/setSuperAdmin/{instanceId}"})
    @ApiOperation(value = "设置超管", notes = "设置超管")
    public RestResponse<Void> setSuperAdmin(@PathVariable("instanceId") Long instanceId,
                                            @RequestBody EmployeeExtReqDto reqDto) {
        return employeeExpand2Service.setSuperAdmin(instanceId, reqDto);
    }


    /**
     * 分页查询人员信息
     *
     * @param reqDto 人员查询条件
     * @return 人员分页数据信息
     */
    @PostMapping("/page")
    @ApiOperation(value = "分页查询人员信息", notes = "分页查询人员信息")
    public RestResponse<PageInfo<EmployeeExpandRespDto>> queryByPage(@RequestBody EmployeeExpandQueryReqDto reqDto) {
        return employeeExpand2Service.queryByPage(reqDto);
    }

    /**
     * 查询人员详情
     *
     * @param reqDto 人员查询条件
     * @return 人员详情
     */
    @PostMapping("/queryById")
    @ApiOperation(value = "查询人员详情", notes = "查询人员详情")
    public RestResponse<EmployeeExpandRespDto> queryById(@RequestBody EmployeeExtReqDto reqDto) {
        return employeeExpand2Service.queryById(reqDto);
    }

    /**
     * 根据组织查询人员分页信息
     * @param organizationId 组织ID
     * @return 人员分页信息
     */
    @PostMapping("/queryPageByOrg")
    @ApiOperation(value = "根据组织查询人员分页信息", notes = "根据组织查询人员分页信息")
    public RestResponse<PageInfo<EmployeeExpandRespDto>> queryPageByOrg(@RequestParam("organizationId") Long organizationId,
                                                                     @RequestParam(value = "pageNum",required = false,defaultValue = "1") Integer pageNum,
                                                                     @RequestParam(value = "pageSize",required = false,defaultValue = "10") Integer pageSize) {
        return employeeExpand2Service.queryPageByOrg(organizationId,pageNum,pageSize);
    }

    @GetMapping("/getEmployeeOrgIdByUserId")
    @ApiOperation(value = "查询用户的绑定人员有效的组织id", notes = "查询用户的绑定人员有效的组织id")
    public RestResponse<List<Long>> getEmployeeOrgIdByUserId(@RequestParam("userId") Long userId){
        return employeeExpand2Service.getEmployeeOrgIdByUserId(userId);
    }

    @GetMapping("/queryByRole")
    @ApiOperation(value = "根据角色获取人员信息", notes = "根据角色获取人员信息")
    public RestResponse<List<EmployeeExtRespDto>> queryByRole(@RequestParam("roleId") Long roleId, @RequestParam("instanceId") Long instanceId) {
        return employeeExpand2Service.queryByRole(roleId,instanceId);
    }



    @GetMapping("/getOrgInfoByUserId")
    @ApiOperation(value = "查询用户的绑定人员有效的组织商家", notes = "查询用户的绑定人员有效的组织商家")
    public RestResponse<List<OrganizationDto>> getOrgInfoByUserId(@RequestParam("userId")Long userId){
        return employeeExpand2Service.getOrgInfoByUserId(userId);
    }



    /**
     * 导入人员信息
     *
     * @return 响应结果
     */
    @PostMapping(value = "/importExcelEmployee", produces = "application/json")
    @ApiOperation(value = "导入人员信息", notes = "导入人员信息")
    public RestResponse<ImportBaseResponse> importExcelEmployee(@RequestBody EmployeeImportExtReqDto importReqDto) {
        return employeeExpand2Service.importExcelEmployee(importReqDto);
    }


    /**
     * 导入组织人员信息
     *
     * @return 响应结果
     */
    @PostMapping(value = "/importOrgExcelEmployee", produces = "application/json")
    @ApiOperation(value = "导入组织人员信息", notes = "导入组织人员信息")
    public RestResponse<ImportBaseResponse> importOrgExcelEmployee(@RequestBody EmployeeImportReqDto importReqDto) {
        return orgEmployeeExpandService.importOrgExcelEmployee(importReqDto);
    }

    @PostMapping(value = "/doSellerEmployeeImport", produces = "application/json")
    @ApiOperation(value = "处理商家人员导入", notes = "处理商家人员导入")
    public RestResponse<List<SellerEmployeeImportDto>> doSellerEmployeeImport(@RequestBody  List<SellerEmployeeImportDto> importDataList){
        return sellerEmployeeExtService.doSellerEmployeeImport(importDataList);
    }

    @PostMapping(value = "/importB2bExcelEmployee", produces = "application/json")
    @ApiOperation(value = "导入品牌端人员信息", notes = "导入品牌端人员信息")
    public RestResponse<ImportBaseResponse> importB2bExcelEmployee(@RequestBody EmployeeImportReqDto importReqDto) {
        return ib2bEmployeeExpandService.importB2bExcelEmployee(importReqDto);
    }
    @PostMapping(value = "/importCustomerExcelEmployee", produces = "application/json")
    @ApiOperation(value = "导入客户人员信息", notes = "导入客户人员信息")
    public RestResponse<ImportBaseResponse> importCustomerExcelEmployee(@RequestBody EmployeeImportReqDto importReqDto){
        return customerEmployeeExpandService.importExcelEmployee(importReqDto);
    }

}
