package com.dtyunxi.yundt.module.customer.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.CustomerStoreResponseDto;
import com.dtyunxi.tcbj.api.dto.response.StoreSalesmanRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternConfigReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckRelationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckPatternConfigRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckRelationRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.BizImportRespDto;
import com.dtyunxi.yundt.module.customer.biz.service.IStoreCheckService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;

/**
 * @author ghosn
 * @create 2023/4/6 13:36
 */
@Api(tags = {"门店考核：门店考核服务"})
@RestController
@RequestMapping("/v1/storeCheck")
public class StoreCheckRest {

    @Resource
    private IStoreCheckService storeCheckService;

    /**
     * 客户关联药店全量信息
     *
     * @param filter
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping(value = {"/queryCustomerStorePage"})
    @ApiOperation(value = "客户关联药店全量信息", notes = "客户关联药店全量信息")
    RestResponse<PageInfo<CustomerStoreResponseDto>> queryCustomerStorePage(@RequestParam("filter") String filter,
                                                                            @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        //FIXME: 品牌方/经销商->查询门店(人店考核)列表
        return new RestResponse<>(storeCheckService.queryCustomerStorePage(filter, pageNum, pageSize));
    }

    /**
     * 人员分页数据分页数据
     *
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 分页数据
     */
    @GetMapping("/queryPersonPartnerPage")
    @ApiOperation(value = "业务员列表查询", notes = "业务员列表查询")
    RestResponse<PageInfo<StoreSalesmanRelationRespDto>> queryPersonPartnerPage(@RequestParam("filter") String filter,
                                                                                @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                                @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        return new RestResponse<>(storeCheckService.queryPersonPartnerPage(filter, pageNum, pageSize));
    }

    /**
     * 绑定门店与业务考核关系
     * @param customerCheckRelationReqDto
     * @return
     */
    @PostMapping("/bindStoreAndSalesmanRelation")
    @ApiOperation(value = "绑定门店与业务考核关系", notes = "绑定门店与业务考核关系")
    RestResponse<Void> bindStoreAndSalesmanRelation(@RequestBody CustomerCheckRelationReqDto customerCheckRelationReqDto) {
        storeCheckService.bindStoreAndSalesmanRelation(customerCheckRelationReqDto);
        return RestResponse.SUCCESS;
    }



    @PostMapping("/exportCustomerCheckRelationByExcel")
    @ApiOperation(value = "人店考核关系数据导入", notes = "人店考核关系数据导入")
    RestResponse<BizImportRespDto> exportCustomerCheckRelationByExcel(@RequestParam("file") MultipartFile file) throws Exception {
        return storeCheckService.exportCustomerCheckRelationByExcel(file);
    }



    @GetMapping("/queryStoreAndSalesmanRelationBindHistoryPage")
    @ApiOperation(value = "人店考核关系历史绑定列表查询", notes = "人店考核关系历史绑定列表查询")
    RestResponse<PageInfo<CustomerCheckRelationRespDto>> queryStoreAndSalesmanRelationBindHistoryPage(@RequestParam("filter") String filter,
                                                                                                      @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                                                      @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize) {

        return new RestResponse<>(storeCheckService.queryStoreAndSalesmanRelationBindHistoryPage(filter, pageNum, pageSize));
    }

    /**
     * 门店考核合并白名单配置新增修改
     *
     * @param addReqDto 请求对象
     * @return 处理结果
     */
    @PostMapping("/pattern/config/saveOrUpdate")
    @ApiOperation(value = "门店考核合并白名单配置新增修改", notes = "门店考核合并白名单配置新增修改")
    RestResponse<Void> saveOrUpdateCustomerCheckPatternConfig(@RequestBody CustomerCheckPatternConfigReqDto addReqDto){
        storeCheckService.saveOrUpdateCustomerCheckPatternConfig(addReqDto);
        return RestResponse.SUCCESS;
    }

    /**
     * 分页数据
     *
     * @param filter   查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 分页数据
     */
    @GetMapping("/pattern/config/page")
    @ApiOperation(value = "分页数据", notes = "根据filter查询条件查询数据，filter=CustomerCheckPatternConfigReqDto")
    RestResponse<PageInfo<CustomerCheckPatternConfigRespDto>> queryPatternConfigByPage(@RequestParam("filter") String filter,
                                                                          @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                          @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize){
        return new RestResponse(storeCheckService.queryPatternConfigByPage(filter,pageNum,pageSize));
    }

    @PostMapping("/importPatternConfig")
    @ApiOperation(value = "合并考核白名单配置", notes = "合并考核白名单配置")
    RestResponse<BizImportRespDto> exportPatternConfig(@RequestParam(name = "customerCode") String customerCode, @RequestParam("file") MultipartFile file) throws Exception {
        return new RestResponse<>(storeCheckService.exportPatternConfig(customerCode, file));
    }

}
