/*
 * @(#)CustomerSalesmanRest.java.java 1.0 2021-10-14
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.module.customer.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerSalesmanApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.SalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerSalesmanRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerSalesmanQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * 客商组件：客户业务员服务
 * @author  惜笔 | 林五弟
 * @date  2021/10/14 13:49
 * @version 1.0.0
 */
@Api(tags = {"客商组件：客户业务员服务"})
@RestController
@RequestMapping("/v1/customer/salesman")
public class CustomerSalesmanRest {

    @Resource
    private ICustomerSalesmanApi customerSalesmanApi;

    @Resource
    private ICustomerSalesmanQueryApi customerSalesmanQueryApi;

    @Resource
    private ISellerQueryApi sellerQueryApi;

    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;

    @PostMapping
    @ApiOperation(value = "新增业务员", notes = "新增业务员")
    public RestResponse<Long> addCustomerSalesman(@RequestBody CustomerSalesmanReqDto addReqDto) {
        return customerSalesmanApi.addCustomerSalesman(addReqDto);
    }

    @PutMapping
    @ApiOperation(value = "修改业务员", notes = "修改业务员")
    public RestResponse<Void> modifyCustomerSalesman(@RequestBody CustomerSalesmanReqDto modifyReqDto) {
        return customerSalesmanApi.modifyCustomerSalesman(modifyReqDto);
    }

    @DeleteMapping
    @ApiOperation(value = "删除业务员", notes = "删除业务员")
    public RestResponse<Void> remove(@RequestParam("ids") String ids) {
        return customerSalesmanApi.removeCustomerSalesman(ids);
    }

    @PostMapping("change-salesman")
    @ApiOperation(value = "更换业务员", notes = "更换业务员")
    public RestResponse<Void> changeSalesman(@RequestBody SalesmanReqDto salesmanReqDto) {
        return customerSalesmanApi.changeSalesman(salesmanReqDto);
    }

    @PostMapping("end-salesman")
    @ApiOperation(value = "结束业务员", notes = "结束业务员")
    public RestResponse<Void> endSalesman(@RequestBody SalesmanReqDto salesmanReqDto) {
        return customerSalesmanApi.endSalesman(salesmanReqDto);
    }

    @PostMapping("add-customer-salesman")
    @ApiOperation(value = "新加客户业务员关联", notes = "新加客户业务员关联")
    public RestResponse<Void> addSalesmanRelation(@RequestBody SalesmanReqDto salesmanReqDto) {
        return customerSalesmanApi.addSalesmanRelation(salesmanReqDto);
    }

    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询业务员信息", notes = "根据id查询业务员信息")
    public RestResponse<CustomerSalesmanRespDto> queryById(@PathVariable("id") Long id){
        RestResponse<CustomerSalesmanRespDto> customerSalesmanRespDtoRestResponse = customerSalesmanQueryApi.queryById(id);
        CustomerSalesmanRespDto data = customerSalesmanRespDtoRestResponse.getData();
        if (Objects.nonNull(data) && Objects.nonNull(data.getOrgInfoId())){
            // 增加商家信息
            RestResponse<SellerRespDto> sellerRespDtoRestResponse = sellerExtQueryApi.querySellerByOrganizationId(data.getOrgInfoId());
            if (Objects.nonNull(sellerRespDtoRestResponse.getData())){
                data.setSellerName(sellerRespDtoRestResponse.getData().getName());
            }
        }
        return customerSalesmanRespDtoRestResponse;
    }

    @GetMapping("page")
    @ApiOperation(value = "业务员表分页数据", notes = "业务员表分页数据")
    public RestResponse<PageInfo<CustomerSalesmanRespDto>> queryByPage(@SpringQueryMap CustomerSalesmanReqDto customerSalesmanReqDto,
                                                                    @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                    @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        return customerSalesmanQueryApi.queryByPage(customerSalesmanReqDto, pageNum, pageSize);
    }
}