package com.dtyunxi.yundt.module.customer.rest;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.TreeDto;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.response.BrandDirRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.ItemDirRespDto;
import com.dtyunxi.yundt.module.customer.api.enums.SrcTypeEnum;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 商品接口
 *
 * @author sumo
 * @date 2020/9/28 0028
 */
@Api(tags = {"客商组件：商品相关服务"})
@RestController
@RequestMapping("/v1/item")
public class ItemRestV1 {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContext context;
    @Resource
    private IBrandQueryApi iBrandQueryApi;
    @Resource
    private IDirectoryQueryApi iDirectoryQueryApi;
    @Value("${item.rootId:1230318625350978670}")
    private Long frontRootId;
    @Value("${item.back.rootId:1230317884640037892}")
    private Long backRootId;

    /**
     * 获取所有品牌
     * Created by sumo on 2020/9/28 0028
     */
    @ApiOperation(value = "获取所有品牌", notes = "获取所有品牌")
    @GetMapping("/list/brand")
    public RestResponse queryBrandList() {
        JSONObject filter = new JSONObject();
        filter.put("tenantId", context.tenantId());
        filter.put("instanceId", context.instanceId());
        filter.put("status", 1);
        RestResponse<PageInfo<BrandRespDto>> pageInfoRestResponse = iBrandQueryApi.queryByPage(filter.toJSONString(), 1, Integer.MAX_VALUE);
        return pageInfoRestResponse;
    }

    /**
     * 获取所有品牌树
     * Created by sumo on 2020/9/28 0028
     */
    @ApiOperation(value = "获取所有品牌树", notes = "获取所有品牌树")
    @GetMapping("/list/brand/tree")
    public RestResponse queryBrandTree() {
        JSONObject filter = new JSONObject();
        filter.put("tenantId", context.tenantId());
        filter.put("instanceId", context.instanceId());
        filter.put("status", 1);
        RestResponse<PageInfo<BrandRespDto>> pageInfoRestResponse = iBrandQueryApi.queryByPage(filter.toJSONString(), 1, Integer.MAX_VALUE);
        BrandDirRespDto brandDirRespDto = new BrandDirRespDto();
        brandDirRespDto.setBrandId(999999999999L);
        brandDirRespDto.setLabel("所有品牌");
        brandDirRespDto.setValue("999999999999");
        if (pageInfoRestResponse == null || pageInfoRestResponse.getData() == null || pageInfoRestResponse.getData().getList() == null) {
            return new RestResponse<>(brandDirRespDto);
        }
        brandDirRespDto.setChildren(getBrandDirRespDtos(pageInfoRestResponse.getData().getList()));
        return new RestResponse<>(brandDirRespDto);
    }

    /**
     * 获取分类子类基贺
     * @author sumo on 2020/10/27 0027
     */
    @NotNull
    private List<BrandDirRespDto> getBrandDirRespDtos(List<BrandRespDto> list) {
        List<BrandDirRespDto> brandRespDtos = new ArrayList<>();
        for (BrandRespDto brandRespDto : list) {
            BrandDirRespDto newBrand = new BrandDirRespDto();
            newBrand.setValue(brandRespDto.getId().toString());
            newBrand.setLabel(brandRespDto.getName());
            newBrand.setBrandId(brandRespDto.getId());
            brandRespDtos.add(newBrand);
        }
        return brandRespDtos;
    }

    /**
     * 获取商品分类树-root默认id:1230051610462451788
     * Created by sumo on 2020/9/28 0028
     */
    @ApiOperation(value = "获取商品分类树", notes = "获取商品分类树,root默认id:1230051610462451788(返回特定的格式)")
    @GetMapping("/list/dir")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "dirType", value = "类目类型：1 后台类目,2 前台类目,默认是2前台类目", dataType = "Int", paramType = "query")
    })
    public RestResponse queryAreaList(@RequestParam(value = "dirType", required = false) Integer dirType) {
        logger.info("获取商品分类树rootId[{}]", frontRootId);
        Long rootId = frontRootId;
        if (SrcTypeEnum.CUSTOMER.getCode().equals(dirType)){
            rootId = backRootId;
        }
        JSONObject filter = new JSONObject();
        filter.put("status", 1);
        RestResponse<TreeDto<DirectoryItemRespDto>> treeDtoRestResponse = iDirectoryQueryApi.queryDirectoryTree(rootId, filter.toJSONString());
        TreeDto<DirectoryItemRespDto> child = treeDtoRestResponse.getData();
        if (null == child || child.getNode() == null) {
            return new RestResponse<>();
        }
        ItemDirRespDto itemDirRespDto = new ItemDirRespDto();
        buildNode(itemDirRespDto, child.getNode());
        if (CollectionUtils.isNotEmpty(child.getChildren())) {
            itemDirRespDto.setChildren(buildChildren(child.getChildren()));
        }
        return new RestResponse<>(itemDirRespDto);

    }

    /**
     * 构建商品树子树信息
     * Created by sumo on 2020/10/9 0009
     */
    private List<ItemDirRespDto> buildChildren(List<TreeDto<DirectoryItemRespDto>> children) {
        List<ItemDirRespDto> itemDirRespDtos = new ArrayList<>(children.size());
        for (TreeDto<DirectoryItemRespDto> child : children) {
            ItemDirRespDto itemDirRespDto = new ItemDirRespDto();
            DirectoryItemRespDto node = child.getNode();
            buildNode(itemDirRespDto, node);
            if (CollectionUtils.isNotEmpty(child.getChildren())) {
                itemDirRespDto.setChildren(buildChildren(child.getChildren()));
            }
            itemDirRespDtos.add(itemDirRespDto);
        }
        return itemDirRespDtos;
    }

    /**
     * 构建商品树基本信息
     * Created by sumo on 2020/10/10 0010
     */
    private void buildNode(ItemDirRespDto itemDirRespDto, DirectoryItemRespDto node) {
        itemDirRespDto.setLabel(node.getName());
        itemDirRespDto.setValue(node.getId().toString());
    }


}
