/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.handler;

import com.dtyunxi.cube.framework.services.IServiceHandler;
import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemAuditReqDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="auditHandler")
public class AuditHandler
implements IServiceHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuditHandler.class);
    @Resource
    private IItemApi itemApi;
    @Resource
    private IContext context;

    public Object handle(ServiceEvent<?> serviceEvent) {
        logger.info("======>\u5ba1\u6838\u5546\u54c1");
        ItemAuditReqDto itemAuditReqDto = (ItemAuditReqDto)serviceEvent.getData();
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        itemAuditReqDto.setInstanceId(instanceId);
        itemAuditReqDto.setTenantId(tenantId);
        if (!ItemStatus.ITEM_AUDIT_SUCCESS.getStatus().equals(itemAuditReqDto.getStatus())) {
            itemAuditReqDto.setStatus(ItemStatus.ITEM_AUDIT_FAIL.getStatus());
        }
        RestResponse restResponse = this.itemApi.audit(itemAuditReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        return null;
    }
}

