/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.handler;

import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.framework.services.IServiceHandler;
import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.CycleBuyDeliveryTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ShelfTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DistributionSetReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemOnShelfReqListDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderConfigInfoRespDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query.ICommanderInfoQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.item.api.dto.request.ItemOnShelfReqDto;
import com.dtyunxi.yundt.module.item.api.dto.request.SkuShelfReqDto;
import com.dtyunxi.yundt.module.item.api.enums.ItemModuleExceptionCode;
import com.dtyunxi.yundt.module.item.biz.constants.ItemCashTypeEnum;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component(value="onShelfHandler")
public class OnShelfHandler
implements IServiceHandler,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(OnShelfHandler.class);
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemApi itemApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ICommanderInfoQueryApi commanderInfoQueryApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Value(value="${dtyunxi.icm.mgmt.shelfHandlerInConcurrency:true}")
    private boolean concurrencyMode = true;
    @Value(value="${dtyunxi.icm.mgmt.shelfHandlerBatchSize:1}")
    private int shelfHandlerBatchSize = 1;
    @Value(value="${dtyunxi.icm.mgmt.shelfHandlerBatchMaxSize:100}")
    private int shelfHandlerBatchMaxSize = 100;
    @Value(value="${icommerceb.default.frontDirId:1230318625350978670}")
    private Long defaultDirId;
    private static List<String> DEF_CNCY_CONTEXT_KEYS = new ArrayList<String>();
    private ExecutorService executor = new ThreadPoolExecutor(1, 8, 50L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(256));

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getParent() == null) {
            System.out.println(1);
        }
    }

    public Object handle(ServiceEvent<?> serviceEvent) {
        logger.info("======>\u5546\u54c1\u4e0a\u67b6\u53c2\u6570: {}", (Object)JSON.toJSONString(serviceEvent));
        List itemOnShelfReqDtos = (List)serviceEvent.getData();
        if (itemOnShelfReqDtos != null && itemOnShelfReqDtos.size() > this.shelfHandlerBatchSize && this.concurrencyMode) {
            logger.debug("\u4f7f\u7528\u5e76\u884c\u6a21\u5f0f");
            Map contextMap = ServiceContext.getContext().getKeys();
            Map<Long, List<ItemOnShelfReqDto>> sellerIdMap = itemOnShelfReqDtos.stream().collect(Collectors.groupingBy(ItemOnShelfReqDto::getShopId));
            CountDownLatch countDownLatch = new CountDownLatch(sellerIdMap.keySet().size());
            sellerIdMap.keySet().forEach(shopId -> {
                Runnable task = () -> {
                    long start = System.currentTimeMillis();
                    try {
                        List itemOnShelfReqDtoList = (List)sellerIdMap.get(shopId);
                        logger.debug("\u542f\u52a8\u5e76\u884c\u4e0a\u67b6:{}", (Object)JSON.toJSONString((Object)itemOnShelfReqDtoList));
                        for (Map.Entry entry : contextMap.entrySet()) {
                            if (entry.getValue() == null) continue;
                            logger.debug("\u589e\u52a0\u4e0a\u4e0b\u6587: {} = {}", entry.getKey(), entry.getValue());
                            ServiceContext.getContext().set((String)entry.getKey(), entry.getValue());
                        }
                        this.validate(itemOnShelfReqDtoList);
                        this.doOnshelf(itemOnShelfReqDtoList);
                        ServiceContext.removeContext();
                    }
                    catch (Exception e) {
                        logger.warn("\u5e76\u884c\u4e0a\u67b6\u5546\u54c1\u51fa\u9519", (Throwable)e);
                    }
                    finally {
                        long end = System.currentTimeMillis();
                        countDownLatch.countDown();
                        logger.debug("\u7ed3\u675f\u5e76\u884c\u4e0a\u67b6,\u8017\u65f6:{}ms", (Object)(end - start));
                    }
                };
                this.executor.submit(task);
            });
            logger.debug("\u4efb\u52a1\u63d0\u4ea4\u5b8c\u6bd5,\u7b49\u5f85\u6267\u884c");
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                logger.warn("\u5e76\u884c\u5904\u7406\u4e0a\u67b6\u5931\u8d25", (Throwable)e);
            }
        } else {
            logger.debug("\u4f7f\u7528\u4e32\u884c\u6a21\u5f0f");
            if (logger.isDebugEnabled()) {
                ServiceContext.getContext().getKeys();
            }
            this.validate(itemOnShelfReqDtos);
            this.doOnshelf(itemOnShelfReqDtos);
        }
        logger.debug("\u6267\u884c\u5b8c\u6bd5");
        return null;
    }

    private void doOnshelf(List<ItemOnShelfReqDto> itemOnShelfReqDtos) {
        ArrayList itemShelfList = Lists.newArrayList();
        ArrayList cycleBuyReqDtos = Lists.newArrayList();
        HashMap shopMap = new HashMap(64);
        itemOnShelfReqDtos.forEach(shelfReqDto -> {
            if (CollectionUtils.isEmpty((Collection)shelfReqDto.getFrontDirIds())) {
                shelfReqDto.setFrontDirIds((List)Lists.newArrayList((Object[])new Long[]{this.defaultDirId}));
            }
            Long shopId = shelfReqDto.getShopId();
            ShopBaseDto shopDto = null;
            if (shopMap.containsKey(shopId)) {
                shopDto = (ShopBaseDto)shopMap.get(shopId);
            } else {
                shopDto = (ShopBaseDto)this.shopQueryApi.queryBaseById(shelfReqDto.getShopId()).getData();
                if (null != shopDto) {
                    shopMap.put(shopId, shopDto);
                }
            }
            if (null == shopDto) {
                throw new BizException("\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            Integer busType = shelfReqDto.getBusType();
            for (SkuShelfReqDto sku : shelfReqDto.getSkus()) {
                if (busType == null || ItemBusTypeEnum.GIFT.getType().intValue() != busType.intValue()) {
                    ShopBaseDto finalShopDto = shopDto;
                    if (CollectionUtils.isNotEmpty((Collection)shelfReqDto.getShopDirIds())) {
                        shelfReqDto.getShopDirIds().forEach(dirId -> {
                            if (null != dirId) {
                                itemShelfList.add(this.getItemShelfReqDto((ItemOnShelfReqDto)shelfReqDto, finalShopDto, sku, (Long)dirId, "shop"));
                            }
                        });
                    }
                    if (CollectionUtils.isNotEmpty((Collection)shelfReqDto.getPointDirIds())) {
                        shelfReqDto.getPointDirIds().forEach(dirId -> itemShelfList.add(this.getItemShelfReqDto((ItemOnShelfReqDto)shelfReqDto, finalShopDto, sku, (Long)dirId, "point")));
                    }
                    if (CollectionUtils.isNotEmpty((Collection)shelfReqDto.getFrontDirIds())) {
                        shelfReqDto.getFrontDirIds().forEach(dirId -> itemShelfList.add(this.getItemShelfReqDto((ItemOnShelfReqDto)shelfReqDto, finalShopDto, sku, (Long)dirId, "front")));
                    }
                }
                if (busType == null || ItemBusTypeEnum.GIFT.getType().intValue() != busType.intValue()) continue;
                itemShelfList.add(this.getItemShelfReqDto((ItemOnShelfReqDto)shelfReqDto, shopDto, sku, null, null));
            }
            if (CollectionUtils.isNotEmpty((Collection)shelfReqDto.getCycleBuyReqDtos())) {
                List cycleBuyReqDtoList = shelfReqDto.getCycleBuyReqDtos().stream().filter(itemCycleBuyReqDto -> {
                    if (CycleBuyDeliveryTypeEnum.BY_MONTH.getCode() != itemCycleBuyReqDto.getDeliveryType().intValue()) {
                        return itemCycleBuyReqDto.getDeliveryType() != null && ArrayUtils.isNotEmpty((Object[])itemCycleBuyReqDto.getDeliveryRate());
                    }
                    return itemCycleBuyReqDto.getDeliveryType() != null;
                }).peek(cycleBuyReqDto -> {
                    if (cycleBuyReqDto.getShopId() == null) {
                        cycleBuyReqDto.setShopId(shelfReqDto.getShopId());
                    }
                }).collect(Collectors.toList());
                cycleBuyReqDtos.addAll(cycleBuyReqDtoList);
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)itemShelfList) && itemShelfList.size() > this.shelfHandlerBatchMaxSize) {
            logger.info("\u5546\u54c1\u4e0a\u67b6\u5217\u8868\u5927\u5c0f:{}", (Object)itemShelfList.size());
            List split = ListUtil.split((List)itemShelfList, (int)this.shelfHandlerBatchMaxSize);
            for (List itemShelfReqDtoList : split) {
                try {
                    logger.info("\u5206\u6279\u4e0a\u67b6\u5546\u54c1");
                    ItemOnShelfReqListDto itemOnShelfReqListDto = new ItemOnShelfReqListDto();
                    itemOnShelfReqListDto.setItemShelfReqDtos(itemShelfReqDtoList);
                    itemOnShelfReqListDto.setReshelf(itemOnShelfReqDtos.get(0).getRefresh());
                    itemOnShelfReqListDto.setCycleBuyReqDtos((List)cycleBuyReqDtos);
                    this.itemApi.onShelfItem(itemOnShelfReqListDto);
                    this.saveItemShelfPointsDeduction(itemShelfReqDtoList);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        } else {
            try {
                ItemOnShelfReqListDto itemOnShelfReqListDto = new ItemOnShelfReqListDto();
                itemOnShelfReqListDto.setItemShelfReqDtos((List)itemShelfList);
                itemOnShelfReqListDto.setReshelf(itemOnShelfReqDtos.get(0).getRefresh());
                itemOnShelfReqListDto.setCycleBuyReqDtos((List)cycleBuyReqDtos);
                this.itemApi.onShelfItem(itemOnShelfReqListDto);
                this.saveItemShelfPointsDeduction(itemShelfList);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void saveItemShelfPointsDeduction(List<ItemShelfReqDto> itemShelfList) {
        itemShelfList.forEach(itemShelfReqDto -> {
            if (itemShelfReqDto.getPointsDeduction() == null) {
                itemShelfReqDto.setPointsDeduction(Integer.valueOf(itemShelfReqDto.getPointsDeductionReqDto() != null ? 1 : 0));
            }
        });
        Predicate<ItemShelfReqDto> predicatePointsDeduction = itemShelfReqDto -> 1 == itemShelfReqDto.getPointsDeduction();
        boolean includePointsDeduction = itemShelfList.stream().anyMatch(predicatePointsDeduction);
        if (includePointsDeduction) {
            List pointsDeductionItemShelfReqDtoList = itemShelfList.stream().filter(predicatePointsDeduction).collect(Collectors.toList());
            logger.info("\u53d1\u9001\u4fdd\u5b58\u79ef\u5206\u6263\u51cf\u914d\u7f6e\u4fe1\u606f\u7684\u6d3b\u52a8\u53e0\u52a0\u5173\u7cfb\u6d88\u606f: {}", (Object)JSON.toJSONString(pointsDeductionItemShelfReqDtoList));
            this.commonsMqService.sendSingleMessage("SAVE_POINTS_DEDUCTION_ACTIVITY_RELATION", (Object)JSON.toJSONString(pointsDeductionItemShelfReqDtoList));
        }
    }

    private ItemShelfReqDto getItemShelfReqDto(ItemOnShelfReqDto itemShelfReqDto, ShopBaseDto shopDto, SkuShelfReqDto sku, Long dirId, String dirType) {
        List itemCycleBuyReqDtoList;
        ItemShelfReqDto shelfReqDto = new ItemShelfReqDto();
        shelfReqDto.setDirId(dirId);
        shelfReqDto.setItemId(sku.getItemId());
        shelfReqDto.setSkuId(sku.getSkuId());
        shelfReqDto.setInstanceId(this.context.instanceId());
        shelfReqDto.setTenantId(this.context.tenantId());
        shelfReqDto.setShopId(itemShelfReqDto.getShopId());
        shelfReqDto.setSellerId(shopDto.getSellerId());
        shelfReqDto.setFreightTemplateId(itemShelfReqDto.getFreightTemplateId());
        shelfReqDto.setOrganizationId(shopDto.getOrganizationId());
        shelfReqDto.setOrganizationName(shopDto.getOrganizationName());
        shelfReqDto.setPrice(sku.getPrice());
        shelfReqDto.setStorage(sku.getStorage());
        shelfReqDto.setDirType(dirType);
        shelfReqDto.setItemType(itemShelfReqDto.getItemType());
        shelfReqDto.setBusType(itemShelfReqDto.getBusType());
        shelfReqDto.setCashIntegral(sku.getCashIntegral());
        shelfReqDto.setCashLimit(sku.getCashLimit());
        shelfReqDto.setCashAmount(sku.getCashAmount());
        shelfReqDto.setCashType(itemShelfReqDto.getCashType());
        shelfReqDto.setRuleRemark(itemShelfReqDto.getRuleRemark());
        if (itemShelfReqDto.getBusType() == null) {
            shelfReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        }
        if (itemShelfReqDto.getCashType() != null) {
            shelfReqDto.setBusType(ItemBusTypeEnum.INTEGRAL.getType());
            if (itemShelfReqDto.getCashType() == ItemCashTypeEnum.INTEGRAL.getType() && shelfReqDto.getBusType() == ItemBusTypeEnum.INTEGRAL.getType()) {
                shelfReqDto.setCashAmount(BigDecimal.ZERO);
                shelfReqDto.setPrice(BigDecimal.ZERO);
            } else if (itemShelfReqDto.getCashType() == ItemCashTypeEnum.INTEGRAL_CASH.getType() && shelfReqDto.getBusType() == ItemBusTypeEnum.INTEGRAL.getType()) {
                shelfReqDto.setPrice(shelfReqDto.getCashAmount());
            }
        }
        Integer type = CollectionUtils.isNotEmpty((Collection)(itemCycleBuyReqDtoList = itemShelfReqDto.getCycleBuyReqDtos())) ? ShelfTypeEnum.PERIOD.getType() : ShelfTypeEnum.NORMAL.getType();
        shelfReqDto.setType(type);
        if (null != sku.getDistributionSet()) {
            shelfReqDto.setDistribution(Integer.valueOf(1));
            shelfReqDto.setDistributionSet(sku.getDistributionSet());
        }
        shelfReqDto.setPointsDeductionReqDto(sku.getPointsDeductionDto());
        shelfReqDto.setPointsDeduction(Integer.valueOf(sku.getPointsDeductionDto() != null ? 1 : 0));
        shelfReqDto.setBundleItemDtos(sku.getBundleItemDtos());
        shelfReqDto.setStockDisplay(itemShelfReqDto.getStockDisplay());
        shelfReqDto.setLimitMin(itemShelfReqDto.getLimitMin());
        shelfReqDto.setLimitMinMode(itemShelfReqDto.getLimitMinMode());
        shelfReqDto.setMultipleStatus(itemShelfReqDto.getMultipleStatus());
        return shelfReqDto;
    }

    private void validate(List<ItemOnShelfReqDto> itemOnShelfReqDtos) {
        if (CollectionUtils.isEmpty(itemOnShelfReqDtos)) {
            throw new BizException("\u4e0a\u67b6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.info("\u4e0a\u67b6\u7528\u6237: {}", (Object)this.context.userId());
        CommanderConfigInfoRespDto infoRespDtoToC = null;
        try {
            infoRespDtoToC = (CommanderConfigInfoRespDto)this.commanderInfoQueryApi.queryCommanderConfig(this.context.userId()).getData();
            logger.info("\u4e0a\u67b6\u7528\u6237\u7684\u56e2\u957f\u914d\u7f6e\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)infoRespDtoToC));
        }
        catch (Exception e) {
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
        }
        CommanderConfigInfoRespDto infoRespDto = infoRespDtoToC;
        HashMap shopMap = new HashMap(64);
        itemOnShelfReqDtos.forEach(itemOnShelfReqDto -> {
            if (CollectionUtils.isEmpty((Collection)itemOnShelfReqDto.getSkus())) {
                throw new BizException("\u4e0a\u67b6\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Long shopId = itemOnShelfReqDto.getShopId();
            Integer busType = itemOnShelfReqDto.getBusType() == null ? ItemBusTypeEnum.ORDINARY.getType() : itemOnShelfReqDto.getBusType();
            Boolean refresh = itemOnShelfReqDto.getRefresh();
            if (BooleanUtils.isFalse((Boolean)refresh)) {
                Set busTypeSet;
                List itemIdList = itemOnShelfReqDto.getSkus().stream().map(SkuShelfReqDto::getItemId).distinct().collect(Collectors.toList());
                List skuIdList = itemOnShelfReqDto.getSkus().stream().map(SkuShelfReqDto::getSkuId).distinct().collect(Collectors.toList());
                ShelfQueryReqDto shelfQueryReqDto = new ShelfQueryReqDto();
                shelfQueryReqDto.setShopIds((List)Lists.newArrayList((Object[])new Long[]{shopId}));
                shelfQueryReqDto.setItemIds(itemIdList);
                shelfQueryReqDto.setSkuIds(skuIdList);
                List shelfQueryRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryShelfList(shelfQueryReqDto));
                if (CollectionUtils.isNotEmpty((Collection)shelfQueryRespDtoList) && CollectionUtils.isNotEmpty(busTypeSet = shelfQueryRespDtoList.stream().map(ShelfQueryRespDto::getBusType).collect(Collectors.toSet())) && busTypeSet.contains(busType)) {
                    throw new BizException("\u4e0d\u80fd\u91cd\u590d\u4e0a\u67b6");
                }
            }
            itemOnShelfReqDto.getSkus().forEach(skuShelfReqDto -> {
                if (null == skuShelfReqDto.getStorage() || skuShelfReqDto.getStorage() < 1L) {
                    BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.NOT_ENUOGH_CAN_NOT_ON_SHELF);
                }
                if (itemOnShelfReqDto.getCashType() != null) {
                    if (skuShelfReqDto.getCashIntegral() == null) {
                        BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.NOT_EMPTY_INT);
                    }
                    if (itemOnShelfReqDto.getCashType().equals(2) && skuShelfReqDto.getCashAmount() == null) {
                        BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.NOT_EMPTY_INT_AMOUNNT);
                    }
                }
                if ((skuShelfReqDto.getPrice() == null || BigDecimal.ZERO.compareTo(skuShelfReqDto.getPrice()) > -1) && itemOnShelfReqDto.getBusType() != ItemBusTypeEnum.INTEGRAL.getType()) {
                    throw new BizException("\u4ef7\u683c\u9700\u5927\u4e8e0");
                }
                if (itemOnShelfReqDto.getBusType() == ItemBusTypeEnum.INTEGRAL.getType()) {
                    skuShelfReqDto.setPrice(skuShelfReqDto.getCashAmount());
                }
                if (skuShelfReqDto.getStorage() == null || skuShelfReqDto.getStorage() <= 0L) {
                    throw new BizException("\u5e93\u5b58\u4e0d\u8db3\u4e0d\u80fd\u4e0a\u67b6");
                }
                if (infoRespDto != null) {
                    DistributionSetReqDto distributionSet = skuShelfReqDto.getDistributionSet();
                    if (infoRespDto.getIsPriceDistribution() != null && 1 == infoRespDto.getIsPriceDistribution() && infoRespDto.getIsDistributor() != null && 1 == infoRespDto.getIsDistributor()) {
                        logger.info("\u52a0\u4ef7\u5206\u9500\u5546\u54c1\u5206\u9500\u8bbe\u7f6e\u521d\u59cb\u5316");
                        if (distributionSet == null) {
                            distributionSet = new DistributionSetReqDto();
                            distributionSet.setShopId(itemOnShelfReqDto.getShopId());
                            distributionSet.setItemId(skuShelfReqDto.getItemId());
                            distributionSet.setSkuId(skuShelfReqDto.getSkuId());
                            distributionSet.setFirstLevelAmount(BigDecimal.valueOf(infoRespDto.getLimitPriceBottom() == null ? 0.0 : infoRespDto.getLimitPriceBottom()));
                            distributionSet.setSecondLevelAmount(BigDecimal.valueOf(infoRespDto.getLimitPriceTop() == null ? 0.0 : infoRespDto.getLimitPriceTop()));
                            distributionSet.setValueType(infoRespDto.getPriceDistributionType());
                        }
                        distributionSet.setSetType(Integer.valueOf(3));
                        Integer n = infoRespDto.getPriceDistributionType();
                    }
                    skuShelfReqDto.setAddPriceMode(infoRespDto.getPriceDistributionType());
                    skuShelfReqDto.setAddPriceStatus(infoRespDto.getIsPriceDistribution());
                    skuShelfReqDto.setDistributionSet(distributionSet);
                }
            });
            if (null == itemOnShelfReqDto.getShopId()) {
                throw new BizException("\u4e0a\u67b6\u5e97\u94fa\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean initDataItem = itemOnShelfReqDto.getInitDataItem();
            ShopBaseDto shopBaseDto = null;
            if (shopMap.containsKey(shopId)) {
                shopBaseDto = (ShopBaseDto)shopMap.get(shopId);
            } else {
                shopBaseDto = (ShopBaseDto)this.shopQueryApi.queryBaseById(itemOnShelfReqDto.getShopId()).getData();
                shopMap.put(shopId, shopBaseDto);
            }
            if (null == shopBaseDto) {
                throw new BizException("\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            if (!initDataItem && !"NORMAL".equals(shopBaseDto.getStatus())) {
                throw new BizException("\u975e\u542f\u7528\u4e2d\u7684\u5e97\u94fa\u4e0d\u80fd\u4e0a\u67b6");
            }
        });
    }

    static {
        DEF_CNCY_CONTEXT_KEYS.add("yes.req.tenantId");
        DEF_CNCY_CONTEXT_KEYS.add("yes.req.instanceId");
        DEF_CNCY_CONTEXT_KEYS.add("yes.req.applicationId");
        DEF_CNCY_CONTEXT_KEYS.add("yes.req.userId");
    }
}

