/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.core.util.HttpUtils;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.module.item.api.dto.AccessTokenRespDto;
import com.dtyunxi.yundt.module.item.api.dto.HttpResponseDto;
import com.dtyunxi.yundt.module.item.api.dto.JXCDto;
import com.dtyunxi.yundt.module.item.biz.config.JxcCloudConfig;
import com.dtyunxi.yundt.module.item.biz.util.HttpUtil;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JxcService {
    private static Logger logger = LoggerFactory.getLogger(JxcService.class);
    @Resource
    private JxcCloudConfig jxcCloudConfig;
    @Resource
    private HttpUtil httpUtil;
    @Resource
    private ICacheService cacheService;
    private static final String JXC_ACCESS_TOKEN = "JXC_ACCESS_TOKEN";

    public void synBindTenantMaterial(JXCDto jxcDto) {
        logger.info("\u540c\u6b65\u7269\u6599\u81f3\u8fdb\u9500\u5b58\u53c2\u6570\uff1ajxcDto = {}", (Object)JSONObject.toJSONString((Object)jxcDto));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("access_token", this.getToken());
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("extTenantId", jxcDto.getExtTenantId());
        jsonMap.put("itemList", jxcDto.getItemList());
        HttpResponseDto rest = this.httpUtil.httpPost(this.jxcCloudConfig.getUrl(this.jxcCloudConfig.getSynBindTenantMaterial()), params, jsonMap, HttpResponseDto.class);
        logger.info("\u8bf7\u6c42\u8425\u9500\u4e91\u670d\u52a1\uff0c\u6839\u636e\u7ecf\u9500\u5546\u83b7\u53d6\u79df\u6237\u4e0e\u4ed3\u5e93\u5173\u8054\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)rest));
        if (ObjectUtils.isEmpty((Object)rest)) {
            throw new BizException("\u540c\u6b65\u5230\u8fdb\u9500\u5b58\u5931\u8d25");
        }
        if (!"0".equals(rest.getErrorCode())) {
            throw new BizException("\u540c\u6b65\u5230\u8fdb\u9500\u5b58\u5931\u8d25");
        }
    }

    public String getToken() {
        String cacheToken = (String)this.cacheService.getCache(JXC_ACCESS_TOKEN, String.class);
        if (StringUtils.isNotEmpty((CharSequence)cacheToken)) {
            return cacheToken;
        }
        String url = this.jxcCloudConfig.getUrl(this.jxcCloudConfig.getAccessTokenRest() + "?appId=" + this.jxcCloudConfig.getAppId() + "&appSecret=" + this.jxcCloudConfig.getAppSecret());
        logger.info(url);
        String result = HttpUtils.get((String)url);
        logger.info("\u8bf7\u6c42\u8425\u9500\u4e91\u670d\u52a1\uff0c\u83b7\u53d6token\uff1a{}, {}", (Object)url, (Object)JSONObject.toJSONString((Object)result));
        if (ObjectUtils.isNotEmpty((Object)result)) {
            HttpResponseDto rest = (HttpResponseDto)JSONObject.parseObject((String)result, HttpResponseDto.class);
            Assert.isTrue((boolean)rest.getErrorCode().equals("00"), (String)rest.getErrorCode(), (String)rest.getErrorMessage());
            AccessTokenRespDto dto = (AccessTokenRespDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)rest.getReturnObject()), AccessTokenRespDto.class);
            cacheToken = dto.getAccess_token();
            Date expiredTime = DateUtil.parse((String)dto.getExpiredTime(), (String)"yyyy-MM-dd HH:mm:ss");
            Long seconds = (expiredTime.getTime() - System.currentTimeMillis()) / 1000L;
            this.cacheService.setCache(JXC_ACCESS_TOKEN, (Object)cacheToken, seconds.intValue());
            return cacheToken;
        }
        return null;
    }

    public static void main(String[] args) {
        String url = "http://uat-tcbjjxc.by-health.com/ESBServer/sysApi/appAuthenticate?appId=dsspda001&appSecret=123dss890";
        String result = HttpUtils.get((String)url);
        JSONObject.toJSONString((Object)result);
    }
}

