/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaGroupQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IManagementBlockQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ManagementBlockReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMgmtBlockRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ManagementBlockRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.item.api.IManagementBlockService;
import com.dtyunxi.yundt.module.item.api.dto.response.customer.CustomerListRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class IManagementBlockServiceImpl
implements IManagementBlockService {
    private static final Logger logger = LoggerFactory.getLogger(IManagementBlockServiceImpl.class);
    @Resource
    private IManagementBlockQueryApi iManagementBlockQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IManagementBlockQueryApi iManagementBlockService;
    @Resource
    private ICustomerTypeQueryApi iCustomerTypeQueryApi;
    @Resource
    private ICustomerQueryApi iCustomerQueryApi;
    @Resource
    private IAreaGroupQueryApi iAreaGroupQueryApi;
    @Resource
    private IItemQueryApi iItemQueryApi;

    public PageInfo<ManagementBlockRespDto> pageManagementBlock(ManagementBlockReqDto managementBlockReqDto, Integer pageNum, Integer pageSize) {
        RestResponse customerRespDtoRestResponse;
        RestResponse customerTypeRespDtoRestResponse;
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        PageInfo result = new PageInfo();
        managementBlockReqDto.setInstanceId(instanceId);
        managementBlockReqDto.setTenantId(tenantId);
        managementBlockReqDto.setPageNum(pageNum);
        managementBlockReqDto.setPageSize(pageSize);
        RestResponse pageInfo = this.iManagementBlockService.pageManagementBlock(managementBlockReqDto);
        if (null == pageInfo || pageInfo.getData() == null || CollectionUtils.isEmpty((Collection)((PageInfo)pageInfo.getData()).getList())) {
            return result;
        }
        List list = ((PageInfo)pageInfo.getData()).getList();
        List<Object> areaCodeList = new ArrayList();
        List<Object> customerTypeIds = new ArrayList();
        List<Object> customerIds = new ArrayList();
        for (ManagementBlockRespDto dto : list) {
            if (CollectionUtils.isNotEmpty((Collection)dto.getAreaCodes())) {
                areaCodeList.addAll(dto.getAreaCodes());
            }
            if (CollectionUtils.isNotEmpty((Collection)dto.getCustomerTypeIds())) {
                customerTypeIds.addAll(dto.getCustomerTypeIds());
            }
            if (!CollectionUtils.isNotEmpty((Collection)dto.getCustomerIds())) continue;
            customerIds.addAll(dto.getCustomerIds());
        }
        List areaCodeDtos = new ArrayList();
        if ((areaCodeList = areaCodeList.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o)).distinct().collect(Collectors.toList())).size() > 0) {
            String[] areaCodes = new String[areaCodeList.size()];
            for (int i = 0; i < areaCodeList.size(); ++i) {
                areaCodes[i] = (String)areaCodeList.get(i);
            }
            ArrayList sqlFilterList = Lists.newArrayList();
            sqlFilterList.add(SqlFilter.in((String)"code", (Object)StringUtils.join(areaCodeList, (String)",")));
            HashMap<String, Serializable> filterMap = new HashMap<String, Serializable>();
            filterMap.put("sqlFilters", sqlFilterList);
            filterMap.put("tenantId", tenantId);
            filterMap.put("instanceId", instanceId);
            RestResponse areaGroupRestResp = this.iAreaGroupQueryApi.queryByPage(JSONObject.toJSONString(filterMap), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
            PageInfo areaGroupPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)areaGroupRestResp);
            if (Objects.nonNull(areaGroupPageInfo)) {
                areaCodeDtos = areaGroupPageInfo.getList();
            }
        }
        ArrayList customerTypeDtos = new ArrayList();
        if ((customerTypeIds = customerTypeIds.stream().filter(o -> o != null).distinct().collect(Collectors.toList())).size() > 0 && (customerTypeRespDtoRestResponse = this.iCustomerTypeQueryApi.queryListByIds(customerTypeIds)) != null && CollectionUtils.isNotEmpty((Collection)((Collection)customerTypeRespDtoRestResponse.getData()))) {
            customerTypeDtos.addAll((Collection)customerTypeRespDtoRestResponse.getData());
        }
        ArrayList customerDtos = new ArrayList();
        if ((customerIds = customerIds.stream().filter(o -> o != null).distinct().collect(Collectors.toList())).size() > 0 && (customerRespDtoRestResponse = this.iCustomerQueryApi.queryListByIds(customerIds)) != null && CollectionUtils.isNotEmpty((Collection)((Collection)customerRespDtoRestResponse.getData()))) {
            customerDtos.addAll((Collection)customerRespDtoRestResponse.getData());
        }
        for (ManagementBlockRespDto managementBlockRespDto : list) {
            if (null != managementBlockRespDto.getIsAllArea() && managementBlockRespDto.getIsAllArea() == 1) {
                managementBlockRespDto.setAreaStrings(new ArrayList<String>(Collections.singleton("\u6240\u6709\u533a\u57df")));
            } else if (CollectionUtils.isNotEmpty((Collection)managementBlockRespDto.getAreaCodes())) {
                List areaStrings = areaCodeDtos.stream().filter(o -> managementBlockRespDto.getAreaCodes().contains(o.getCode())).map(o -> o.getName()).collect(Collectors.toList());
                managementBlockRespDto.setAreaStrings(areaStrings.subList(0, Math.min(areaStrings.size(), 3)));
            }
            if (null != managementBlockRespDto.getIsAllCustomerType() && 1 == managementBlockRespDto.getIsAllCustomerType()) {
                managementBlockRespDto.setCustomerTypeStrings(new ArrayList<String>(Collections.singleton("\u6240\u6709\u5ba2\u6237\u7c7b\u578b")));
            } else if (CollectionUtils.isNotEmpty((Collection)managementBlockRespDto.getCustomerTypeIds())) {
                List customerTypes = customerTypeDtos.stream().filter(o -> managementBlockRespDto.getCustomerTypeIds().contains(o.getId())).map(o -> o.getName()).collect(Collectors.toList());
                managementBlockRespDto.setCustomerTypeStrings(customerTypes.subList(0, Math.min(customerTypes.size(), 3)));
            }
            if (!CollectionUtils.isNotEmpty((Collection)managementBlockRespDto.getCustomerIds())) continue;
            List customers = customerDtos.stream().filter(o -> managementBlockRespDto.getCustomerIds().contains(o.getId())).map(o -> o.getName()).collect(Collectors.toList());
            managementBlockRespDto.setCustomerStrings(customers.subList(0, Math.min(customers.size(), 3)));
        }
        BeanUtils.copyProperties((Object)pageInfo, (Object)result);
        CubeBeanUtils.copyProperties((Object)result, (Object)pageInfo.getData(), (String[])new String[]{"list", "navigatepageNums"});
        result.setList(list);
        return result;
    }

    public PageInfo<CustomerListRespDto> queryCustomerByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (CustomerSearchReqDto)JSONObject.parseObject((String)filter, CustomerSearchReqDto.class);
        }
        searchReqDto.setTenantId(this.context.tenantId());
        RestResponse pageInfoRestResponse = this.iCustomerQueryApi.queryByPage(JSON.toJSONString((Object)searchReqDto), pageNum, pageSize);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        PageInfo listRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)listRespDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList listRespDtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            HashSet regionCodeList = Sets.newHashSet();
            for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                CustomerListRespDto listRespDto = new CustomerListRespDto();
                CubeBeanUtils.copyProperties((Object)listRespDto, (Object)customerRespDto, (String[])new String[0]);
                listRespDtoList.add(listRespDto);
                if (!StringUtils.isNotEmpty((CharSequence)customerRespDto.getRegionCode())) continue;
                regionCodeList.add(customerRespDto.getRegionCode());
            }
            Map<Object, Object> regionNameMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)regionCodeList)) {
                ArrayList sqlFilterList = Lists.newArrayList();
                sqlFilterList.add(SqlFilter.in((String)"code", (Object)StringUtils.join((Iterable)regionCodeList, (String)",")));
                HashMap<String, Serializable> filterMap = new HashMap<String, Serializable>();
                filterMap.put("sqlFilters", sqlFilterList);
                filterMap.put("tenantId", searchReqDto.getTenantId());
                filterMap.put("instanceId", searchReqDto.getInstanceId());
                RestResponse areaGroupRestResp = this.iAreaGroupQueryApi.queryByPage(JSONObject.toJSONString(filterMap), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
                PageInfo areaGroupPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)areaGroupRestResp);
                if (Objects.nonNull(areaGroupPageInfo)) {
                    regionNameMap = areaGroupPageInfo.getList().stream().collect(Collectors.toMap(AreaGroupRespDto::getCode, AreaGroupRespDto::getName));
                }
            }
            for (CustomerListRespDto respDto : listRespDtoList) {
                if (!StringUtils.isNotEmpty((CharSequence)respDto.getRegionCode())) continue;
                respDto.setRegion((String)regionNameMap.get(respDto.getRegionCode()));
            }
        }
        listRespDtoPageInfo.setList((List)listRespDtoList);
        return listRespDtoPageInfo;
    }

    public List<ItemMgmtBlockRespDto> queryItemMgmtBlockList(Long itemId) {
        RestResponse listRestResponse = this.iManagementBlockQueryApi.queryItemMgmtBlockList(itemId);
        List itemMgmtBlockRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        if (CollectionUtils.isEmpty((Collection)itemMgmtBlockRespDtos)) {
            return itemMgmtBlockRespDtos;
        }
        for (ItemMgmtBlockRespDto itemMgmtBlockRespDto : itemMgmtBlockRespDtos) {
            ArrayList collectCustomerType = CollectionUtils.isNotEmpty((Collection)itemMgmtBlockRespDto.getCustomerTypeIds()) ? ((List)RestResponseHelper.extractData((RestResponse)this.iCustomerTypeQueryApi.queryListByIds(itemMgmtBlockRespDto.getCustomerTypeIds()))).stream().map(CustomerNameSimpleRespDto::getName).collect(Collectors.toList()) : new ArrayList();
            itemMgmtBlockRespDto.setCustomerTypes(collectCustomerType);
            ArrayList collectCustomer = CollectionUtils.isNotEmpty((Collection)itemMgmtBlockRespDto.getCustomerIds()) ? ((List)RestResponseHelper.extractData((RestResponse)this.iCustomerQueryApi.queryListByIds(itemMgmtBlockRespDto.getCustomerIds()))).stream().map(CustomerNameSimpleRespDto::getName).collect(Collectors.toList()) : new ArrayList();
            itemMgmtBlockRespDto.setCustomers(collectCustomer);
            List<String> codes = this.getAreaCodeStrings(itemMgmtBlockRespDto);
            itemMgmtBlockRespDto.setAreaCodes(codes);
        }
        return itemMgmtBlockRespDtos;
    }

    private List<String> getAreaCodeStrings(ItemMgmtBlockRespDto itemMgmtBlockRespDto) {
        List<String> codes = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)itemMgmtBlockRespDto.getAreaCodes())) {
            ArrayList sqlFilterList = Lists.newArrayList();
            sqlFilterList.add(SqlFilter.in((String)"code", (Object)itemMgmtBlockRespDto.getAreaCodes()));
            HashMap<String, Serializable> filterMap = new HashMap<String, Serializable>();
            filterMap.put("sqlFilters", sqlFilterList);
            filterMap.put("tenantId", this.context.tenantId());
            filterMap.put("instanceId", this.context.instanceId());
            RestResponse areaGroupRestResp = this.iAreaGroupQueryApi.queryByPage(JSONObject.toJSONString(filterMap), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
            PageInfo areaGroupPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)areaGroupRestResp);
            if (Objects.nonNull(areaGroupPageInfo)) {
                codes = areaGroupPageInfo.getList().stream().map(AreaGroupRespDto::getName).collect(Collectors.toList());
            }
        }
        return codes;
    }
}

