/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityPriceDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityPriceQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityDimensionEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IItemActivityPriceQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IItemActivityTagQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponCategoryEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponTemplateExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponTypeEnum;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.condition.Criteria;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.item.api.constants.GroupActivityConstant;
import com.dtyunxi.yundt.module.item.api.dto.ShopItemDto;
import com.dtyunxi.yundt.module.item.api.dto.response.marketing.BaseActivityDto;
import com.dtyunxi.yundt.module.item.api.dto.response.marketing.CouponTemplate;
import com.dtyunxi.yundt.module.item.api.dto.response.marketing.ItemActivityInfoRespDto;
import com.dtyunxi.yundt.module.item.api.dto.response.marketing.ItemForActivityInfoRespDto;
import com.dtyunxi.yundt.module.item.biz.impl.serializa.SerializeCouPonUseTimeValueDistributeExtItem;
import com.dtyunxi.yundt.module.item.biz.service.IItemActivityService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemActivityServiceImpl
implements IItemActivityService {
    private static final Logger logger = LoggerFactory.getLogger(ItemActivityServiceImpl.class);
    @Autowired
    private IActivityQueryApi activityQueryApi;
    @Resource
    private IItemActivityTagQueryApi itemActivityTagQueryApi;
    @Resource
    private ICouponTemplateExtQueryApi couponTemplateExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IItemActivityPriceQueryApi itemActivityPriceQueryApi;

    @Override
    public ItemForActivityInfoRespDto queryActivityByItemId(Long itemId, Long shopId) {
        ItemForActivityInfoRespDto itemForActivityInfo = new ItemForActivityInfoRespDto();
        itemForActivityInfo.setSystemTime(System.currentTimeMillis());
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setPreheatStartTime(new Date());
        queryReqDto.setItemId(itemId);
        queryReqDto.setShopId(shopId);
        queryReqDto.setDimensionList((List)Lists.newArrayList((Object[])new Integer[]{ActivityDimensionEnum.COUPON.getKey(), ActivityDimensionEnum.ORDER.getKey(), ActivityDimensionEnum.ITEM.getKey()}));
        queryReqDto.setDisplay(Integer.valueOf(1));
        List itemActivityTagDtos = (List)this.itemActivityTagQueryApi.queryList(queryReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)itemActivityTagDtos)) {
            return itemForActivityInfo;
        }
        List<Long> activityIds = itemActivityTagDtos.stream().map(ItemActivityTagDto::getActivityId).collect(Collectors.toList());
        Map<Long, ActivityRespDto> activityMap = this.queryByIds(activityIds);
        Map<Integer, List<ItemActivityInfoRespDto>> group = itemActivityTagDtos.stream().filter(dto -> activityMap.containsKey(dto.getActivityId())).map(dto -> this.convertToItemActivityInfoRespDto(activityMap, (ItemActivityTagDto)dto)).collect(Collectors.groupingBy(ItemActivityInfoRespDto::getDimension));
        for (Integer dimension : group.keySet()) {
            List<ItemActivityInfoRespDto> activityInfoRespDtos = group.get(dimension);
            if (ActivityDimensionEnum.COUPON.getKey().equals(dimension)) {
                List<ItemActivityInfoRespDto> couponActivityList = this.getCouponActivityInfoRespDtos(activityInfoRespDtos);
                itemForActivityInfo.setCouponActivityInfo(couponActivityList);
                continue;
            }
            if (ActivityDimensionEnum.ORDER.getKey().equals(dimension)) {
                itemForActivityInfo.setOrderActivityInfo(activityInfoRespDtos);
                continue;
            }
            if (!ActivityDimensionEnum.ITEM.getKey().equals(dimension)) continue;
            itemForActivityInfo.setItemActivityInfo(activityInfoRespDtos);
        }
        return itemForActivityInfo;
    }

    private Map<Long, ActivityRespDto> queryByIds(List<Long> ids) {
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityIds(ids);
        List activityRespDtos = (List)this.activityQueryApi.queryActivityList(activityDto).getData();
        if (CollectionUtils.isEmpty((Collection)activityRespDtos)) {
            return Collections.emptyMap();
        }
        return activityRespDtos.stream().collect(Collectors.toMap(ActivityRespDto::getId, e -> e, (e1, e2) -> e1));
    }

    private List<ItemActivityInfoRespDto> getCouponActivityInfoRespDtos(List<ItemActivityInfoRespDto> activityInfoRespDtos) {
        List<Long> activityIds = activityInfoRespDtos.stream().map(BaseActivityDto::getId).collect(Collectors.toList());
        List<CouponTemplate> templates = this.queryByActivityIds(activityIds);
        Map<Long, CouponTemplate> templateMap = templates.stream().collect(Collectors.toMap(CouponTemplate::getActivityId, e -> e, (e1, e2) -> e1));
        ArrayList activityList = Lists.newArrayList();
        activityInfoRespDtos.forEach(activityInfoDto -> {
            if (templateMap.containsKey(activityInfoDto.getId())) {
                CouponTemplate couponTemplate = (CouponTemplate)templateMap.get(activityInfoDto.getId());
                couponTemplate.setTag(activityInfoDto.getTag());
                activityInfoDto.setCouponTemplate(couponTemplate);
                activityList.add(activityInfoDto);
            }
        });
        return activityList;
    }

    private ItemActivityInfoRespDto convertToItemActivityInfoRespDto(Map<Long, ActivityRespDto> activityMap, ItemActivityTagDto itemActivityTagDto) {
        ItemActivityInfoRespDto activityInfo = new ItemActivityInfoRespDto();
        activityInfo.setId(itemActivityTagDto.getActivityId());
        activityInfo.setDimension(itemActivityTagDto.getDimension());
        activityInfo.setTag(itemActivityTagDto.getActivityTag());
        activityInfo.setBeginTime(itemActivityTagDto.getPreheatStartTime());
        activityInfo.setEndTime(itemActivityTagDto.getEndTime());
        if (activityMap.containsKey(itemActivityTagDto.getActivityId())) {
            CubeBeanUtils.copyProperties((Object)activityInfo, (Object)activityMap.get(itemActivityTagDto.getActivityId()), (String[])new String[0]);
        }
        return activityInfo;
    }

    @Override
    public PageInfo<ActivityRespDto> queryActivityPage(ActivityDto queryDto, Integer pageNum, Integer pageSize) {
        queryDto.setAuditStatusEnum(AuditStatusEnum.AUDIT_PASS);
        queryDto.setActivityStatus((List)Lists.newArrayList((Object[])new String[]{ActivityStatusEnum.READY.getKey(), ActivityStatusEnum.ACTIVATE.getKey()}));
        return (PageInfo)this.activityQueryApi.queryActivityPage(queryDto, pageNum, pageSize).getData();
    }

    @Override
    public List<CouponTemplate> queryByActivityIds(List<Long> activityIds) {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.ge((String)"receive_end_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)new Date())));
        sqlFilterList.add(SqlFilter.in((String)"activityId", activityIds));
        sqlFilterList.add(SqlFilter.eq((String)"coupon_type", (Object)CouponTypeEnum.COUPON.getType()));
        sqlFilterList.add(SqlFilter.eq((String)"coupon_template_status", (Object)CouponTemplateStatusEnum.ACTIVATE.getStatus()));
        sqlFilterList.add(SqlFilter.in((String)"coupon_category", (Object)Lists.newArrayList((Object[])new Integer[]{CouponCategoryEnum.QUOTA_CASH.getCategory(), CouponCategoryEnum.DISCOUNT.getCategory()})));
        Criteria criteria = new Criteria();
        criteria.setFilters(sqlFilterList);
        criteria.setInstanceId(this.context.instanceId());
        criteria.setTenantId(this.context.tenantId());
        PageInfo couponTpPage = (PageInfo)this.couponTemplateExtQueryApi.queryByPage(JSON.toJSONString((Object)criteria), Integer.valueOf(1), Integer.valueOf(activityIds.size())).getData();
        PageInfo<CouponTemplate> pageInfo = this.convertToCouponTemplatePage((PageInfo<CouponTemplateExtRespDto>)couponTpPage);
        return pageInfo.getList();
    }

    private PageInfo<CouponTemplate> convertToCouponTemplatePage(PageInfo<CouponTemplateExtRespDto> couponTemplatePage) {
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties(couponTemplatePage, (Object)pageInfo);
        CouponTemplate couponTemplate = null;
        ArrayList<CouponTemplate> couponTemplateList = new ArrayList<CouponTemplate>();
        if (CollectionUtils.isNotEmpty((Collection)couponTemplatePage.getList())) {
            for (CouponTemplateExtRespDto templateExtRespDto : couponTemplatePage.getList()) {
                couponTemplate = new CouponTemplate();
                CubeBeanUtils.copyProperties((Object)couponTemplate, (Object)templateExtRespDto, (String[])new String[0]);
                couponTemplate.setCouponUseBeginTime(templateExtRespDto.getEffectiveTime());
                couponTemplate.setCouponUseEndTime(templateExtRespDto.getInvalidTime());
                SerializeCouPonUseTimeValueDistributeExtItem.deserialization(couponTemplate);
                couponTemplateList.add(couponTemplate);
            }
        }
        pageInfo.setList(couponTemplateList);
        return pageInfo;
    }

    @Override
    public List<Long> queryByCouponTpId(Long couponTpId) {
        CouponTemplateExtRespDto couponTemplate = null;
        try {
            couponTemplate = (CouponTemplateExtRespDto)this.couponTemplateExtQueryApi.queryById(couponTpId).getData();
        }
        catch (Exception e) {
            logger.error("couponTemplateExtQueryApi.queryById\u67e5\u8be2\u4f18\u60e0\u5238\u6a21\u677f\u5f02\u5e38", (Object)e.getMessage());
        }
        if (null == couponTemplate) {
            return Collections.EMPTY_LIST;
        }
        return this.queryByActivityId(couponTemplate.getActivityId());
    }

    @Override
    public List<Long> queryByActivityId(Long activityId) {
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setActivityId(activityId);
        List itemActivityTagDtos = (List)this.itemActivityTagQueryApi.queryList(queryReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)itemActivityTagDtos)) {
            return Collections.EMPTY_LIST;
        }
        return itemActivityTagDtos.stream().map(ItemActivityTagDto::getItemId).collect(Collectors.toList());
    }

    @Override
    public Long queryActivityId(Long couponTpId) {
        try {
            CouponTemplateExtRespDto couponTemplate = (CouponTemplateExtRespDto)this.couponTemplateExtQueryApi.queryById(couponTpId).getData();
            return couponTemplate.getActivityId();
        }
        catch (Exception e) {
            logger.error("couponTemplateExtQueryApi.queryById\u67e5\u8be2\u4f18\u60e0\u5238\u6a21\u677f\u5f02\u5e38", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public Long getSellerId(Long activityId, Long couponTpId) {
        try {
            if (null != couponTpId) {
                activityId = this.queryActivityId(couponTpId);
            }
            if (null != activityId) {
                ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityDetail(activityId.longValue()).getData();
                return activityRespDto.getSellerId();
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6d3b\u52a8\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    @Override
    public Integer getGroupNumber(ActivityRespDto activityRespDto) {
        List conditions = activityRespDto.getConditionDtos();
        if (CollectionUtils.isNotEmpty((Collection)conditions)) {
            for (ConditionRespDto condition : conditions) {
                if (!GroupActivityConstant.CONDITION_GROUP_NUMBER_TP_ID.equals(condition.getConditionTemplateId())) continue;
                JSONObject jsonObject = JSON.parseObject((String)condition.getConditionParams());
                if (null == jsonObject) break;
                return jsonObject.getInteger("GroupNumberCondition.number");
            }
        }
        return null;
    }

    @Override
    public Map<String, List<ItemActivityTagDto>> queryItemActivityTags(ItemActivityTagQueryReqDto queryReqDto) {
        queryReqDto.setInstanceId(this.context.instanceId());
        queryReqDto.setTenantId(this.context.tenantId());
        queryReqDto.setPreheatStartTime(new Date());
        List list = (List)this.itemActivityTagQueryApi.queryList(queryReqDto).getData();
        Map<String, List<ItemActivityTagDto>> itemTagsMap = list.stream().collect(Collectors.groupingBy(tagDto -> tagDto.getShopId() + tagDto.getItemId().toString()));
        return itemTagsMap;
    }

    @Override
    public List<ShopItemDto> queryShopItems(Long activityId, Long couponTpId) {
        if (null != couponTpId) {
            activityId = this.queryActivityId(couponTpId);
        }
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setActivityId(activityId);
        List itemActivityTagDtos = (List)this.itemActivityTagQueryApi.queryList(queryReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)itemActivityTagDtos)) {
            return Collections.EMPTY_LIST;
        }
        return itemActivityTagDtos.stream().map(tagDto -> new ShopItemDto(tagDto.getShopId(), tagDto.getItemId())).collect(Collectors.toList());
    }

    @Override
    public Map<String, List<ItemActivityPriceDto>> queryItemActivityPriceDtos(ItemActivityPriceQueryReqDto queryReqDto) {
        List priceDtos = (List)this.itemActivityPriceQueryApi.queryList(queryReqDto).getData();
        Map<String, List<ItemActivityPriceDto>> priceMap = priceDtos.stream().collect(Collectors.groupingBy(priceDto -> priceDto.getShopId() + priceDto.getItemId().toString()));
        return priceMap;
    }
}

