/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.jobs.tasks;

import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.tcbj.biz.service.ICiticService;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="accTransDetailSync")
@Scope(value="prototype")
public class CiticAccountTransDetailSyncJob
extends SingleTupleScheduleEvent {
    Logger log = LoggerFactory.getLogger(CiticAccountTransDetailSyncJob.class);
    DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    @Resource
    private ICiticService citicService;

    public void syncAccountTransDetail() {
        long startTime = System.currentTimeMillis();
        this.log.info("\u5f00\u59cb\u6267\u884c\u767b\u8bb0\u7c3f\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u540c\u6b65\u4efb\u52a1,\u5f00\u59cb\u65f6\u95f4:{}", (Object)startTime);
        int exeDays = 5;
        for (int i = 0; i <= exeDays; ++i) {
            LocalDate localDate = LocalDate.now().minusDays(i);
            String date = this.dateFormatter.format(localDate);
            this.citicService.generateAccountTransDetail(date);
        }
        long endTime = System.currentTimeMillis();
        this.log.info("\u6267\u884c\u767b\u8bb0\u7c3f\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u540c\u6b65\u4efb\u52a1\u7ed3\u675f,\u8017\u65f6:{} ms", (Object)(endTime - startTime));
    }

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        this.syncAccountTransDetail();
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }
}

