/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.jobs.tasks;

import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.tcbj.biz.service.ICiticService;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="bankCodeSync")
@Scope(value="prototype")
public class CiticBankSyncJob
extends SingleTupleScheduleEvent {
    Logger log = LoggerFactory.getLogger(CiticBankSyncJob.class);
    @Resource
    private ICiticService citicService;
    DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");

    public void syncCiticBankCode() {
        long startTime = System.currentTimeMillis();
        this.log.info("\u5f00\u59cb\u6267\u884c\u4eba\u884c\u8054\u884c\u53f7\u5b9a\u65f6\u540c\u6b65\u4efb\u52a1,\u5f00\u59cb\u65f6\u95f4:{}", (Object)startTime);
        this.citicService.generateBankCode(this.dateFormatter.format(LocalDate.now().minusDays(1L)));
        long endTime = System.currentTimeMillis();
        this.log.info("\u6267\u884c\u4eba\u884c\u8054\u884c\u53f7\u5b9a\u65f6\u540c\u6b65\u4efb\u52a1\u7ed3\u675f,\u8017\u65f6:{} ms", (Object)(endTime - startTime));
    }

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        this.syncCiticBankCode();
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }
}

