package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InventoryOperateLogReqDto;
import com.dtyunxi.tcbj.api.dto.response.InventoryOperateLogRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 库存操作流水表
*
* @author wude
* @since 2022-03-11
*/
@Api(tags = {"库存操作流水表"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/inventoryOperateLog", url = "${tcbj.center.report.api:}")
public interface IInventoryOperateLogQueryApi {

    /**
    * 根据id查询库存操作流水表，如果一次库存操作中变动了N个库存字段，则会存入N条对应记录
    *
    * @param id 库存操作流水表，如果一次库存操作中变动了N个库存字段，则会存入N条对应记录id
    * @return   库存操作流水表，如果一次库存操作中变动了N个库存字段，则会存入N条对应记录数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询库存操作流水表，如果一次库存操作中变动了N个库存字段，则会存入N条对应记录", notes = "根据id查询库存操作流水表，如果一次库存操作中变动了N个库存字段，则会存入N条对应记录")
    RestResponse<InventoryOperateLogRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 库存操作流水分页查询
    *
    * @param filter   库存操作流水表，如果一次库存操作中变动了N个库存字段，则会存入N条对应记录查询条件
    * @return 库存操作流水
    */
    @PostMapping("/page")
    @ApiOperation(value = "库存操作流水分页查询", notes = "根据filter查询条件查询库存操作流水表，filter=InventoryOperateLogReqDto")
    RestResponse<PageInfo<InventoryOperateLogRespDto>> queryByPage(@RequestBody InventoryOperateLogReqDto filter);

}
