package com.dtyunxi.tcbj.api.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @description:
 * @author: yuangui
 * @date: 2022-03-18 10:34
 */
@Data
public class PCPCustomAreaRespDto {
    /**
     *  主键id
     */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
     *  顶级id,第一层的顶级id为主键id，其他层级的为第一层的主键id。使用场景，如查询广东区下的所有区域，则根据广东区该条数据的topId和level，直接限制top_id=顶级id and level>等级
     */
    @ApiModelProperty(name = "topId", value = "顶级id,第一层的顶级id为主键id，其他层级的为第一层的主键id。使用场景，如查询广东区下的所有区域，则根据广东区该条数据的topId和level，直接限制top_id=顶级id and level>等级")
    private Long topId;
    /**
     *  编码(全局唯一性使用)
     */
    @ApiModelProperty(name = "code", value = "编码(全局唯一性使用)")
    private String code;
    /**
     *  父编码
     */
    @ApiModelProperty(name = "parentCode", value = "父编码")
    private String parentCode;
    /**
     *  区域名称
     */
    @ApiModelProperty(name = "name", value = "区域名称")
    private String name;
    /**
     *  自定义的区域编码(不保证组织下唯一)，预留，暂时没用
     */
    @ApiModelProperty(name = "areaCode", value = "自定义的区域编码(不保证组织下唯一)，预留，暂时没用")
    private String areaCode;
    /**
     *  层级，1-第一层；2-第二层
     */
    @ApiModelProperty(name = "level", value = "层级，1-第一层；2-第二层")
    private Integer level;
    /**
     *  组织ID
     */
    @ApiModelProperty(name = "orgInfoId", value = "组织ID")
    private Long orgInfoId;
    /**
     *  排序值
     */
    @ApiModelProperty(name = "sort", value = "排序值")
    private Integer sort;
    /**
     *  结束时间
     */
    @ApiModelProperty(name = "endDate", value = "结束时间")
    private Date endDate;
}
