package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.TbPersonPartnerRelReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 服务接口
*
* @author ghosn
* @since 2023-04-06
*/
@Api(tags = {"报表中心：业务员服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-api-ITbPersonPartnerRelApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/tbPersonPartnerRel",
    url = "${tcbj.center.report.api:}"
)
public interface ITbPersonPartnerRelApi {

    /**
    * 新增
    *
    * @param addReqDto 请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增", notes = "新增")
    RestResponse<Long> addTbPersonPartnerRel(@RequestBody TbPersonPartnerRelReqDto addReqDto);

    /**
    * 修改
    *
    * @param modifyReqDto 请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> modifyTbPersonPartnerRel(@RequestBody TbPersonPartnerRelReqDto modifyReqDto);

    /**
    * 删除
    *
    * @param ids        删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> removeTbPersonPartnerRel(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
