package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.CustomerCheckRelationSnapshotRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 服务接口
*
* @author ghosn
* @since 2023-04-11
*/
@Api(tags = {"门店考核关系快照服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-api-query-ICustomerCheckRelationSnapshotQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/customerCheckRelationSnapshot",
    url = "${tcbj.center.report.api:}"
)
public interface ICustomerCheckRelationSnapshotQueryApi {

    /**
    * 根据id查询
    *
    * @param id id
    * @return   数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询", notes = "根据id查询")
    RestResponse<CustomerCheckRelationSnapshotRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 分页数据
    *
    * @param filter   查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "分页数据", notes = "根据filter查询条件查询数据，filter=CustomerCheckRelationSnapshotReqDto")
    RestResponse<PageInfo<CustomerCheckRelationSnapshotRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                             @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                             @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
