package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.util.DateUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.util.Date;
import java.util.List;

/**
* Eo对象
*
* @author shuyi
* @since 2022-04-07
*/
@ApiModel(value = "StrategyAutoCheckRuleReportRespDto", description = "Eo对象")
public class StrategyAutoCheckRuleReportRespDto extends BaseRespDto{

    /**
    *  规则名称
    */
    @ApiModelProperty(name = "ruleName", value = "规则名称")
    private String ruleName;
    /**
    *  规则编码
    */
    @ApiModelProperty(name = "ruleCode", value = "规则编码")
    private String ruleCode;
    /**
    *  优先级
    */
    @ApiModelProperty(name = "priority", value = "优先级")
    private Integer priority;
    /**
    *  有效周期 开始时间
    */
    @ApiModelProperty(name = "activeStartTime", value = "有效周期 开始时间")
    private Date activeStartTime;
    /**
    *  结束时间
    */
    @ApiModelProperty(name = "activeEndTime", value = "结束时间")
    private Date activeEndTime;

    /**
     *  1 将失效 2 已失效
     */
    @ApiModelProperty(name = "failStatus", value = "1 将失效 2 已失效")
    private Integer failStatus;
    /**
    *  规则状态 0-已禁用 1-已启用 2-已失效
    */
    @ApiModelProperty(name = "ruleStatus", value = "规则状态 0-已禁用 1-已启用 2-已失效")
    private Integer ruleStatus;

    @ApiModelProperty(name="applyOrderChannels", value = "适用渠道")
    @JsonProperty("applyOrderChannels")
    private List<OrderChannelRespDto> applyOrderChannels;

    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getRuleCode() {
        return ruleCode;
    }

    public void setRuleCode(String ruleCode) {
        this.ruleCode = ruleCode;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Date getActiveStartTime() {
        return activeStartTime;
    }

    public void setActiveStartTime(Date activeStartTime) {
        this.activeStartTime = activeStartTime;
    }

    public Date getActiveEndTime() {
        return activeEndTime;
    }

    public void setActiveEndTime(Date activeEndTime) {
        this.activeEndTime = activeEndTime;
    }

    public Integer getFailStatus() {
        if(this.getActiveEndTime()==null){
            return null;
        }else{
            if(this.getActiveEndTime().before(DateUtil.getSysDate())){
                return 2;
            }else{
                Date currenDate= DateUtil.parse(DateUtil.getCurrenDate()+ " 00:00:00", com.dtyunxi.cube.utils.enums.DatePattern.DATETIME_PATTERN.getPattern());
                String changeDateStr = DateUtil.format(DateUtil.addDay(currenDate, 30), DatePattern.DATETIME_PATTERN.getPattern());
                String endDateStr = DateUtil.format(this.getActiveEndTime(), DatePattern.DATETIME_PATTERN.getPattern());
                //规则有效周期剩余30天，含30天，以当日00:00:00开始计算
                Integer differDay = DateUtil.getDifferDay(changeDateStr, endDateStr);
                System.out.println(differDay);
                if(differDay<=0){
                    //将失效
                    return 1;
                }
            }
            return null;
        }

    }

    public void setFailStatus(Integer failStatus) {
        this.failStatus = failStatus;
    }

    public Integer getRuleStatus() {
        return ruleStatus;
    }

    public void setRuleStatus(Integer ruleStatus) {
        this.ruleStatus = ruleStatus;
    }

    public List<OrderChannelRespDto> getApplyOrderChannels() {
        return applyOrderChannels;
    }

    public void setApplyOrderChannels(List<OrderChannelRespDto> applyOrderChannels) {
        this.applyOrderChannels = applyOrderChannels;
    }
}
