package com.dtyunxi.tcbj.api.dto.response;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
* 应收账款导入，导出dto
*
* @author xiuji
* @since 2022-01-18
*/
@ApiModel(value = "ReceivablesImportDto", description = "应收账款导入，导出dto")
public class ReceivablesImportDto {

    @Excel(name = "客户名称", width = 25,orderNum = "1")
    @ApiModelProperty(name = "customerCode", value = "客户名称")
    private String customerName;

    @Excel(name = "客户编码", width = 25,orderNum = "2")
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;

    @Excel(name = "日期", width = 25,orderNum = "3")
    @ApiModelProperty(name = "dateStr", value = "日期")
    private String dateStr;

    @Excel(name = "期初应收", width = 25,orderNum = "4")
    @ApiModelProperty(name = "dateTime", value = "期初应收")
    private BigDecimal beginningTotalAmount;

    @Excel(name = "期末应收", width = 25,orderNum = "5")
    @ApiModelProperty(name = "dateTime", value = "期末应收")
    private BigDecimal terminalTotalAmount;

    /** 错误原因 **/
    @Excel(name = "错误原因", width = 25,orderNum = "6")
    @ApiModelProperty(name = "errorReason", value = "错误原因")
    private String errorReason;

    private Long orgInfoId;
    private Long customerId;
    private Date dateTime;

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public String getDateStr() {
        return dateStr;
    }

    public void setDateStr(String dateStr) {
        this.dateStr = dateStr;
    }

    public BigDecimal getBeginningTotalAmount() {
        return beginningTotalAmount;
    }

    public void setBeginningTotalAmount(BigDecimal beginningTotalAmount) {
        this.beginningTotalAmount = beginningTotalAmount;
    }

    public BigDecimal getTerminalTotalAmount() {
        return terminalTotalAmount;
    }

    public void setTerminalTotalAmount(BigDecimal terminalTotalAmount) {
        this.terminalTotalAmount = terminalTotalAmount;
    }

    public String getErrorReason() {
        return errorReason;
    }

    public void setErrorReason(String errorReason) {
        this.errorReason = errorReason;
    }

    public Long getOrgInfoId() {
        return orgInfoId;
    }

    public void setOrgInfoId(Long orgInfoId) {
        this.orgInfoId = orgInfoId;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Date getDateTime() {
        return dateTime;
    }

    public void setDateTime(Date dateTime) {
        this.dateTime = dateTime;
    }
}
