package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * @author lishaowu
 * @since 1.0.0
 */
@Api(tags = {"报表中心：客户和人员过期处理任务"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/cusUserExpire",
        url = "${tcbj.center.report.api:}"
)
public interface ICustomerUserExpireDateApi {

    /**
     * 客户和人员过期处理逻辑
     *
     */
    @GetMapping("/expireDate")
    @ApiOperation(value = "客户和人员过期处理逻辑", notes = "客户和人员过期处理逻辑")
    RestResponse<Void> expireDate();
}
