package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CargoOccupyReqDto;
import com.dtyunxi.tcbj.api.dto.response.CargoOccupyRespDto;
import com.dtyunxi.tcbj.api.dto.response.PreemptSourceNoRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 库存查询接口
 *
 * @author shuyi
 * @date : 2021/12/7 10:39
 * @since 1.0.0
 */
@Api(tags = {"报表中心：查询库存信息"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/inventory",
        url = "${tcbj.center.report.api:}"
)
public interface IInventoryReportQueryApi {

    /**
     * 根据商品编码集合查询商品预占信息列表
     * @param reqDto
     * @return
     */
    @PostMapping(value = {"/queryOrderOccupyQuantity"}, produces = "application/json")
    @ApiOperation(value = "根据商品编码集合查询商品预占信息列表", notes = "根据商品编码集合查询商品预占信息列表")
    RestResponse<List<CargoOccupyRespDto>> queryCargoOccupy(@RequestBody CargoOccupyReqDto reqDto);

    /**
     * 根据商品编码集合查询商品预占信息列表
     * @param
     * @return
     */
    @GetMapping(value = {"/queryPreemptSourceNo"}, produces = "application/json")
    @ApiOperation(value = "根据商品编码集合查询商品预占信息列表", notes = "根据商品编码集合查询商品预占信息列表")
    RestResponse<PageInfo<PreemptSourceNoRespDto>> queryPreemptSourceNo(@RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum, @RequestParam(name = "pageSize", defaultValue = "1000") Integer pageSize, @RequestParam(name = "sourceNoList", required = false) List<String> sourceNoList);
}
