package com.dtyunxi.tcbj.api.biz.customer;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.biz.customer.dto.QueryCustomerFullAreaReq;
import com.dtyunxi.tcbj.api.biz.customer.dto.QueryCustomerFullAreaResp;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

// ----------------------------
// Controller 实现 + Feign 实现
@RestController
@RequestMapping("/v1/customer/export")
public class CustomerExport2025Controller implements ICustomerExport2025Api {

    @Resource
    private CustomerExport2025Service customerExport2025Service;

    @Override
    public RestResponse<QueryCustomerFullAreaResp> queryCustomerFullArea(@RequestBody QueryCustomerFullAreaReq queryDto) {
        QueryCustomerFullAreaResp queryCustomerFullAreaResp = customerExport2025Service.queryCustomerFullArea(queryDto);
        return new RestResponse<>(queryCustomerFullAreaResp);
    }
}
