/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.api.biz.promotion;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.tcbj.api.biz.promotion.dto.CustomerInfo;
import com.dtyunxi.tcbj.api.biz.promotion.dto.PromotionActivityQueryDto;
import com.dtyunxi.tcbj.api.biz.promotion.dto.PromotionExportRow;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PromotionExportService {
    private static final Logger log = LoggerFactory.getLogger(PromotionExportService.class);
    private static final String EXCHANGE_CONDITION_TEMPLATE_ID = "1196944771412880296";
    private static final String CUSTOMER_CONDITION_TEMPLATE_ID = "1196944771412880293";
    private static final String PRICE_TYPE_ID = "1";
    @Resource
    private JdbcTemplate jdbcTemplate;

    public List<PromotionExportRow> exportByOrgId(PromotionActivityQueryDto req) {
        String orgId = req.getOrgId();
        log.info("\u5f00\u59cb\u5bfc\u51fa\u4fc3\u9500\u6d3b\u52a8\u6570\u636e\uff08\u7eafJDBC\uff09\uff0corgId={}", (Object)orgId);
        List<ActivityBase> activityBases = this.queryActivityBases(orgId);
        log.info("\u67e5\u8be2\u5230{}\u4e2a\u6d3b\u52a8\uff0c\u5f00\u59cb\u5904\u7406\u5546\u54c1\u6570\u636e", (Object)activityBases.size());
        if (activityBases.isEmpty()) {
            log.info("\u672a\u627e\u5230\u5339\u914d\u7684\u6d3b\u52a8\uff0c\u8fd4\u56de\u7a7a\u5217\u8868");
            return Collections.emptyList();
        }
        ArrayList<PromotionExportRow> allProductRows = new ArrayList<PromotionExportRow>();
        for (ActivityBase activity : activityBases) {
            log.debug("\u5f00\u59cb\u5904\u7406\u6d3b\u52a8\uff1a{} - {}", (Object)activity.getActivityCode(), (Object)activity.getActivityName());
            List<PromotionExportRow> activityProductRows = this.handleActivityProducts(activity);
            log.debug("\u6d3b\u52a8{}\u7684\u6d3b\u52a8\u5546\u54c1\u5904\u7406\u5b8c\u6210\uff0c\u5171{}\u6761", (Object)activity.getActivityCode(), (Object)activityProductRows.size());
            List<PromotionExportRow> exchangeProductRows = this.handleExchangeProducts(activity);
            log.debug("\u6d3b\u52a8{}\u7684\u6362\u8d2d\u5546\u54c1\u5904\u7406\u5b8c\u6210\uff0c\u5171{}\u6761", (Object)activity.getActivityCode(), (Object)exchangeProductRows.size());
            allProductRows.addAll(activityProductRows);
            allProductRows.addAll(exchangeProductRows);
        }
        this.generateSerialNumber(allProductRows);
        log.debug("\u5e8f\u53f7\u751f\u6210\u5b8c\u6210\uff0c\u5171{}\u6761\u6570\u636e", (Object)allProductRows.size());
        Map<String, CustomerInfo> customerInfoMap = this.queryAllCustomerInfo(activityBases);
        log.debug("\u5ba2\u6237\u4fe1\u606f\u67e5\u8be2\u5b8c\u6210\uff0c\u5171{}\u4e2a\u6d3b\u52a8\u7684\u5ba2\u6237\u4fe1\u606f", (Object)customerInfoMap.size());
        this.supplementCustomerInfo(allProductRows, customerInfoMap);
        log.debug("\u5ba2\u6237\u4fe1\u606f\u8865\u5145\u5b8c\u6210");
        this.supplementActivityTimeAndStatus(allProductRows, activityBases);
        log.debug("\u6d3b\u52a8\u65f6\u95f4\u548c\u72b6\u6001\u8865\u5145\u5b8c\u6210");
        this.sortExportRows(allProductRows);
        log.debug("\u6570\u636e\u6392\u5e8f\u5b8c\u6210");
        log.info("\u7eafJDBC\u5bfc\u51fa\u5b8c\u6210\uff0c\u5171{}\u6761\u6570\u636e", (Object)allProductRows.size());
        return allProductRows;
    }

    private List<ActivityBase> queryActivityBases(String orgId) {
        log.debug("\u5f00\u59cb\u67e5\u8be2\u7ec4\u7ec7{}\u7684\u6d3b\u52a8\u57fa\u7840\u4fe1\u606f", (Object)orgId);
        String sql = "SELECT id, activity_code, activity_name, organization_name, select_type, begin_time, end_time, activity_status FROM yx_prod_report.mk_activity WHERE organization_id = ? AND dr = 0";
        List result = this.jdbcTemplate.query(sql, new Object[]{orgId}, (rs, rowNum) -> {
            ActivityBase base = new ActivityBase();
            base.setId(rs.getString("id"));
            base.setActivityCode(rs.getString("activity_code"));
            base.setActivityName(rs.getString("activity_name"));
            base.setOrganizationName(rs.getString("organization_name"));
            base.setSelectType(rs.getInt("select_type"));
            base.setBeginTime(rs.getString("begin_time"));
            base.setEndTime(rs.getString("end_time"));
            base.setActivityStatus(rs.getString("activity_status"));
            log.trace("\u67e5\u8be2\u5230\u6d3b\u52a8\uff1a{} - {}", (Object)base.getActivityCode(), (Object)base.getActivityName());
            return base;
        });
        log.debug("\u67e5\u8be2\u5230{}\u4e2a\u6d3b\u52a8\u57fa\u7840\u4fe1\u606f", (Object)result.size());
        return result;
    }

    private List<PromotionExportRow> handleActivityProducts(ActivityBase activity) {
        log.debug("\u5f00\u59cb\u5904\u7406\u6d3b\u52a8{}\u7684\u6d3b\u52a8\u5546\u54c1", (Object)activity.getActivityCode());
        ArrayList<PromotionExportRow> rows = new ArrayList<PromotionExportRow>();
        ExchangeCondition exchangeCondition = this.queryExchangeCondition(activity.getId());
        log.trace("\u6d3b\u52a8{}\u7684\u6362\u8d2d\u6761\u4ef6\uff1a{}", (Object)activity.getActivityCode(), (Object)(exchangeCondition != null ? exchangeCondition.getExchangeMethod() : "\u65e0"));
        if (activity.getSelectType() == 1) {
            String sql = "SELECT sku.code AS product_code, item.name AS product_name, price.item_price AS suggest_price FROM yx_prod_report.mk_activity_item t2 LEFT JOIN yx_prod_report.it_item_sku sku ON sku.id = t2.sku_id LEFT JOIN yx_prod_report.it_item item ON item.id = sku.item_id LEFT JOIN yx_prod_report.pr_base_price_item price ON price.sku_id = sku.id AND price.type_id = ? WHERE t2.activity_id = ? AND t2.dr = 0";
            List productMaps = this.jdbcTemplate.queryForList(sql, new Object[]{PRICE_TYPE_ID, activity.getId()});
            if (productMaps.isEmpty()) {
                log.warn("\u6d3b\u52a8{}\u7684select_type\u4e3a1\uff08\u6307\u5b9a\u5546\u54c1\uff09\uff0c\u4f46\u672a\u627e\u5230\u5173\u8054\u5546\u54c1", (Object)activity.getActivityCode());
                PromotionExportRow row = this.buildBaseRow(activity, "\u6d3b\u52a8\u5546\u54c1");
                this.fillActivityProductFields(row, null, exchangeCondition);
                rows.add(row);
            } else {
                log.debug("\u6d3b\u52a8{}\u627e\u5230{}\u4e2a\u6307\u5b9a\u5546\u54c1", (Object)activity.getActivityCode(), (Object)productMaps.size());
                for (Map map : productMaps) {
                    PromotionExportRow row = this.buildBaseRow(activity, "\u6d3b\u52a8\u5546\u54c1");
                    this.fillActivityProductFields(row, map, exchangeCondition);
                    rows.add(row);
                    log.trace("\u6dfb\u52a0\u6d3b\u52a8\u5546\u54c1\uff1a{} - {}", (Object)row.getProductCode(), (Object)row.getProductName());
                }
            }
        } else {
            log.debug("\u6d3b\u52a8{}\u7684select_type\u4e3a0\uff08\u4e0d\u9650\u5546\u54c1\uff09", (Object)activity.getActivityCode());
            PromotionExportRow row = this.buildBaseRow(activity, "\u6d3b\u52a8\u5546\u54c1");
            row.setProductCode("\u4e0d\u9650");
            row.setProductName("-");
            row.setPrice("-");
            row.setExchangePrice("-");
            row.setNotAloneBuy("-");
            row.setExchangeMethod(exchangeCondition != null ? exchangeCondition.getExchangeMethod() : "-");
            row.setQuotaType("-");
            row.setRatio("-");
            rows.add(row);
            log.trace("\u6dfb\u52a0\u4e0d\u9650\u5546\u54c1\u884c");
        }
        return rows;
    }

    private List<PromotionExportRow> handleExchangeProducts(ActivityBase activity) {
        log.debug("\u5f00\u59cb\u5904\u7406\u6d3b\u52a8{}\u7684\u6362\u8d2d\u5546\u54c1", (Object)activity.getActivityCode());
        ArrayList<PromotionExportRow> rows = new ArrayList<PromotionExportRow>();
        String conditionSql = "SELECT condition_params FROM yx_prod_report.mk_condition WHERE activity_id = ? AND condition_template_id = ?";
        String jsonStr = null;
        try {
            jsonStr = (String)this.jdbcTemplate.queryForObject(conditionSql, new Object[]{activity.getId(), EXCHANGE_CONDITION_TEMPLATE_ID}, String.class);
        }
        catch (Exception e) {
            log.warn("\u6d3b\u52a8{}\u65e0\u6362\u8d2d\u6761\u4ef6\u914d\u7f6e\uff0c\u9519\u8bef\uff1a{}", (Object)activity.getActivityCode(), (Object)e.getMessage());
            return rows;
        }
        if (!StringUtils.hasText((String)jsonStr)) {
            log.warn("\u6d3b\u52a8{}\u65e0\u6362\u8d2d\u6761\u4ef6\u914d\u7f6e", (Object)activity.getActivityCode());
            return rows;
        }
        log.trace("\u6d3b\u52a8{}\u7684\u6362\u8d2d\u6761\u4ef6JSON\u957f\u5ea6\uff1a{}", (Object)activity.getActivityCode(), (Object)jsonStr.length());
        try {
            JSONObject root = JSON.parseObject((String)jsonStr);
            JSONObject exchangeRule = root.getJSONObject("ExchangeCondition.rule");
            if (exchangeRule == null) {
                log.warn("\u6d3b\u52a8{}\u6362\u8d2d\u6761\u4ef6JSON\u683c\u5f0f\u9519\u8bef\uff0c\u627e\u4e0d\u5230ExchangeCondition.rule\u8282\u70b9", (Object)activity.getActivityCode());
                return rows;
            }
            String thresholdType = exchangeRule.getString("thresholdType");
            String exchangeMethod = this.parseExchangeMethod(thresholdType);
            JSONObject excRuleContent = exchangeRule.getJSONArray("excRuleContents").getJSONObject(0);
            int discountUnit = excRuleContent.getIntValue("discountUnit");
            String quotaType = discountUnit == 1 ? "\u91d1\u989d" : (discountUnit == 2 ? "\u6570\u91cf" : "-");
            int threshold = excRuleContent.getIntValue("threshold");
            int discount = excRuleContent.getIntValue("discount");
            String ratio = threshold + ":" + discount;
            log.trace("\u6d3b\u52a8{}\u7684\u6362\u8d2d\u65b9\u5f0f\uff1a{}\uff0c\u989d\u5ea6\u7c7b\u578b\uff1a{}\uff0c\u6bd4\u4f8b\uff1a{}", new Object[]{activity.getActivityCode(), exchangeMethod, quotaType, ratio});
            JSONArray exchangeItems = excRuleContent.getJSONArray("exchangeItems");
            if (exchangeItems == null || exchangeItems.isEmpty()) {
                log.warn("\u6d3b\u52a8{}\u65e0\u6362\u8d2d\u5546\u54c1\u914d\u7f6e", (Object)activity.getActivityCode());
                return rows;
            }
            log.debug("\u6d3b\u52a8{}\u627e\u5230{}\u4e2a\u6362\u8d2d\u5546\u54c1", (Object)activity.getActivityCode(), (Object)exchangeItems.size());
            for (int i = 0; i < exchangeItems.size(); ++i) {
                JSONObject itemJson = exchangeItems.getJSONObject(i);
                String skuId = itemJson.getString("skuId");
                if (!StringUtils.hasText((String)skuId)) {
                    log.warn("\u6d3b\u52a8{}\u7684\u7b2c{}\u4e2a\u6362\u8d2d\u5546\u54c1SKU ID\u4e3a\u7a7a\uff0c\u8df3\u8fc7", (Object)activity.getActivityCode(), (Object)i);
                    continue;
                }
                String productSql = "SELECT sku.code AS product_code, item.name AS product_name, price.item_price AS suggest_price FROM yx_prod_report.it_item_sku sku LEFT JOIN yx_prod_report.it_item item ON item.id = sku.item_id LEFT JOIN yx_prod_report.pr_base_price_item price ON price.sku_id = sku.id AND price.type_id = ? WHERE sku.id = ? AND item.dr = 0";
                List productMaps = this.jdbcTemplate.queryForList(productSql, new Object[]{PRICE_TYPE_ID, skuId});
                PromotionExportRow row = this.buildBaseRow(activity, "\u6362\u8d2d\u5546\u54c1");
                if (!productMaps.isEmpty()) {
                    Map productMap = (Map)productMaps.get(0);
                    row.setProductCode((String)productMap.get("product_code"));
                    row.setProductName((String)productMap.get("product_name"));
                    row.setPrice(this.formatPrice(productMap.get("suggest_price")));
                    log.trace("\u6362\u8d2d\u5546\u54c1{}\u4fe1\u606f\u5df2\u586b\u5145", (Object)row.getProductCode());
                } else {
                    log.warn("\u6d3b\u52a8{}\u7684\u6362\u8d2d\u5546\u54c1SKU ID={}\u672a\u627e\u5230\u5546\u54c1\u4fe1\u606f", (Object)activity.getActivityCode(), (Object)skuId);
                    row.setProductCode("\u672a\u77e5\u5546\u54c1");
                    row.setProductName("\u672a\u77e5\u5546\u54c1");
                    row.setPrice("-");
                }
                row.setExchangePrice(itemJson.getBigDecimal("exchangePrice").toString());
                row.setNotAloneBuy(itemJson.getIntValue("supportSingleBuy") == 1 ? "\u662f" : "\u5426");
                row.setExchangeMethod(exchangeMethod);
                row.setQuotaType(quotaType);
                row.setRatio(ratio);
                rows.add(row);
                log.trace("\u6dfb\u52a0\u6362\u8d2d\u5546\u54c1\uff1a{} - {}", (Object)row.getProductCode(), (Object)row.getProductName());
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u6d3b\u52a8{}\u7684\u6362\u8d2d\u6761\u4ef6JSON\u5931\u8d25", (Object)activity.getActivityCode(), (Object)e);
            return rows;
        }
        return rows;
    }

    private void generateSerialNumber(List<PromotionExportRow> rows) {
        log.debug("\u5f00\u59cb\u751f\u6210\u5e8f\u53f7\uff0c\u5171{}\u6761\u6570\u636e", (Object)rows.size());
        Map<String, List<PromotionExportRow>> activityGroups = rows.stream().collect(Collectors.groupingBy(PromotionExportRow::getActivityCode));
        ArrayList<String> sortedActivityCodes = new ArrayList<String>(activityGroups.keySet());
        sortedActivityCodes.sort(Comparator.naturalOrder());
        log.debug("\u6d3b\u52a8\u5206\u7ec4\u5b8c\u6210\uff0c\u5171{}\u4e2a\u6d3b\u52a8", (Object)sortedActivityCodes.size());
        int serialNumber = 1;
        for (String activityCode : sortedActivityCodes) {
            List<PromotionExportRow> groupRows = activityGroups.get(activityCode);
            for (PromotionExportRow row : groupRows) {
                row.setIndex(serialNumber);
            }
            log.trace("\u6d3b\u52a8{}\u5206\u914d\u5e8f\u53f7\uff1a{}", (Object)activityCode, (Object)serialNumber);
            ++serialNumber;
        }
        log.debug("\u5e8f\u53f7\u751f\u6210\u5b8c\u6210\uff0c\u6700\u5927\u5e8f\u53f7\uff1a{}", (Object)(serialNumber - 1));
    }

    private Map<String, CustomerInfo> queryAllCustomerInfo(List<ActivityBase> activities) {
        HashMap<String, CustomerInfo> resultMap = new HashMap<String, CustomerInfo>();
        for (ActivityBase activity : activities) {
            CustomerInfo info = this.queryCustomerInfo(activity.getId());
            resultMap.put(activity.getActivityCode(), info);
            log.trace("\u6d3b\u52a8{}\u7684\u5ba2\u6237\u4fe1\u606f\uff1a{} - {}", new Object[]{activity.getActivityCode(), info.getCustomerType(), info.getCustomerDetail()});
        }
        return resultMap;
    }

    private CustomerInfo queryCustomerInfo(String activityId) {
        log.debug("\u67e5\u8be2\u6d3b\u52a8{}\u7684\u5ba2\u6237\u4fe1\u606f", (Object)activityId);
        String sql = "SELECT condition_params FROM yx_prod_report.mk_condition WHERE activity_id = ? AND condition_template_id = ?";
        String jsonStr = null;
        try {
            jsonStr = (String)this.jdbcTemplate.queryForObject(sql, new Object[]{activityId, CUSTOMER_CONDITION_TEMPLATE_ID}, String.class);
        }
        catch (Exception e) {
            log.warn("\u6d3b\u52a8{}\u65e0\u5ba2\u6237\u6761\u4ef6\u914d\u7f6e\uff0c\u9519\u8bef\uff1a{}", (Object)activityId, (Object)e.getMessage());
            return new CustomerInfo(activityId, "\u4e0d\u9650\u5ba2\u6237", "");
        }
        if (!StringUtils.hasText((String)jsonStr)) {
            log.debug("\u6d3b\u52a8{}\u65e0\u5ba2\u6237\u6761\u4ef6\u914d\u7f6e", (Object)activityId);
            return new CustomerInfo(activityId, "\u4e0d\u9650\u5ba2\u6237", "");
        }
        log.trace("\u6d3b\u52a8{}\u7684\u5ba2\u6237\u6761\u4ef6JSON\u957f\u5ea6\uff1a{}", (Object)activityId, (Object)jsonStr.length());
        try {
            JSONObject root = JSON.parseObject((String)jsonStr);
            int customerType = root.getIntValue("TargetCustomerCondition.type");
            JSONObject customerValue = root.getJSONObject("TargetCustomerCondition.value");
            log.trace("\u6d3b\u52a8{}\u7684\u5ba2\u6237\u7c7b\u578b\uff1a{}", (Object)activityId, (Object)customerType);
            if (customerType == 1) {
                String blackNames;
                JSONArray blackIds;
                String areaNames;
                JSONArray areaCodes;
                String typeNames;
                String typeStr = "\u6307\u5b9a\u7c7b\u578b";
                StringBuilder detailSb = new StringBuilder();
                JSONArray typeIds = customerValue.getJSONArray("customerTypeIds");
                if (typeIds != null && !typeIds.isEmpty() && StringUtils.hasText((String)(typeNames = this.queryCustomerTypeNames(typeIds)))) {
                    detailSb.append("\u5ba2\u6237\u7c7b\u578b: ").append(typeNames).append("\n");
                    log.trace("\u6d3b\u52a8{}\u7684\u5ba2\u6237\u7c7b\u578b\uff1a{}", (Object)activityId, (Object)typeNames);
                }
                if ((areaCodes = customerValue.getJSONArray("customerAreaCodes")) != null && !areaCodes.isEmpty() && StringUtils.hasText((String)(areaNames = this.queryCustomerAreaNames(areaCodes)))) {
                    detailSb.append("\u5ba2\u6237\u533a\u57df: ").append(areaNames).append("\n");
                    log.trace("\u6d3b\u52a8{}\u7684\u5ba2\u6237\u533a\u57df\uff1a{}", (Object)activityId, (Object)areaNames);
                }
                if ((blackIds = customerValue.getJSONArray("blackCustomerIds")) != null && !blackIds.isEmpty() && StringUtils.hasText((String)(blackNames = this.queryCustomerNames(blackIds)))) {
                    detailSb.append("\u5254\u9664\u5ba2\u6237: ").append(blackNames).append("\n");
                    log.trace("\u6d3b\u52a8{}\u7684\u5254\u9664\u5ba2\u6237\uff1a{}", (Object)activityId, (Object)blackNames);
                }
                String detail = detailSb.toString().trim();
                log.debug("\u6d3b\u52a8{}\u7684\u5ba2\u6237\u660e\u7ec6\uff1a{}", (Object)activityId, (Object)detail);
                return new CustomerInfo(activityId, typeStr, detail);
            }
            if (customerType == 2) {
                String typeStr = "\u6307\u5b9a\u5ba2\u6237";
                JSONArray customerIds = customerValue.getJSONArray("customerIds");
                String customerNames = customerIds != null ? this.queryCustomerNames(customerIds) : "";
                log.debug("\u6d3b\u52a8{}\u7684\u6307\u5b9a\u5ba2\u6237\uff1a{}", (Object)activityId, (Object)customerNames);
                return new CustomerInfo(activityId, typeStr, customerNames);
            }
            log.debug("\u6d3b\u52a8{}\u7684\u5ba2\u6237\u7c7b\u578b\u4e3a\u5176\u4ed6\uff0c\u8fd4\u56de\u4e0d\u9650\u5ba2\u6237", (Object)activityId);
            return new CustomerInfo(activityId, "\u4e0d\u9650\u5ba2\u6237", "");
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u6d3b\u52a8{}\u7684\u5ba2\u6237\u6761\u4ef6JSON\u5931\u8d25", (Object)activityId, (Object)e);
            return new CustomerInfo(activityId, "\u4e0d\u9650\u5ba2\u6237", "");
        }
    }

    private void supplementActivityTimeAndStatus(List<PromotionExportRow> rows, List<ActivityBase> activityBases) {
        log.debug("\u5f00\u59cb\u8865\u5145\u6d3b\u52a8\u65f6\u95f4\u548c\u72b6\u6001\uff0c\u5171{}\u6761\u6570\u636e", (Object)rows.size());
        Map<String, ActivityBase> activityMap = activityBases.stream().collect(Collectors.toMap(ActivityBase::getId, activity -> activity));
        for (PromotionExportRow row : rows) {
            ActivityBase activity2 = activityMap.get(row.getActivityId());
            if (activity2 != null) {
                row.setActivityStartTime(activity2.getBeginTime());
                row.setActivityEndTime(activity2.getEndTime());
                row.setActivityStatus(this.parseActivityStatus(activity2.getActivityStatus()));
                log.trace("\u4e3a\u6d3b\u52a8{}\u8865\u5145\u65f6\u95f4\u548c\u72b6\u6001\u4fe1\u606f", (Object)row.getActivityCode());
                continue;
            }
            log.warn("\u627e\u4e0d\u5230\u6d3b\u52a8ID={}\u7684\u57fa\u7840\u4fe1\u606f", (Object)row.getActivityId());
            row.setActivityStartTime("-");
            row.setActivityEndTime("-");
            row.setActivityStatus("-");
        }
        log.debug("\u6d3b\u52a8\u65f6\u95f4\u548c\u72b6\u6001\u8865\u5145\u5b8c\u6210");
    }

    private void sortExportRows(List<PromotionExportRow> rows) {
        log.debug("\u5f00\u59cb\u6392\u5e8f\uff0c\u5171{}\u6761\u6570\u636e", (Object)rows.size());
        rows.sort(Comparator.comparingInt(PromotionExportRow::getIndex).thenComparing(row -> "\u6d3b\u52a8\u5546\u54c1".equals(row.getProductType()) ? 0 : 1).thenComparing(PromotionExportRow::getProductCode));
        log.debug("\u6570\u636e\u6392\u5e8f\u5b8c\u6210");
    }

    private PromotionExportRow buildBaseRow(ActivityBase activity, String productType) {
        PromotionExportRow row = new PromotionExportRow();
        row.setActivityId(activity.getId());
        row.setDivision(activity.getOrganizationName());
        row.setActivityCode(activity.getActivityCode());
        row.setActivityName(activity.getActivityName());
        row.setProductType(productType);
        row.setCustomerType("");
        row.setCustomerDetail("");
        row.setActivityStartTime("");
        row.setActivityEndTime("");
        row.setActivityStatus("");
        return row;
    }

    private void fillActivityProductFields(PromotionExportRow row, Map<String, Object> productMap, ExchangeCondition exchangeCondition) {
        if (productMap != null) {
            row.setProductCode((String)productMap.get("product_code"));
            row.setProductName((String)productMap.get("product_name"));
            row.setPrice(this.formatPrice(productMap.get("suggest_price")));
        } else {
            row.setProductCode("-");
            row.setProductName("-");
            row.setPrice("-");
        }
        row.setExchangePrice("-");
        row.setNotAloneBuy("-");
        row.setExchangeMethod(exchangeCondition != null ? exchangeCondition.getExchangeMethod() : "-");
        row.setQuotaType(exchangeCondition != null ? exchangeCondition.getQuotaType() : "-");
        row.setRatio(exchangeCondition != null ? exchangeCondition.getRatio() : "-");
    }

    private ExchangeCondition queryExchangeCondition(String activityId) {
        log.debug("\u67e5\u8be2\u6d3b\u52a8{}\u7684\u6362\u8d2d\u6761\u4ef6", (Object)activityId);
        String sql = "SELECT condition_params FROM yx_prod_report.mk_condition WHERE activity_id = ? AND condition_template_id = ?";
        String jsonStr = null;
        try {
            jsonStr = (String)this.jdbcTemplate.queryForObject(sql, new Object[]{activityId, EXCHANGE_CONDITION_TEMPLATE_ID}, String.class);
        }
        catch (Exception e) {
            log.warn("\u6d3b\u52a8{}\u65e0\u6362\u8d2d\u6761\u4ef6\u914d\u7f6e\uff0c\u9519\u8bef\uff1a{}", (Object)activityId, (Object)e.getMessage());
            return null;
        }
        if (!StringUtils.hasText((String)jsonStr)) {
            log.debug("\u6d3b\u52a8{}\u65e0\u6362\u8d2d\u6761\u4ef6\u914d\u7f6e", (Object)activityId);
            return null;
        }
        log.trace("\u6d3b\u52a8{}\u7684\u6362\u8d2d\u6761\u4ef6JSON\u957f\u5ea6\uff1a{}", (Object)activityId, (Object)jsonStr.length());
        try {
            JSONObject root = JSON.parseObject((String)jsonStr);
            JSONObject exchangeRule = root.getJSONObject("ExchangeCondition.rule");
            if (exchangeRule == null) {
                log.warn("\u6d3b\u52a8{}\u6362\u8d2d\u6761\u4ef6JSON\u683c\u5f0f\u9519\u8bef\uff0c\u627e\u4e0d\u5230ExchangeCondition.rule\u8282\u70b9", (Object)activityId);
                return null;
            }
            String thresholdType = exchangeRule.getString("thresholdType");
            String exchangeMethod = this.parseExchangeMethod(thresholdType);
            JSONObject excRuleContent = exchangeRule.getJSONArray("excRuleContents").getJSONObject(0);
            int unit = excRuleContent.getIntValue("unit");
            String quotaType = unit == 1 ? "\u91d1\u989d" : (unit == 2 ? "\u6570\u91cf" : "-");
            int threshold = excRuleContent.getIntValue("threshold");
            int discount = excRuleContent.getIntValue("discount");
            String ratio = threshold + ":" + discount;
            ExchangeCondition condition = new ExchangeCondition();
            condition.setExchangeMethod(exchangeMethod);
            condition.setQuotaType(quotaType);
            condition.setRatio(ratio);
            log.trace("\u6d3b\u52a8{}\u7684\u6362\u8d2d\u65b9\u5f0f\uff1a{}\uff0c\u989d\u5ea6\u7c7b\u578b\uff1a{}", new Object[]{activityId, exchangeMethod, quotaType});
            return condition;
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u6d3b\u52a8{}\u7684\u6362\u8d2d\u6761\u4ef6JSON\u5931\u8d25", (Object)activityId, (Object)e);
            return null;
        }
    }

    private String parseExchangeMethod(String thresholdType) {
        if ("0".equals(thresholdType)) {
            return "\u514d\u8d39\u6362\u8d2d";
        }
        if (PRICE_TYPE_ID.equals(thresholdType)) {
            return "\u52a0\u4ef7\u6362\u8d2d";
        }
        return "-";
    }

    private String parseActivityStatus(String status) {
        HashMap<String, String> statusMap = new HashMap<String, String>();
        statusMap.put("NEW", "\u65b0\u5efa");
        statusMap.put("READY", "\u5c31\u7eea");
        statusMap.put("ACTIVATE", "\u6d3b\u52a8\u4e2d");
        statusMap.put("PAUSE", "\u6682\u505c");
        statusMap.put("FINISH", "\u6d3b\u52a8\u7ed3\u675f");
        return statusMap.getOrDefault(status, "\u672a\u77e5\u72b6\u6001");
    }

    private String formatPrice(Object priceObj) {
        if (priceObj == null) {
            return "-";
        }
        if (priceObj instanceof BigDecimal) {
            return ((BigDecimal)priceObj).toString();
        }
        return priceObj.toString();
    }

    private String queryCustomerTypeNames(JSONArray typeIds) {
        if (typeIds == null || typeIds.isEmpty()) {
            return "";
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < typeIds.size(); ++i) {
            idList.add(typeIds.getString(i));
        }
        String placeholders = String.join((CharSequence)",", Collections.nCopies(idList.size(), "?"));
        String sql = "SELECT name FROM cs_customer_type WHERE id IN (" + placeholders + ")";
        List names = this.jdbcTemplate.query(sql, idList.toArray(), (rs, rowNum) -> rs.getString("name"));
        return String.join((CharSequence)"\u3001", names);
    }

    private String queryCustomerAreaNames(JSONArray areaCodes) {
        if (areaCodes == null || areaCodes.isEmpty()) {
            return "";
        }
        ArrayList<String> codeList = new ArrayList<String>();
        for (int i = 0; i < areaCodes.size(); ++i) {
            codeList.add(areaCodes.getString(i));
        }
        String placeholders = String.join((CharSequence)",", Collections.nCopies(codeList.size(), "?"));
        String sql = "SELECT name FROM cs_customer_area WHERE code IN (" + placeholders + ")";
        List names = this.jdbcTemplate.query(sql, codeList.toArray(), (rs, rowNum) -> rs.getString("name"));
        return String.join((CharSequence)"\u3001", names);
    }

    private String queryCustomerNames(JSONArray customerIds) {
        if (customerIds == null || customerIds.isEmpty()) {
            return "";
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < customerIds.size(); ++i) {
            idList.add(customerIds.getString(i));
        }
        String placeholders = String.join((CharSequence)",", Collections.nCopies(idList.size(), "?"));
        String sql = "SELECT name FROM cs_customer WHERE id IN (" + placeholders + ")";
        List names = this.jdbcTemplate.query(sql, idList.toArray(), (rs, rowNum) -> rs.getString("name"));
        return String.join((CharSequence)"\u3001", names);
    }

    private void supplementCustomerInfo(List<PromotionExportRow> rows, Map<String, CustomerInfo> customerInfoMap) {
        log.debug("\u5f00\u59cb\u8865\u5145\u5ba2\u6237\u4fe1\u606f\uff0c\u5171{}\u6761\u6570\u636e", (Object)rows.size());
        for (PromotionExportRow row : rows) {
            CustomerInfo info = customerInfoMap.get(row.getActivityCode());
            if (info != null) {
                row.setCustomerType(info.getCustomerType());
                row.setCustomerDetail(info.getCustomerDetail());
                log.trace("\u4e3a\u6d3b\u52a8{}\u8865\u5145\u5ba2\u6237\u4fe1\u606f", (Object)row.getActivityCode());
                continue;
            }
            log.warn("\u627e\u4e0d\u5230\u6d3b\u52a8{}\u7684\u5ba2\u6237\u4fe1\u606f", (Object)row.getActivityCode());
            row.setCustomerType("");
            row.setCustomerDetail("");
        }
        log.debug("\u5ba2\u6237\u4fe1\u606f\u8865\u5145\u5b8c\u6210");
    }

    private static class ExchangeCondition {
        private String exchangeMethod;
        private String quotaType;
        private String ratio;

        private ExchangeCondition() {
        }

        public String getExchangeMethod() {
            return this.exchangeMethod;
        }

        public void setExchangeMethod(String exchangeMethod) {
            this.exchangeMethod = exchangeMethod;
        }

        public String getQuotaType() {
            return this.quotaType;
        }

        public void setQuotaType(String quotaType) {
            this.quotaType = quotaType;
        }

        public String getRatio() {
            return this.ratio;
        }

        public void setRatio(String ratio) {
            this.ratio = ratio;
        }
    }

    private static class ActivityBase {
        private String id;
        private String activityCode;
        private String activityName;
        private String organizationName;
        private int selectType;
        private String beginTime;
        private String endTime;
        private String activityStatus;

        private ActivityBase() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getActivityCode() {
            return this.activityCode;
        }

        public void setActivityCode(String activityCode) {
            this.activityCode = activityCode;
        }

        public String getActivityName() {
            return this.activityName;
        }

        public void setActivityName(String activityName) {
            this.activityName = activityName;
        }

        public String getOrganizationName() {
            return this.organizationName;
        }

        public void setOrganizationName(String organizationName) {
            this.organizationName = organizationName;
        }

        public int getSelectType() {
            return this.selectType;
        }

        public void setSelectType(int selectType) {
            this.selectType = selectType;
        }

        public String getBeginTime() {
            return this.beginTime;
        }

        public void setBeginTime(String beginTime) {
            this.beginTime = beginTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public String getActivityStatus() {
            return this.activityStatus;
        }

        public void setActivityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
        }
    }
}

