package com.dtyunxi.tcbj.api.biz.inventory;

import com.dtyunxi.tcbj.api.biz.inventory.dto.QueryExternalSystemCodeReq;
import com.dtyunxi.tcbj.api.biz.inventory.dto.QueryExternalSystemCodeResp;
import com.dtyunxi.tcbj.api.biz.inventory.dto.ExternalSystemCodeDto;
import lombok.extern.log4j.Log4j2;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@Service
@Log4j2
public class ItemQuery2025Service {

    @Resource
    private JdbcTemplate jdbcTemplate;

    public QueryExternalSystemCodeResp queryItemExternalCode(QueryExternalSystemCodeReq req) {
        log.info("根据仓库编码和SAP商品编码查询外围系统编码，请求参数：{}", req);

        String warehouseCode = req.getWarehouseCode();
        List<String> skuCodes = req.getSkuCodes();
        if (warehouseCode == null || skuCodes == null || skuCodes.isEmpty()) {
            return QueryExternalSystemCodeResp.builder()
                    .externalSystemCodeList(Collections.emptyList())
                    .build();
        }

        log.info("查询的仓库编码：{}，SAP商品编码列表：{}", warehouseCode, skuCodes);

        List<ExternalSystemCodeDto> externalSystemCodeList = queryExternalSystemCodeFromDatabase(warehouseCode, skuCodes);

        log.info("查询完成，返回结果数量：{}", externalSystemCodeList.size());

        return QueryExternalSystemCodeResp.builder()
                .externalSystemCodeList(externalSystemCodeList)
                .build();
    }

    /**
     * 根据仓库编码和SAP商品编码查询外围系统编码
     */
    private List<ExternalSystemCodeDto> queryExternalSystemCodeFromDatabase(String warehouseCode, List<String> skuCodes) {
        String inSql = skuCodes.stream()
                .map(skuCode -> "'" + skuCode + "'")
                .collect(Collectors.joining(","));

        String sql = "SELECT auth.id AS authId, " +
                     "       shop.code AS tenantId, " +
                     "       shop.name AS tenantName, " +
                     "       warehouse.warehouse_code AS warehouseCode, " +
                     "       warehouse.warehouse_name AS warehouseName, " +
                     "       sku.code AS skuCode, " +
                     "       auth.external_code AS externalCode " +
                     "FROM it_item_auth auth " +
                     "INNER JOIN it_item_sku sku ON sku.id = auth.business_id AND sku.dr = 0 " +
                     "INNER JOIN sc_shop shop ON shop.id = auth.target_id AND target_type = '2' AND shop.dr = 0 " +
                     "INNER JOIN cs_logic_warehouse warehouse ON warehouse.organization_id = shop.organization_id AND warehouse.dr = 0 " +
                     "WHERE auth.dr = 0 " +
                     "  AND warehouse.warehouse_code = ? " +
                     "  AND sku.code IN (" + inSql + ")";

        return jdbcTemplate.query(sql, new Object[]{warehouseCode}, (rs, rowNum) -> {
            ExternalSystemCodeDto dto = new ExternalSystemCodeDto();
            dto.setAuthId(rs.getLong("authId"));
            dto.setTenantId(rs.getString("tenantId"));
            dto.setTenantName(rs.getString("tenantName"));
            dto.setWarehouseCode(rs.getString("warehouseCode"));
            dto.setWarehouseName(rs.getString("warehouseName"));
            dto.setSkuCode(rs.getString("skuCode"));
            dto.setExternalCode(rs.getString("externalCode"));
            return dto;
        });
    }
}
