package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "QueryCustomerOrgInfoRespDto", description = "关联org表查询Customer信息")
public class QueryCustomerOrgInfoRespDto {

    @ApiModelProperty(value = "customer.id")
    private String cusId;

    @ApiModelProperty(value = "customer.code")
    private String cusCode;

    @ApiModelProperty(value = "customer.third_party_id")
    private String cusThirdPartyId;

    @ApiModelProperty(value = "customer.third_parent_party_id")
    private String cusThirdParentPartyId;

    @ApiModelProperty(value = "customer.if_certification")
    private String ifCertification;

    @ApiModelProperty(value = "organization.id")
    private String orgId;

    @ApiModelProperty(value = "organization.tenant_id")
    private String tenantId;

    @ApiModelProperty(value = "organization_info.org_code")
    private String orgCode;

    @ApiModelProperty(value = "organization_info.org_name")
    private String orgName;

    @ApiModelProperty(value = "organization_info.credit_code")
    private String creditCode;

    @ApiModelProperty(value = "organization_info.legal_name")
    private String legalName;

    @ApiModelProperty(value = "organization_info.address")
    private String address;

    @ApiModelProperty(value = "existOrgInfo 0否 1是")
    private String existOrgInfo;

}
