package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
* 质检提单数据
*/
@Data
@ApiModel(value = "QualityInspectionDataSubmitReqDto", description = "质检提单数据")
public class QualityInspectionSubmitDataReqDto extends RequestDto{

    @ApiModelProperty(name = "orderNo", value = "委托单号")
    private String orderNo;

    @ApiModelProperty(name = "longCode", value = "物料编码")
    private String longCode;

    @ApiModelProperty(name = "itemName", value = "物料名称")
    private String itemName;

    @ApiModelProperty(name = "batch", value = "批号")
    private String batch;

    @ApiModelProperty(name = "supplier", value = "供应商名称")
    private String supplier;

    @ApiModelProperty(name = "ifUrgent", value = "是否加急")
    private String ifUrgent;

    @ApiModelProperty(name = "acceptDate", value = "受理日期")
    private String acceptDate;

    @ApiModelProperty(name = "submitTime", value = "提交时间")
    private String submitTime;

    @ApiModelProperty(name = "ifOutside", value = "是否外检")
    private String ifOutside;

    @ApiModelProperty(name = "theoryReportDate", value = "理论出报告日期")
    private String theoryReportDate;

    @ApiModelProperty(name = "overtime", value = "超期时间")
    private String overtime;

    @ApiModelProperty(name = "ifCertificateFull", value = "证件是否齐全")
    private String ifCertificateFull;

    @ApiModelProperty(name = "orderStatus", value = "委托单当前状态")
    private String orderStatus;

    @ApiModelProperty(name = "theoryMovePassWarehouseDate", value = "理论调到合格仓时间")
    private String theoryMovePassWarehouseDate;

    @ApiModelProperty(name = "overtimeMovePassWarehouseDate", value = "超期调到合格仓时间")
    private String overtimeMovePassWarehouseDate;
}
