package com.dtyunxi.tcbj.api.dto;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;
import java.util.List;

/**
 * 销售单合单数据监控DTO
 * @author jiejun
 */
@Getter
@Setter
public class SaleOrderMergeDataMonitorDto extends BaseRespDto {

    @ApiModelProperty(name = "searchOrderNo", value = "搜索单号")
    private String searchOrderNo;

    @ApiModelProperty(name = "platformOrderNo", value = "渠道单号")
    private String platformOrderNo;
    private List<String> platformOrderNoList;

    @ApiModelProperty(name = "platformOrderId", value = "渠道单ID")
    private Long platformOrderId;

    @ApiModelProperty(name = "orderType", value = "类型")
    private String orderType;

    @ApiModelProperty(name = "orderTypes", value = "类型")
    private List<String> orderTypes;

    @ApiModelProperty(name = "orderStatus", value = "订单状态")
    private String orderStatus;

    @ApiModelProperty(name = "saleOrderNo", value = "销售单号")
    private String saleOrderNo;

    @ApiModelProperty(name = "outNotice", value = "出库通知单")
    private String outNotice;

    @ApiModelProperty(name = "outResult", value = "出库结果单")
    private String outResult;

    @ApiModelProperty(name = "consignmentNo", value = "托运单")
    private String consignmentNo;

    @ApiModelProperty(name = "outPhysicsWarehouseCode", value = "出库物理仓编码")
    private String outPhysicsWarehouseCode;

    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "出库物理仓名称")
    private String outPhysicsWarehouseName;

    @ApiModelProperty(name = "createTime", value = "内部销售单创建时间")
    private Date createTime;

    @ApiModelProperty(name = "pssStatus", value = "经销存推送状态")
    private String pssStatus;

    private Integer pageNum = 1;
    private Integer pageSize = 10;
    private Date createTimeStart;//创建时间开始
    private Date createTimeEnd;//创建时间结束

}
