package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 分拣账单报表Eo对象
 *
 * @author longling
 * @since 2024-11-13
 */
@ApiModel(value = "SortingBillRespDto", description = "分拣账单报表Eo对象")
@Data
public class SortingBillRespDto extends BaseRespDto {
    /**
     *
     */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
     *  出库时间
     */
    @ApiModelProperty(name = "outWarehouseTime", value = "出库时间")
    private String outWarehouseTime;
    /**
     *  费用归属组织id
     */
    @ApiModelProperty(name = "expenseOrganizationId", value = "费用归属组织id")
    private String expenseOrganizationId;
    /**
     *  费用归属组织
     */
    @ApiModelProperty(name = "expenseOrganizationName", value = "费用归属组织")
    private String expenseOrganizationName;
    /**
     *  大箱数量
     */
    @ApiModelProperty(name = "bigBoxNum", value = "大箱数量")
    private BigDecimal bigBoxNum;
    /**
     *  小箱数量
     */
    @ApiModelProperty(name = "smallBoxNum", value = "小箱数量")
    @Column(name="small_box_num")
    private BigDecimal smallBoxNum;
    /**
     *  个数
     */
    @ApiModelProperty(name = "boxNum", value = "个数")
    private BigDecimal boxNum;
    /**
     *  调整类型；1：增加；2：减少
     */
    @ApiModelProperty(name = "adjustType", value = "调整类型；1：增加；2：减少")
    private Long adjustType;
    /**
     *  调整金额
     */
    @ApiModelProperty(name = "adjustNum", value = "调整金额")
    private BigDecimal adjustNum;
    /**
     *  调整备注
     */
    @ApiModelProperty(name = "adjustRemarks", value = "调整备注")
    private String adjustRemarks;
    /**
     *  分拣费
     */
    @ApiModelProperty(name = "sortingNum", value = "分拣费")
    private BigDecimal sortingNum;
    /**
     *  出库物理仓名称
     */
    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "出库物理仓名称")
    private String outPhysicsWarehouseName;
    /**
     *  出库物理仓编码
     */
    @ApiModelProperty(name = "outPhysicsWarehouseCode", value = "出库物理仓编码")
    private String outPhysicsWarehouseCode;
    /**
     * 是否归档,0未归档,1已归档
     */
    @ApiModelProperty(name = "placedFlag", value = "是否归档,0未归档,1已归档")
    private Integer placedFlag;
}
