package com.dtyunxi.tcbj.api.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.math.BigDecimal;

/**
 * 销售订单统计dto
 *
 * @author haoxiao
 * @since 2022-03-10
 */
@Data
@ApiModel(value = "SaleIntransitEarlyWarningCountRespDto", description = "销售在途预计统计dto")
public class SaleIntransitEarlyWarningCountRespDto {

    @Valid
    @ApiModelProperty(name="alreadyPickCount", value = "已配货")
    @JsonProperty("alreadyPickCount")
    private BigDecimal alreadyPickCount;

    @Valid
    @ApiModelProperty(name="waitDeliveryCount", value = "待发货数量")
    @JsonProperty("waitDeliveryCount")
    private BigDecimal waitDeliveryCount;

    @Valid
    @ApiModelProperty(name="completeCount", value = "已完成数量")
    @JsonProperty("completeCount")
    private BigDecimal completeCount;

    @Valid
    @ApiModelProperty(name="receivedCount", value = "已签收数量")
    @JsonProperty("receivedCount")
    private BigDecimal receivedCount;

    @Valid
    @ApiModelProperty(name="allCount", value = "全部数量")
    @JsonProperty("allCount")
    private BigDecimal allCount;


    @ApiModelProperty(name="errorCount", value = "异常数量")
    @JsonProperty("errorCount")
    private BigDecimal errorCount;

}
